summary: the linux kernel (the core of the linux operating system)

# What parts do we want to build?  We must build at least one kernel.
# These are the kernels that are built IF the architecture allows it.

%define buildup 0
%define buildsmp 0
%define buildsource 1
%define buildhugemem 0
%define buildlargesmp 0
%define buildxenU 1
%define buildxenUpae 0
%define builddoc 0
%define buildprepom 1
%define kabi 1

%define FC2 0
%define FC3 0

# Versions of various parts

#
# Polite request for people who spin their own kernel rpms:
# please modify the "release" field in a way that identifies
# that the kernel isn't the stock distribution kernel, for example by
# adding some text to the end of the version number.
#
%define release efw2
%define sublevel 9
%define kversion 2.6.%{sublevel}
%define rpmversion 2.6.%{sublevel}
%define signmodules 1
%define make_target vmlinuz
%define iptables_version 1.3.2
%define patchomatic_version 20050720


%if %{kabi}
# kABI_major needs to change whenever we make changes that would break
# existing modules.  kABI_minor needs to be bumped whenever we add exports
# (but otherwise maintain the ABI).  When kABI_major gets bumped, reset 
# kABI_minor to 0.
%define kabi_major 4.0
%define kabi_minor 0
%endif

%define KVERREL %{PACKAGE_VERSION}-%{PACKAGE_RELEASE}

# groups of related archs
%define all_x86 i686

# Override generic defaults with per-arch defaults 

%ifarch noarch
%define builddoc 1
%define buildsource 0
%define buildup 0
%define buildsmp 0
%define buildlargesmp 0
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}*.config
%endif

%ifnarch i686
%define buildhugemem 0
%endif

# Second, per-architecture exclusions (ifarch)

%ifarch %{all_x86}
%define buildlargesmp 0
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-i?86*.config
%define image_install_path boot
%define signmodules 0
%endif

%ifarch x86_64
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-x86_64*.config
%define image_install_path boot
%define signmodules 1
%endif

%ifarch ppc64
%define buildsmp 0
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-ppc64*.config
%define image_install_path boot
%define signmodules 1
%define make_target bzImage zImage.stub
%endif

%ifarch ppc64iseries
%define buildsmp 0
%define buildlargesmp 0
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-ppc64*.config
%define image_install_path boot
%define signmodules 1
%define make_target bzImage
%endif

%ifarch s390
%define buildsmp 0
%define buildlargesmp 0
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-s390*.config
%define image_install_path boot
%endif

%ifarch s390x
%define buildsmp 0
%define buildlargesmp 0
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-s390x.config
%define image_install_path boot
%endif

%ifarch ppc
%define buildlargesmp 0
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-ppc*.config
%define buildsmp 0
%define image_install_path boot
%endif

%ifarch ia64
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-ia64*.config
%define buildsmp 0
%define image_install_path boot/efi/EFI/redhat
%define signmodules 1
%endif


#
# Three sets of minimum package version requirements in the form of Conflicts:
# to versions below the minimum
#

#
# First the general kernel 2.6 required versions as per
# Documentation/Changes
#
%define kernel_dot_org_conflicts  ppp <= 2.3.15, pcmcia-cs <= 3.1.20, isdn4k-utils <= 3.0, mount < 2.10r-5, nfs-utils < 1.0.3, e2fsprogs < 1.29, util-linux < 2.10, jfsutils < 1.0.14, reiserfsprogs < 3.6.3, xfsprogs < 2.1.0, procps < 2.0.9, oprofile < 0.5.3

# 
# Then a series of requirements that are distribution specific, either 
# because we add patches for something, or the older versions have 
# problems with the newer kernel or lack certain things that make 
# integration in the distro harder than needed.
#
%define package_conflicts  cipe < 1.4.5, tux < 2.1.0, kudzu <= 0.92, initscripts < 7.23, dev < 3.2-7, iptables < 1.2.5-3, bcm5820 < 1.81, nvidia-rh72 <= 1.0, ipw2200-firmware < 2.2

#
# Several packages had bugs in them that became obvious when the NPTL
# threading code got integrated. 
#
%define nptl_conflicts SysVinit < 2.84-13, pam < 0.75-48, vixie-cron < 3.0.1-73, privoxy < 3.0.0-8, spamassassin < 2.44-4.8.x,  cups < 1.1.17-13

#
# Packages that need to be installed before the kernel is, because the %post
# scripts use them.
#
%define kernel_prereq  fileutils, module-init-tools, initscripts >= 5.83, mkinitrd >= 4.2.1.6-1

#
# don't use RPM's internal dependency generator, instead
# just use our magic one that finds the versions of kernel modules for
# provides and don't do any requires
# (we used to just turn off AutoReqProv on all packages)
#
%define _use_internal_dependency_generator 0
%define __find_provides /usr/lib/rpm/find-provides
%define __find_requires %{nil}

Name: kernel
Vendor: XenSource, Inc.
Group: System Environment/Kernel
License: GPLv2
Version: %{rpmversion}
Release: %{release}
Epoch: 1
ExclusiveArch: noarch %{all_x86} x86_64 ppc64 ppc64iseries s390 s390x ia64
ExclusiveOS: Linux
Provides: kernel = %{version}
Provides: kernel-drm = 4.3.0
Provides: kernel-%{_target_cpu} = %{rpmversion}-%{release}

%if %{kabi}
Provides: kABI(%{kabi_major}.%{_target_cpu}) = %{kabi_minor}
%endif

Prereq: %{kernel_prereq}
Conflicts: %{kernel_dot_org_conflicts}
Conflicts: %{package_conflicts}
Conflicts: %{nptl_conflicts}
# We can't let RPM do the dependencies automatic because it'll then pick up
# a correct but undesirable perl dependency from the module headers which
# isn't required for the kernel proper to function


#
# List the packages used during the kernel build
#
BuildPreReq: module-init-tools, patch >= 2.5.4, bash >= 2.03, tar
#BuildPreReq: bzip2, findutils, gzip, m4, perl, make >= 3.78, gnupg, kernel-utils 
BuildPreReq: bzip2, findutils, gzip, m4, perl, make >= 3.78, gnupg
#BuildRequires: gcc >= 2.96-98, binutils >= 2.12, redhat-rpm-config >= 8.0.32.1
BuildRequires: gcc >= 2.96-98, binutils >= 2.12
BuildConflicts: rhbuildsys(DiskFree) < 500Mb



Source0: ftp://ftp.kernel.org/pub/linux/kernel/v2.6/linux-%{kversion}.tar.bz2
Source2: http://www.netfilter.org/files/iptables-%{iptables_version}.tar.bz2
Source3: http://ftp.netfilter.org/pub/path-o-matic-ng/snapshot/patch-o-matic-ng-%{patchomatic_version}.tar.bz2

Source10: COPYING.modules
Source11: genkey
Source12: modsign_exclude

Source22: kernel-%{kversion}-i686.config
Source23: kernel-%{kversion}-i686-smp.config
Source24: kernel-%{kversion}-i686-hugemem.config
Source22: kernel-%{kversion}-i686-xenU.config
Source23: kernel-%{kversion}-i686-xenUpae.config
Source25: kernel-%{kversion}-x86_64.config
Source26: kernel-%{kversion}-x86_64-smp.config
Source27: kernel-%{kversion}-x86_64-largesmp.config
Source28: kernel-%{kversion}-ppc64.config
Source29: kernel-%{kversion}-ppc64iseries.config
Source30: kernel-%{kversion}-s390.config
Source31: kernel-%{kversion}-s390x.config
Source32: kernel-%{kversion}-ppc.config
Source33: kernel-%{kversion}-ia64.config
Source34: kernel-%{kversion}-ia64-largesmp.config
Source35: kernel-%{kversion}-ppc64-largesmp.config

Source100: linux-2.6.9-pom-20050720-CONNMARK.patch

#
# Patches 0 through 100 are meant for core subsystem upgrades
#
Patch3: patch-2.6.9-ac11.bz2
Patch4: linux-2.6.9-selected-ac-bits.patch

#
# Patches 10 to 100 are upstream patches we want to back out 
#
Patch10: linux-2.6.9-ac-backouts.patch
Patch11: linux-2.6.7-iobitmap.patch

# Patches 100 through 500 are meant for architecture patches

# 200 - 299   x86(-64)
Patch201: linux-2.6.9-x86_64-copy_user_generic-exception.patch
Patch202: linux-2.6.9-x86-share-cachedescriptors.patch
Patch203: linux-2.6.9-x86_64-configure-oops-stackdump.patch
Patch204: linux-2.6.9-x86_64-phys_proc_id-only-when-initialised.patch
Patch205: linux-2.6.9-x86_64-missing-compat-ioctls.patch
Patch206: linux-2.6.9-x86-show_trace-irq-context.patch
Patch207: linux-2.6.9-x86_64-lost-edge-triggered-irqs.patch
Patch208: linux-2.6.9-x86_64-mga-dri.patch
Patch209: linux-2.6.9-x86_64-ni_syscall-overrun.patch
Patch210: linux-2.6.9-x86_64-flexmmap.patch
Patch211: linux-2.6.9-x86_64-task_size-32bit.patch
Patch212: linux-2.6.9-x86-sysenter-ebp.patch
Patch213: linux-2.6.10-x86-dma_declare_coherent_memory-kmalloc-args.patch
Patch214: linux-2.6.9-x86-intel-ich7-ids.patch
Patch215: linux-2.6.9-x86_64-hit-hpet-twice.patch
Patch216: linux-2.6.9-x86-vsyscall-sysenter-unwind-info.patch
Patch217: linux-2.6.9-x86_64-switch_to-missinglock.patch
Patch218: linux-2.6.9-x86-enhanced-speedstep.patch
Patch219: linux-2.6.9-x86_64-nmi-switch.patch
Patch220: linux-2.6.9-x86_64-panic_timeout.patch
Patch221: linux-2.6.9-x86_64-srat-numa.patch
Patch222: linux-2.6.9-x86_64-hugetlb.patch
Patch223: linux-2.6.9-x86_64-change_page_attr-flush-fix.patch
Patch224: linux-2.6.9-x86_64-syscall_signal-restart.patch
Patch225: linux-2.6.9-x86_64-clustered-apic.patch
Patch226: linux-2.6.9-x86_64-amd-dualcore.patch
Patch227: linux-2.6.9-x86-irq-stack-apic-context.patch
Patch228: linux-2.6.9-ioremap-fixes.patch
Patch229: linux-2.6.9-x86-cpuid4.patch
Patch230: linux-2.6.9-hpet-legacy.patch
Patch231: linux-2.6.9-dualcore.patch
Patch232: linux-2.6.9-x8664-acpi-off.patch
Patch233: linux-2.6.9-powernow-k8.patch
Patch234: linux-2.6.9-x8664-reboot.patch
Patch235: linux-2.6.9-x8664-hotplug.patch
Patch236: linux-2.6.9-x8664-enable-numa.patch
Patch237: linux-2.6.9-x8664-csum-copy.patch
Patch238: linux-2.6.9-x8664-morrison-numa.patch
Patch239: linux-2.6.9-x86-irq-boot-disable-dualcore.patch
Patch240: linux-2.6.9-x8664-pfn-valid.patch
Patch241: linux-2.6.9-x86-thread-leak.patch
Patch242: linux-2.6.9-x8664-largesmp.patch
Patch243: linux-2.6.9-x86-cpu-relax.patch
Patch244: linux-2.6.9-x86-disable-ht.patch
Patch245: linux-2.6.9-x86-correct-cpufreq.patch
Patch246: linux-2.6.9-x8664-dma-snyc-cpu-device.patch
Patch247: linux-2.6.9-x8664-unisys.patch
Patch248: linux-2.6.9-x8664-noiommu.patch
Patch249: linux-2.6.9-x8664-32-bit-hang.patch
Patch250: linux-2.6.9-x8664-pci-iomap.patch
Patch251: linux-2.6.9-x8664-set-bit.patch
Patch252: linux-2.6.9-x86-auto-bigsmp.patch
Patch253: linux-2.6.9-x8664-agp.patch
Patch254: linux-2.6.9-x8664-core.patch
Patch255: linux-2.6.9-x8664-mce.patch
Patch256: linux-2.6.9-x86-pci-ioapic.patch
Patch257: linux-2.6.9-x86-nmi-oprofile.patch
Patch258: linux-2.6.9-x86-enable-apic-up.patch
Patch259: linux-2.6.9-x86-irq-compression.patch
Patch260: linux-2.6.9-x8664-srat-parser.patch
Patch261: linux-2.6.9-x8664-pgtable-alloc.patch
Patch262: linux-2.6.9-x86-mem-limit.patch
Patch263: linux-2.6.9-x86-setup-gap.patch
Patch264: linux-2.6.9-x86-dmi-scan.patch
Patch265: linux-2.6.9-x86-vdso-signal-tramp.patch
Patch266: linux-2.6.9-x8664-cmd-line.patch
Patch267: linux-2.6.9-x8664-tlb-flush.patch
Patch268: linux-2.6.9-x86-modern-apic.patch
Patch269: linux-2.6.9-x86-sci-override.patch
Patch270: linux-2.6.9-x86-timer-over-8254.patch
Patch271: linux-2.6.9-x8664-lapic-status.patch
Patch272: linux-2.6.9-x8664-ebda-alloc.patch

# 300 - 399   ppc(64)
Patch300: linux-2.6.2-ppc64-build.patch
Patch301: linux-2.6.8-ppc64-netboot.patch
Patch302: linux-2.6.9-ppc64-singlestep.patch
Patch303: linux-2.6.9-ppc64-hvsi-udbg.patch
Patch304: linux-2.6.9-ppc64-hvsi-reset.patch
Patch305: linux-2.6.9-ppc64-pci-hostbridge-hotplug.patch
Patch306: linux-2.6.9-ppc64-vscsi.patch
Patch307: linux-2.6.9-ppc64-signal-backtrace.patch
Patch308: linux-2.6.9-ppc64-hvsi-hangup.patch
Patch309: linux-2.6.9-ppc64-cpu-hotplug-map-cpu-node.patch
Patch310: linux-2.6.9-ppc64-cpu-hotplug-sched-domains.patch
Patch311: linux-2.6.9-ppc64-cpu-hotplug-notifier.patch
Patch312: linux-2.6.9-ppc64-cpu-hotplug-reinit-scheddomains.patch
Patch313: linux-2.6.9-ppc64-cpu-hotplug-destroy_sched_domains.patch
Patch314: linux-2.6.9-ppc64-cpu-hotplug-use-notifier.patch
Patch315: linux-2.6.9-ppc64-sigsuspend-regstomping.patch
Patch316: linux-2.6.9-ppc64-icom-driver.patch
Patch317: linux-2.6.9-ppc64-ibmvscsi-race-fix.patch
Patch318: linux-2.6.9-ppc64-ensure-irqs-not-hard-disabled.patch
Patch319: linux-2.6.9-ppc64-purr.patch
Patch320: linux-2.6.9-ppc64-eeh-reset-state2.patch
Patch321: linux-2.6.9-ppc64-tce-table-space.patch
Patch322: linux-2.6.9-ppc64-viocd.patch
Patch323: linux-2.6.9-ppc64-lparcfg-paca-align.patch
Patch324: linux-2.6.9-ppc64-ibmveth-getlink.patch
Patch325: linux-2.6.9-ppc64-rpaclose.patch
Patch326: linux-2.6.9-ppc64-alloc-consistent-order.patch
Patch327: linux-2.6.9-ppc64-sighandler-stackalign.patch
Patch328: linux-2.6.9-ppc64-eeh-recover.patch
Patch329: linux-2.6.9-ppc64-idle-setup.patch
Patch330: linux-2.6.9-ppc64-tiocgicount32.patch
Patch331: linux-2.6.9-ppc64-vpa-init.patch
Patch332: linux-2.6.9-ppc64-prom-init.patch
Patch333: linux-2.6.9-ppc64-getpurr.patch
Patch334: linux-2.6.9-ppc64-xmon-early.patch
Patch335: linux-2.6.9-ppc64-iseries-veth-mod-race.patch
Patch336: linux-2.6.9-ppc64-viocd-2.patch
Patch337: linux-2.6.9-ppc64-ibmveth-starve.patch
Patch338: linux-2.6.9-ppc64-numa-memhole.patch
Patch339: linux-2.6.9-ppc64-numa-setup.patch
Patch340: linux-2.6.9-ppc64-clear-ri-after-restore-stack.patch
Patch341: linux-2.6.9-ppc64-ibmvscsi-dangling-ptr.patch
Patch342: linux-2.6.9-ppc64-rpadebug.patch
Patch343: linux-2.6.9-ppc64-rpacc.patch
Patch344: linux-2.6.9-ppc64-noprobe-failed-pci.patch
Patch345: linux-2.6.9-ppc64-io-base.patch
Patch346: linux-2.6.9-ppc64-isa-ioports.patch
Patch347: linux-2.6.9-ppc64-eeh-dynamic.patch
Patch348: linux-2.6.9-ppc-eeh-error-doc.patch
Patch349: linux-2.6.9-vscsi-update-155.patch
Patch350: linux-2.6.9-ppc64-signal-frame.patch
Patch351: linux-2.6.9-ppc64-ext-pci-config.patch
Patch352: linux-2.6.9-ppc64-sigreturn-audit.patch
Patch353: linux-2.6.9-ppc64-iommu-merge.patch
Patch354: linux-2.6.9-veth-updates.patch
Patch355: linux-2.6.13-jasmine.patch
Patch356: linux-2.6.13-xmon-locking.patch
Patch357: linux-2.6.13-evade-hypervisor-bug.patch
Patch358: linux-2.6.9-power5-cpu.patch
Patch359: linux-2.6.9-js20-cpu-enablement.patch
Patch360: linux-2.6.9-ati-radeon.patch
Patch361: linux-2.6.9-offb.patch
Patch362: linux-2.6.9-ppc64-oprofile.patch
Patch363: linux-2.6.9-ppc64-time.patch
Patch364: linux-2.6.9-ppc64-lpar.patch
Patch365: linux-2.6.9-ppc64-early-serial.patch
Patch366: linux-2.6.9-ppc64-vmx.patch
Patch367: linux-2.6.9-ppc64-eeh.patch
Patch368: linux-2.6.9-ppc64-ptrace.patch
Patch369: linux-2.6.9-ppc64-user-access.patch

# 400 - 499   ia64
Patch400: linux-2.6.3-ia64-build.patch
Patch401: linux-2.6.9-ia64-sn2-update.patch
Patch402: linux-2.6.9-ia64-pci-sn2-fix.patch
Patch403: linux-2.6.9-ia64-mmtimer-sn2-fix.patch
Patch404: linux-2.6.9-ia64-qla1280-sn2-fix.patch
Patch405: linux-2.6.9-ia64-sgiioc4-sn2-fix.patch
Patch406: linux-2.6.9-ia64-sn-console-sn2-fix.patch
Patch407: linux-2.6.9-ia64-snsc-sn2-fix.patch
Patch408: linux-2.6.9-ia64-cyclone-timer-fix.patch
Patch409: linux-2.6.9-ia64-irq-routing-maxcpus.patch
Patch410: linux-2.6.9-ia64-sba_iommu-size.patch
Patch411: linux-2.6.9-ia64-tr_info-hang.patch
Patch412: linux-2.6.9-ia64-cpu-relax.patch
Patch413: linux-2.6.9-ia64-init-trigger-switch4.patch
Patch414: linux-2.6.9-ia64-sgiioc-ide-workaround.patch
Patch415: linux-2.6.9-ia64-rx1600-pdh-console-fix.patch
Patch416: linux-2.6.9-ia64-sys_waitid.patch
Patch417: linux-2.6.9-ia64-zx2-idents.patch
Patch418: linux-2.6.9-ia64-ia32_signal-memset-correctness.patch
Patch419: linux-2.6.9-ia64-tollhouse-error.patch
Patch420: linux-2.6.9-ia64-tollhouse-pci-toplogy.patch
Patch421: linux-2.6.9-ia64-tollhouse-inf-loop.patch
Patch422: linux-2.6.9-ia64-tollhouse-add-geoid.patch
Patch423: linux-2.6.9-ia64-tollhouse-header.patch
Patch424: linux-2.6.9-ia64-map-gate-page.patch
Patch425: linux-2.6.12-sn-update.patch
Patch426: linux-2.6.9-ia64-perfmon-update.patch
Patch427: linux-2.6.9-ia64-zx2-console.patch
Patch428: linux-2.6.9-ia64-sx2000.patch
Patch429: linux-2.6.9-ia64-sigprocmask-race.patch
Patch430: linux-2.6.9-ia64-handle-page-not-present.patch
Patch431: linux-2.6.13-ia64-memcpy.patch
Patch432: linux-2.6.13-ia64-multi-core.patch
Patch433: linux-2.6.9-ia64-nat-coredump.patch
Patch434: linux-2.6.9-ia64-dma-get-cache.patch
Patch435: linux-2.6.9-ia64-swiotlb-updates.patch
Patch436: linux-2.6.9-ia64-pci-ext.patch
Patch437: linux-2.6.9-ia64-nested-dtlb-miss-hugetlb.patch
Patch438: linux-2.6.9-ia64-unaligned.patch
Patch439: linux-2.6.9-ia64-irq-share.patch
Patch440: linux-2.6.9-ia64-mmu-context.patch
Patch441: linux-2.6.9-ia64-osinit-dump.patch

# 500 - 599   s390(x)
Patch500: linux-2.6.1-s390-compile.patch
Patch501: linux-2.6.9-s390-autoraid.patch
Patch502: linux-2.6.9-s390-qeth-fake_ll-fix.patch
Patch503: linux-2.6.9-s390-zfcp_port-fix.patch
Patch504: linux-2.6.9-s390-zfcp-stackframe.patch
Patch506: linux-2.6.9-s390-dasd-fixed-buffer.patch
Patch507: linux-2.6.9-s390-core_dump-fix.patch
Patch508: linux-2.6.9-s390-lcs_startup-fix.patch
Patch509: linux-2.6.9-s390-qeth_addr-fix.patch
Patch510: linux-2.6.9-s390-qeth_hipersocket-fix.patch
Patch511: linux-2.6.9-s390-no_hz_timer-fix.patch
Patch512: linux-2.6.9-s390-config_watchdog.patch
Patch513: linux-2.6.9-s390-lcs_seq_numbers.patch
Patch514: linux-2.6.11-s390-qeth_fake_ll-fix.patch
Patch515: linux-2.6.10-s390-dasd_io_error-fix.patch
Patch516: linux-2.6.10-s390-qdio_packet_loss-fix.patch
Patch517: linux-2.6.10-s390-cio-fix.patch
Patch518: linux-2.6.11-s390-cio-vary_off-fix.patch
Patch519: linux-2.6.10-s390-qdio_time_delay-fix.patch
Patch520: linux-2.6.9-s390-pagefault-deadlock.patch
Patch521: linux-2.6.9-s390-qeth-netstall-update.patch
Patch522: linux-2.6.9-s390-zfcp-update.patch
Patch523: linux-2.6.9-s390-memory-read.patch
Patch524: linux-2.6.9-s390-fadvise.patch
Patch525: linux-2.6.9-s390-dasd-cio-update.patch
Patch526: linux-2.6.9-s390-crypto-driver-update-116.patch
Patch527: linux-2.6.9-s390-pfault-interrupt-race.patch
Patch528: linux-2.6.9-s390-ptrace-peek-poke.patch
Patch529: linux-2.6.9-s390-swap-offset.patch
Patch530: linux-2.6.9-s390-internal-return.patch
Patch531: linux-2.6.9-s390-cio-patch-retry.patch
Patch532: linux-2.6.9-s390-vmcp.patch
Patch533: linux-2.6.9-s390-debug_feature.patch
Patch534: linux-2.6.9-s390-vm_logreader.patch
Patch535: linux-2.6.9-s390-vmwatchdog.patch
Patch536: linux-2.6.9-s390-qeth-ipv6-ui64.patch
Patch537: linux-2.6.9-s390-semaphore.patch
Patch538: linux-2.6.9-s390-ctc-mpc.patch
Patch539: linux-2.6.9-s390-signal-quiesce-fixes.patch
Patch540: linux-2.6.9-s390-diag10.patch
Patch541: linux-2.6.9-s390-strnlen.patch
Patch542: linux-2.6.9-s390-qeth-update.patch
Patch543: linux-2.6.9-s390-test-bit.patch
Patch544: linux-2.6.9-s390-dcssblk-driver.patch
Patch545: linux-2.6.9-s390-stack-corruption.patch
Patch546: linux-2.6.9-s390-sysrq.patch
Patch547: linux-2.6.9-s390-crypto-overwrite.patch
Patch548: linux-2.6.9-s390-lcs-update.patch
Patch549: linux-2.6.9-s390-hypfs.patch

#
# Patches 900 through 1000 are reserved for bugfixes to the core system
# and patches related to how RPMs are build
#
Patch900: linux-2.4.0-nonintconfig.patch

Patch910: linux-2.6.0-exec-shield.patch
Patch911: linux-2.6.8-print-fatal-signals.patch
Patch912: linux-2.6.8-execshield-vaspace.patch
Patch913: linux-2.6.9-nx-large-page.patch
Patch914: linux-2.6.9-ht-active-load-balancing.patch

Patch920: linux-2.6.8-4g4g-backout.patch
Patch921: linux-2.6.0-4g4g.patch
Patch922: linux-2.6.9-4g4g-noncachable.patch
Patch923: linux-2.6.9-4g4g-hugemem-warning.patch
Patch924: linux-2.6.9-4g4g-maxtasksize.patch
Patch930: linux-2.6.0-must_check.patch
Patch940: linux-2.6.2-tux.patch
Patch945: linux-2.6.11-rwsem-intr-safe.patch
Patch946: linux-2.6.11-bio-bounce-error.patch
Patch947: linux-2.6.9-mmiowb.patch

# Module signing infrastructure.
Patch950: linux-2.6.7-modsign-core.patch
Patch951: linux-2.6.7-modsign-crypto.patch
Patch952: linux-2.6.7-modsign-ksign.patch
Patch953: linux-2.6.7-modsign-mpilib.patch
Patch954: linux-2.6.7-modsign-script.patch
Patch955: linux-2.6.7-modsign-include.patch
Patch956: linux-2.6.9-sha1.patch
Patch957: linux-2.6.9-key-unavailable-key-oops.patch

#
# Patches 1000 to 4999 are reserved for bugfixes to drivers and filesystems
#
Patch1000: linux-2.4.0-test11-vidfail.patch
Patch1020: linux-2.6.4-stackusage.patch
Patch1021: linux-2.6.9-smbfs-uid-gid.patch
Patch1022: linux-2.6.9-pci-sysfs.patch
Patch1023: linux-2.6.9-openipmi-update.patch
Patch1024: linux-2.6.9-cifs-update.patch
Patch1025: linux-2.6.9-hfs.patch
# Ext2/Ext3 bits.
Patch1030: linux-2.6.5-ext3-reservations.patch
Patch1031: linux-2.6.8-ext3-reservations-update.patch
Patch1032: linux-2.6.9-ext3-cleanup-abort.patch
Patch1033: linux-2.6.5-ext3-online-resize.patch
Patch1034: linux-2.6.9-ext3-handle-bitmapdel.patch
Patch1035: linux-2.6.9-ext3-handle-double-revoke.patch
Patch1036: linux-2.6.9-ext2-mbcache.patch
Patch1037: linux-2.6.9-ext3-mbcache.patch
Patch1038: linux-2.6.9-ext3-umount-leak.patch
Patch1039: linux-2.6.9-ext3-file-limit.patch
Patch1040: linux-2.6.9-ext3-release-race.patch
Patch1041: linux-2.6.9-ext3-memleak.patch
Patch1042: linux-2.6.9-jbd-umount-race.patch
Patch1043: linux-2.6.9-ext3-nfs-enoent.patch
Patch1044: linux-2.6.9-ext3-xattr-share.patch
Patch1045: linux-2.6.9-ext3-sub-second-timestamp.patch
Patch1046: linux-2.6.9-ext3-acl-extend.patch
Patch1047: linux-2.6.9-ext3-log-do-checkpoint-assertion.patch
Patch1048: linux-2.6.9-ext2-loop-symlink.patch
Patch1049: linux-2.6.9-ext3-jbd-race.patch

Patch1050: linux-2.6.7-devmem.patch
Patch1051: linux-2.6.0-devmem.patch
Patch1060: linux-2.6.3-crash-driver.patch
Patch1070: linux-2.6.0-sleepon.patch
Patch1080: linux-2.6.7-voluntary-preemption.patch
Patch1081: linux-2.6.7-early-schedule.patch
Patch1082: linux-2.6.9-ramfs.patch

# SATA bits.
Patch1100: linux-2.6.9-sata.patch
Patch1101: linux-2.6.9-sata-nth-page.patch
Patch1102: linux-2.6.9-sata-ahci-update.patch
Patch1103: linux-2.6.9-sata-updates.patch
Patch1104: linux-2.6.10-sata-updates.patch
Patch1105: linux-2.6.9-sata-lba48-max-sectors.patch
Patch1106: linux-2.6.12-sata-updates.patch
Patch1107: linux-2.6.9-diskdump-sata.patch
Patch1108: linux-2.6.14-sata-updates.patch

# SCSI bits.
Patch1120: linux-2.6.7-scsi-whitelist.patch
Patch1121: linux-2.6.9-scsi-bounce-limit.patch
Patch1122: linux-2.6.9-scsi-aic-hostraid.patch
Patch1123: linux-2.6.10-scsi-midlayer-updates.patch
Patch1124: linux-2.6.9-scsi-aic-oops-nohardware.patch
Patch1125: linux-2.6.9-scsi-reset-ULDs.patch
Patch1126: linux-2.6.9-scsi-ips-update.patch
Patch1127: linux-2.6.9-scsi-NULL-iterate-devices.patch
Patch1128: linux-2.6.10-scsi-qla2xxx-update.patch
Patch1129: linux-2.6.10-scsi-cciss-clustering-fix.patch
Patch1130: linux-2.6.9-scsi-usb-forced-remove-oops.patch
Patch1131: linux-2.6.9-scsi-test_unit_ready-cdrom.patch
Patch1132: linux-2.6.9-scsi-aic-leakplug.patch
Patch1133: linux-2.6.9-scsi-refcount-cmd-allocation.patch
Patch1134: linux-2.6.9-scsi-full-status-sg_io.patch
Patch1135: linux-2.6.9-scsi-sg_cmd_done-sg_release-race.patch
Patch1136: linux-2.6.9-scsi-aac-remove-handle-aif.patch
Patch1137: linux-2.6.9-scsi-megaraid-kioc.patch
Patch1138: linux-2.6.9-scsi-inverted-refcounting.patch
Patch1139: linux-2.6.9-scsi-ioctl-overflow.patch

Patch1140: linux-2.6.9-blockfixes.patch
Patch1141: linux-2.6.9-block-segment-coalesce.patch
Patch1142: linux-2.6.9-cciss-getluninfo-fix.patch
Patch1143: linux-2.6.9-sx8-sysfs.patch
Patch1144: linux-2.6.9-block-blkdev_get_blocks-EOF.patch
Patch1145: linux-2.6.9-block-cciss-ioctl-returncode.patch
Patch1146: linux-2.6.9-block-cciss-id-updates.patch
Patch1147: linux-2.6.9-block-__getblk_slow-hang.patch

Patch1150: linux-2.6.9-md-resync-bugs.patch
Patch1151: linux-2.6.9-md-nr_pending.patch
Patch1152: linux-2.6.9-dm-dm_target_msg-ioctl.patch
Patch1153: linux-2.6.9-dm-multipath-ioctl-ref-by-devno.patch
Patch1154: linux-2.6.9-dm-fix-mirror-log-refcount.patch
Patch1155: linux-2.6.9-dm-suspendhook.patch
Patch1156: linux-2.6.9-dm-raid1-deadlock-fix.patch
Patch1157: linux-2.6.9-dm-kprintf-tidy.patch
Patch1158: linux-2.6.9-dm-add-dm_dev-name.patch
Patch1159: linux-2.6.9-dm-details-recordrestore.patch
Patch1160: linux-2.6.9-dm-export-mapinfo.patch
Patch1161: linux-2.6.9-dm-multipath.patch
Patch1162: linux-2.6.9-dm-64bit-fixes.patch
Patch1163: linux-2.6.9-dm-multipath-suspend-requeueing.patch
Patch1164: linux-2.6.9-dm-avoid-bdget.patch
Patch1165: linux-2.6.9-md-bi_max_vecs-fix.patch
Patch1166: linux-2.6.9-md-multipath-assemly.patch
Patch1167: linux-2.6.9-md-bogus-level-check.patch
Patch1168: linux-2.6.9-md-thinkos.patch
Patch1169: linux-2.6.9-dm-mirroring.patch
Patch1170: linux-2.6.9-dm-event-dev-removal.patch
Patch1171: linux-2.6.9-dm-raid1-race.patch
Patch1172: linux-2.6.9-dm-barrier.patch
Patch1173: linux-2.6.9-md-linear.patch


# NFS bits.
Patch1200: linux-2.6.9-NFS-mounthangfix.patch
Patch1201: linux-2.6.9-NFSD-non-null-getxattr.patch
Patch1202: linux-2.6.9-NFSD-locallock-oopsfix.patch
Patch1203: linux-2.6.9-NFSD-putrootfh-return.patch
Patch1204: linux-2.6.9-NFSD-portwarning-dottedquads.patch
Patch1205: linux-2.6.9-NFS-cthon-rename.patch
Patch1206: linux-2.6.8-lockd-racewarn2.patch
Patch1207: linux-2.6.9-lockd-NLM-length.patch
Patch1208: linux-2.6.9-lockd-block-nosleep.patch
Patch1209: linux-2.6.9-lockd-reclaims.patch
Patch1210: linux-2.6.9-lockd-svc-reclaims.patch
Patch1211: linux-2.6.9-NFS-nlmcreds.patch
Patch1212: linux-2.6.9-rpc-autherr-retry.patch
Patch1213: linux-2.6.9-NFS-stackoverflow.patch
Patch1214: linux-2.6.9-NFSD-add_set_client.patch
Patch1215: linux-2.6.9-NFSD-use_set_client4.patch
Patch1216: linux-2.6.9-lockd-callbacks.patch
Patch1217: linux-2.6.9-NFS-auth-oops.patch
Patch1218: linux-2.6.9-NFS-mmap-corruption.patch
Patch1219: linux-2.6.9-NFS-locking-oops.patch
Patch1220: linux-2.6.9-NFS-callback.patch
Patch1221: linux-2.6.9-NFS4-compat-mount.patch
Patch1222: linux-2.6.9-nfs-bindreserve.patch
Patch1223: linux-2.6.9-nfs-procfs-lockd.patch
Patch1224: linux-2.6.9-nfs-intr-flap-prevents.patch
Patch1225: linux-2.6.9-nfsv3-kerberos.patch
Patch1226: linux-2.6.9-knfsd-port.patch
Patch1227: linux-2.6.9-nfs-estale.patch
Patch1228: linux-2.6.9-nfsd-umount-failure.patch
Patch1229: linux-2.6.9-rpc.patch
Patch1230: linux-2.6.9-nfs-acl.patch
Patch1231: linux-2.6.9-nfs-rename-dir.patch
Patch1232: linux-2.6.9-nfs-krb5-mountd.patch
Patch1233: linux-2.6.9-nfs-debug.patch
Patch1234: linux-2.6.9-nfs-gss-pipe-release-oops.patch
Patch1235: linux-2.6.9-nfsv3-locking.patch
Patch1236: linux-2.6.9-nfs-not-syncing-panic.patch
Patch1237: linux-2.6.9-nfsv3-cache-invalidation.patch
Patch1238: linux-2.6.9-nfs-aio.patch
Patch1239: linux-2.6.9-lockd-recovery.patch
Patch1240: linux-2.6.9-nfs-hash.patch
Patch1241: linux-2.6.9-nfs-interrupt.patch
Patch1242: linux-2.6.9-nfs-updates.patch

# Core networking fixes.
Patch1300: linux-2.6.9-net-ipv6-fix-mtu-calculation.patch
Patch1301: linux-2.6.9-net-vlan-change_mtu-success.patch
Patch1302: linux-2.6.9-net-SIOCGIFHWADDR-NULL-dev_addr.patch
Patch1303: linux-2.6.9-net-compat-missing-security.patch
Patch1304: linux-2.6.9-net-xfrm-fixes.patch
Patch1305: linux-2.6.9-net-cmsg_signedness.patch
Patch1306: linux-2.6.9-net-ftp_conntrack_leak.patch
Patch1307: linux-2.6.9-net-ip_options_leak.patch
Patch1308: linux-2.6.9-net-procroute-stale-pointer.patch
Patch1309: linux-2.6.9-net-bonding-panic.patch
Patch1310: linux-2.6.9-net-sk_forward_alloc-BUG.patch
Patch1311: linux-2.6.9-net-tcp-bic-fix.patch
Patch1312: linux-2.6.9-net-fragment-corruption.patch
Patch1313: linux-2.6.9-net-sctp-recv-accounting.patch
Patch1314: linux-2.6.9-net-ipsec-sa-sequence-collision.patch
Patch1315: linux-2.6.9-net-sctp-sendbuffer-accounting.patch
Patch1316: linux-2.6.9-net-snmp6-fix-crash-on-shutdown.patch
Patch1317: linux-2.6.9-net-igmp-avoid-tx-balance.patch
Patch1318: linux-2.6.9-net-ipsec-spinlock-deadlock.patch
Patch1319: linux-2.6.9-net-conntrack-procfiles-remove.patch
Patch1320: linux-2.6.9-net-bonding-arp-failover-fix.patch
Patch1321: linux-2.6.9-net-ipv6-exthdrs-bug.patch
Patch1322: linux-2.6.11-net-sctp-bind.patch
Patch1323: linux-2.6.9-update-bonding-doc.patch
Patch1324: linux-2.6.9-net-ipv6-ui64.patch
Patch1325: linux-2.6.9-ipv6-leak-route.patch
Patch1326: linux-2.6.12-netlink-hang.patch
Patch1327: linux-2.6.12-net-sctp-bind-to-device.patch
Patch1328: linux-2.6.12-sysctl-route-perms.patch
Patch1329: linux-2.6.12-ipvs-conn-flush.patch
Patch1330: linux-2.6.12-tcp-output.patch
Patch1331: linux-2.6.12-network.patch
Patch1332: linux-2.6.9-bonding.patch
Patch1333: linux-2.6.9-net-sctp-shutdown.patch
Patch1334: linux-2.6.9-net-sctp-receive-buffer.patch
Patch1335: linux-2.6.9-net-sctp.patch

# NIC driver updates
Patch1350: linux-2.6.9-net-b44-4g4g.patch
Patch1351: linux-2.6.9-net-tr-irqlock-fix.patch
Patch1352: linux-2.6.9-net-tulip-waitdmastop.patch
Patch1353: linux-2.6.10-net-3c59x-reload-EEPROM.patch
Patch1354: linux-2.6.9-net-tg3-fiber-autoneg-bounces.patch
Patch1355: linux-2.6.9-net-e100-xmit-timeout-enable-interrupts.patch
Patch1356: linux-2.6.9-net-forcedeth-rx-csum.patch
Patch1357: linux-2.6.9-net-via-rhine-devinit.patch
Patch1358: linux-2.6.9-net-e1000-erratum23.patch
Patch1359: linux-2.6.9-net-e1000-post-mature-writeback.patch
Patch1360: linux-2.6.9-net-e1000-rx-mini-jumbo-inval.patch
Patch1361: linux-2.6.9-net-e1000-64k-align-check-dma.patch
Patch1362: linux-2.6.9-net-s2io-update.patch
Patch1364: linux-2.6.10-net-e1000-update.patch
Patch1365: linux-2.6.10-net-e100-update.patch
Patch1366: linux-2.6.9-net-e100-e100_tx_timeout-workqueue.patch
Patch1367: linux-2.6.9-net-sk98lin-module_device_table.patch
Patch1368: linux-2.6.10-net-tg3-update.patch
Patch1369: linux-2.6.9-net-e100-fix-NAPI-state-machine.patch
Patch1370: linux-2.6.9-net-e100-ich7.patch
Patch1371: linux-2.6.9-net-e1000-avoid-sleep-in-timer-context.patch
Patch1372: linux-2.6.9-net-e1000-flush-rmmod.patch
Patch1373: linux-2.6.9-net-forcedeth-class-quirk.patch
Patch1374: linux-2.6.11-net-ixgb-update.patch
Patch1375: linux-2.6.11-net-e1000-update.patch
Patch1376: linux-2.6.9-net-b44-bounce-buffer-fix.patch
Patch1377: linux-2.6.12rc2-net-3c59x-update.patch
Patch1378: linux-2.6.9-net-tg3-update.patch
Patch1379: linux-2.6.9-net-e100-update.patch
Patch1380: linux-2.6.9-net-dl2k-drvname.patch
Patch1381: linux-2.6.9-net-b44-link-status-check.patch
Patch1382: linux-2.6.9-net-typhoon-update.patch
Patch1383: linux-2.6.9-pcnet32-update.patch
Patch1384: linux-2.6.9-forcedeth-update.patch
Patch1385: linux-2.6.9-net-tg3-ethtool.patch
Patch1386: linux-2.6.9-net-bnx2-driver.patch
Patch1387: linux-2.6.9-net-mii-update.patch
Patch1388: linux-2.6.9-net-sky2.patch
patch1389: linux-2.6.9-net-add-skge.patch

# ACPI Horrors.
Patch1400: linux-2.6.9-acpi-breakpoint-nop.patch
Patch1401: linux-2.6.9-acpi-lequal-less-strict.patch
Patch1402: linux-2.6.9-acpi-debug-level.patch
Patch1403: linux-2.6.9-acpi-reset-mechanism.patch
Patch1404: linux-2.6.9-acpi-panic-pci_root_add.patch
Patch1405: linux-2.6.9-acpi-xsdt.patch

# Kprobes
Patch1450: linux-2.6.12-kprobes-base.patch
Patch1451: linux-2.6.12-kprobes-jprobe.patch
Patch1452: linux-2.6.12-kprobes-reentrant.patch
Patch1453: linux-2.6.12-kprobes-return-address.patch
Patch1454: linux-2.6.13-relayfs.patch
Patch1455: linux-2.6.12-kprobes-ia64.patch
Patch1456: linux-2.6.12-kprobes-isr-task.patch
Patch1457: linux-2.6.12-kprobes-smp-miss.patch
Patch1458: linux-2.6.12-kprobes-scalability.patch

# storage driver updates
Patch1470: linux-2.6.9-qlogic-update-80100b5-rh2.patch
Patch1471: linux-2.6.9-cciss-update-266.patch
Patch1472: linux-2.6.9-i2o-updates.patch
Patch1473: linux-2.6.9-cciss-update-268.patch
Patch1474: linux-2.6.9-qlogic-update-8.01.02-d2.patch
Patch1475: linux-2.6.9-sym53c8xx-update.patch
Patch1476: linux-2.6.9-qlogic-update.patch
Patch1477: linux-2.6.9-cciss-update.patch

# Netdump bits.
Patch1500: linux-2.6.8-crashdump-common.patch
Patch1501: linux-2.6.9-crashdump-fix-reboot-failure.patch
Patch1510: linux-2.6.7-netdump.patch
Patch1520: linux-2.6.8-netconsole.patch
Patch1521: linux-2.6.9-netconsole-tg3-oops.patch
Patch1530: linux-2.6.9-netpoll-oops.patch

# Diskdump goodies.
Patch1540: linux-2.6.8-diskdump-3.patch
Patch1541: linux-2.6.8-diskdump-scsi-3.patch
Patch1542: linux-2.6.8-mptfusion-diskdump.patch
Patch1543: linux-2.6.7-aic7xxx-diskdump.patch
Patch1544: linux-2.6.8-sym53c8xx-diskdump.patch
Patch1545: linux-2.6.8-ipr-diskdump.patch
Patch1546: linux-2.6.9-diskdump-dienmi.patch
Patch1547: linux-2.6.9-diskdump-export_state.patch
Patch1548: linux-2.6.9-diskdump-mdelay.patch
Patch1549: linux-2.6.9-diskdump-mem.patch
Patch1550: linux-2.6.9-diskdump-system_state.patch
Patch1551: linux-2.6.9-diskdump-condition.patch
Patch1552: linux-2.6.9-diskdump-gendisk.patch
Patch1554: linux-2.6.9-diskdump-megaraid.patch
Patch1555: linux-2.6.9-diskdump-wce.patch
Patch1556: linux-2.6.9-diskdump-badmsg.patch
Patch1557: linux-2.6.9-dump_smp_call-ia64.patch
Patch1558: linux-2.6.9-dump_smp_call-i386.patch
Patch1559: linux-2.6.9-dump_smp_call-ppc64.patch
Patch1560: linux-2.6.9-dump_smp_call-x86_64.patch
Patch1561: linux-2.6.9-dump_smp_call_function-3.patch
Patch1562: linux-2.6.9-diskdump-maxblocks.patch
Patch1563: linux-2.6.9-diskdump-queuebusy.patch
Patch1564: linux-2.6.9-diskdump-partial.patch
Patch1565: linux-2.6.9-diskdump-swap.patch
Patch1566: linux-2.6.9-diskdump-osinit.patch
Patch1567: linux-2.6.9-diskdump-detail-partial.patch
Patch1568: linux-2.6.9-diskdump-compress.patch
Patch1569: linux-2.6.9-diskdump-ide.patch
Patch1570: linux-2.6.9-diskdump-fixes.patch

# SELinux bits
Patch1600: linux-2.6.9-selinux-netif-fixes.patch
Patch1601: linux-2.6.9-selinux-setxattr-daccheck.patch
Patch1602: linux-2.6.9-selinux-sidtab-locking-fix.patch
Patch1603: linux-2.6.9-selinux-mediate-send_sigurg.patch
Patch1604: linux-2.6.9-selinux-setscheduler-deadlock.patch
Patch1605: linux-2.6.9-selinux-avc-rcu.patch
Patch1606: linux-2.6.9-selinux-xattr-rework-tmpfs-mm.patch
Patch1608: linux-2.6.9-selinux-destroy-avtab-node-cache.patch
Patch1609: linux-2.6.9-selinux-avc_update_node-spinlock-oops.patch
Patch1610: linux-2.6.9-selinux-avc-deadlock.patch
Patch1611: linux-2.6.9-selinux-invalid-policy-fix.patch
Patch1612: linux-2.6.9-selinux-kmalloc-fail-null-deref.patch
Patch1613: linux-2.6.9-selinux-bad-root-context.patch
Patch1614: linux-2.6.9-selinux-invalid-policy-memleak.patch
Patch1615: linux-2.6.9-selinux-attr_force.patch
Patch1616: linux-2.6.9-selinux-unknown-netlink.patch
Patch1617: linux-2.6.12-selinux-free-page.patch
Patch1618: linux-2.6.12-selinux-strcpy-overflow.patch
Patch1619: linux-2.6.12-selinux-mls-compat.patch

# Misc bits.
Patch1700: linux-2.6.9-procfs-getpid-fix.patch
Patch1701: linux-2.6.9-procfs-deadtask-dereference.patch
Patch1702: linux-2.6.9-procfs-self-attr-clear.patch
Patch1710: linux-2.6.9-edd-config.patch
Patch1720: linux-2.6.10-sysfs-update.patch
Patch1730: linux-2.6.9-signal-handling-dr7.patch
Patch1740: linux-2.6.9-timer-barrier.patch
Patch1750: linux-2.6.9-nonpower2sectorsize.patch
Patch1760: linux-2.6.9-module_version.patch
Patch1780: linux-2.6.9-irqaffinity-disable-E7xxx.patch
Patch1781: linux-2.6.9-ASPM-workaround-PCIE.patch
Patch1782: linux-2.6.9-hotplug-msi-update.patch
Patch1783: linux-2.6.9-80332-IOP-hotplug.patch
Patch1784: linux-2.6.9-ExpressCard-hotplug-ICH6M.patch
Patch1785: linux-2.6.9-pcix-hotplug-fixes.patch
Patch1790: linux-2.6.9-hugetlb_get_unmapped_area-fix.patch 
Patch1800: linux-2.6.9-statm-combined.patch
Patch1810: linux-2.6.9-idefloppy-suppress-noise.patch
Patch1820: linux-2.6.9-do_wait-hang-fix.patch
Patch1830: linux-2.6.9-pci_mmcfg_write-flush_error.patch
Patch1840: linux-2.6.9-via-apic-quirk-devinit.patch
Patch1850: linux-2.6.9-autofs-recognise-map-update.patch
Patch1860: linux-2.6.9-taint-mce.patch
Patch1861: linux-2.6.9-taint-force-rmmod.patch
Patch1862: linux-2.6.9-taint-badpage.patch
Patch1870: linux-2.6.9-xtime-correctness.patch
Patch1880: linux-2.6.9-pagevec-alignment.patch
Patch1890: linux-2.6.9-overlapping-vma.patch
Patch1900: linux-2.6.9-futex-disable-warning.patch
Patch1901: linux-2.6.9-futex-mmap_sem-deadlock.patch
Patch1910: linux-2.6.9-spinlock-debug-panic.patch
Patch1920: linux-2.6.9-compat-F_GETLK.patch
Patch1930: linux-2.6.9-waitid-bogus-ECHILD.patch
Patch1950: linux-2.6.9-agp-missing-cacheflushes.patch
Patch1951: linux-2.6.9-agp-posting-bugs.patch
Patch1960: linux-2.6.9-vc-resizing-overflow.patch
Patch1970: linux-2.6.9-kern_exit-race.patch
Patch1971: linux-2.6.9-exit-deadtask-nodentry-cache.patch
Patch1990: linux-2.6.9-random-sysctl-overflow.patch
Patch1991: linux-2.6.9-i8042-release.patch
Patch1992: linux-2.6.9-ixchxrom-flash.patch
Patch1993: linux-2.6.9-nr-keys.patch
Patch1994: linux-2.6.9-active-pci-support.patch
Patch1995: linux-2.6.9-pci-scan-device-master-abort.patch
Patch1996: linux-2.6.9-pci-bar-size.patch
Patch1997: linux-2.6.9-sched-pin-inline.patch

# VM bits.
Patch2000: linux-2.6.9-vm-tame-oomkiller.patch
Patch2001: linux-2.6.9-vm-dirty_ratio-initialisation-fix.patch
Patch2002: linux-2.6.9-vm-pageout-throttling.patch
Patch2003: linux-2.6.9-vm-page-writeback.patch
Patch2004: linux-2.6.9-vm-sc-congested.patch
Patch2005: linux-2.6.9-vm-total-scanned.patch
Patch2007: linux-2.6.9-rlimit_memlock-bypass.patch
Patch2009: linux-2.6.9-vm-oomkiller-tweak.patch
Patch2010: linux-2.6.9-vm-oomkiller-debugging.patch
Patch2011: linux-2.6.9-invalidate-page-race-fix.patch
Patch2012: linux-2.6.9-vm-mincore.patch
Patch2013: linux-2.6.9-vm-dma-zone-exhaustion.patch
Patch2014: linux-2.6.9-vm-improve-scanning.patch
Patch2015: linux-2.6.9-vm-swaptoken-null-mm.patch
Patch2016: linux-2.6.9-vm-unmap-pte-increment.patch
Patch2018: linux-2.6.9-bouncepages-accounting.patch
Patch2019: linux-2.6.9-topdown-mmap.patch
Patch2020: linux-2.6.9-mm-track.patch
Patch2021: linux-2.6.9-prune-icache-vs-iput.patch
Patch2022: linux-2.6.9-proc-disable-oom.patch
Patch2023: linux-2.6.9-ia64-update-mmu-cache.patch
Patch2024: linux-2.6.13-buffer.patch
Patch2025: linux-2.6.13-prio-tree.patch
Patch2026: linux-2.6.9-readahead.patch
Patch2027: linux-2.6.9-vm-committed-space.patch
Patch2028: linux-2.6.9-vmalloc.patch
Patch2029: linux-2.6.9-dirty-ratio.patch
Patch2030: linux-2.6.9-hugetlb.patch
Patch2031: linux-2.6.9-fork-optimization.patch
Patch2032: linux-2.6.9-swap-lock-page.patch
Patch2033: linux-2.6.9-bootmem.patch
Patch2034: linux-2.6.9-busy-inodes.patch

# IDE bits.
Patch2100: linux-2.6.9-ide-csb6-raid.patch
Patch2101: linux-2.6.9-ide-cd-early-EOF.patch
Patch2102: linux-2.6.9-ide-cd-panic.patch
Patch2103: linux-2.6.9-ide-supress-error-msg.patch
Patch2104: linux-2.6.9-ide-blacklist-update.patch
Patch2105: linux-2.6.12-ide-serverworks-hotplug.patch
Patch2106: linux-2.6.12-ide-serverworks-csb6.patch
Patch2107: linux-2.6.9-ide-updates.patch

# USB bits
Patch2200: linux-2.6.9-usb-edgeport-overflows.patch
Patch2201: linux-2.6.9-usb-storage-reload.patch
Patch2202: linux-2.6.9-usb-input-chicony-noget.patch
Patch2203: linux-2.6.13-usb-acm-wb.patch
Patch2204: linux-2.6.9-usb-memory-sticks.patch
Patch2205: linux-2.6.9-usb-toggles.patch
Patch2206: linux-2.6.9-usb-handoff.patch
Patch2207: linux-2.6.9-usb-khubd-deadlock.patch
Patch2208: linux-2.6.9-usb-hid-disconnect.patch
Patch2209: linux-2.6.9-usb-compat-ioctl.patch
Patch2210: linux-2.6.9-usb-ehci-nvidia.patch
Patch2211: linux-2.6.9-usb-cd-size.patch
Patch2212: linux-2.6.9-usb-error-handling.patch
Patch2213: linux-2.6.9-pizzaro-reboot.patch

# More SCSI bits.
Patch2300: linux-2.6.9-scsi-silence-sg_io-warning.patch
Patch2301: linux-2.6.9-scsi-qla-fix-hw-segment-counting.patch
Patch2302: linux-2.6.9-scsi-aacraid-dead-param.patch
Patch2303: linux-2.6.9-scsi-megaraid-update.patch
Patch2304: linux-2.6.9-scsi-megaraid-warning-fixes.patch
Patch2305: linux-2.6.9-scsi-mptfusion-update.patch
Patch2306: linux-2.6.9-i2o-increase-lct-get-timeout.patch
Patch2307: linux-2.6.9-scsi-oops-faulty-dvd.patch
Patch2308: linux-2.6.9-scsi-blacklist-false-echo-buffer.patch
Patch2309: linux-2.6.9-scsi-done-fail.patch
Patch2310: linux-2.6.9-iscsi-sfnet.patch
Patch2311: linux-2.6.12-qla1280-hotplug.patch
Patch2312: linux-2.6.9-ipr-update.patch
Patch2313: linux-2.6.9-ide-scsi-transform.patch
Patch2314: linux-2.6.9-mt-tell.patch
Patch2315: linux-2.6.9-st-sgio.patch
Patch2316: linux-2.6.9-sg-oops.patch
Patch2317: linux-2.6.9-ide-scsi-highmem.patch
Patch2318: linux-2.6.9-megaraid-update.patch
Patch2319: linux-2.6.9-sr-cd-rom-size.patch
Patch2320: linux-2.6.9-megaraid-sas.patch
Patch2321: linux-2.6.9-aacraid-update.patch
Patch2322: linux-2.6.9-sas-aic94xx.patch
Patch2323: linux-2.6.9-scsi-delete-timer-race.patch
Patch2324: linux-2.6.9-scsi-eh-tur.patch
Patch2325: linux-2.6.9-scsi-proc.patch
Patch2326: linux-2.6.9-scsi-qla2xxx-update.patch
Patch2327: linux-2.6.9-scsi-aic7xxx.patch
Patch2328: linux-2.6.9-scsi-adp94xx.patch
Patch2329: linux-2.6.9-scsi-3ware-update.patch

# Audit patches
Patch2400: linux-2.6.9-audit-retcode.patch
Patch2401: linux-2.6.9-audit-caps.patch
Patch2402: linux-2.6.9-auditcongestion.patch
Patch2403: linux-2.6.9-auditlost.patch
Patch2404: linux-2.6.9-audit-loginuid-proc.patch
Patch2405: linux-2.6.9-ppc64-auditsyscall.patch
Patch2406: linux-2.6.9-auditinonum.patch
Patch2407: linux-2.6.9-audit-netlinkfix.patch
Patch2408: linux-2.6.9-auditdev.patch
Patch2409: linux-2.6.9-auditipc.patch
Patch2410: linux-2.6.9-auditstr.patch
Patch2411: linux-2.6.9-auditaltroot.patch
Patch2412: linux-2.6.9-auditarch.patch
Patch2413: linux-2.6.11-rc3.stamp.patch
Patch2414: linux-2.6.9-auditoneliners.patch
Patch2415: linux-2.6.9-ia64-audit-syscall.patch
Patch2416: linux-2.6.9-audit-comm-exe.patch
Patch2417: linux-2.6.9-audit-netlink-loginuid.patch
Patch2418: linux-2.6.9-audit-netlink-perms.patch
Patch2419: linux-2.6.9-auditrequeue.patch
Patch2420: linux-2.6.9-audit-fix-setluid.patch
Patch2421: linux-2.6.9-audit-reuse-skb.patch
Patch2422: linux-2.6.9-audit-x86_64-compat.patch
Patch2423: linux-2.6.9-audit-sel-setscheduler.patch
Patch2424: linux-2.6.9-audit-unknownperm.patch
Patch2425: linux-2.6.9-audit-signal.patch
Patch2426: linux-2.6.9-audit-to-skb-1.patch
Patch2427: linux-2.6.9-audit-to-skb-2.patch
Patch2428: linux-2.6.9-audit-to-skb-3.patch
Patch2429: linux-2.6.9-audit-va-abuse.patch
Patch2430: linux-2.6.9-avc-deadlock.patch
Patch2431: linux-2.6.9-audit-types.patch
Patch2432: linux-2.6.9-audit-spelling.patch
Patch2433: linux-2.6.9-audit-socketcalls.patch
Patch2434: linux-2.6.9-audit-untrusted.patch
Patch2435: linux-2.6.9-audit-kthread.patch
Patch2436: linux-2.6.9-audit-not-auditd.patch
Patch2437: linux-2.6.9-avc-path.patch
Patch2438: linux-2.6.9-auid.patch
Patch2439: linux-2.6.9-audit-serial.patch
Patch2440: linux-2.6.9-audit-arch-first.patch
Patch2441: linux-2.6.9-audit-untrusted-2.patch
Patch2442: linux-2.6.9-audit-aux-defer-free.patch
Patch2443: linux-2.6.9-audit-pwd.patch
Patch2444: linux-2.6.9-audit-filters.patch
Patch2445: linux-2.6.9-audit-inode-flags.patch
Patch2446: linux-2.6.9-audit-reply-thread.patch
Patch2447: linux-2.6.9-audit-backlog-wait.patch
Patch2448: linux-2.6.9-auditd-oom.patch
Patch2449: linux-2.6.9-audit-printk-loglevel.patch
Patch2450: linux-2.6.9-audit-pid.patch
Patch2451: linux-2.6.9-audit-livelock.patch
Patch2452: linux-2.6.9-audit-idle-thread.patch
Patch2453: linux-2.6.9-audit-speedup.patch
Patch2454: linux-2.6.9-audit-task-refcnt.patch
Patch2455: linux-2.6.9-audit-dup-rules.patch
Patch2456: linux-2.6.9-audit-ppc64-syscallresult.patch
Patch2457: linux-2.6.9-audit-syscall-fail.patch
Patch2458: linux-2.6.9-audit-msg2.patch

# Key management patches
Patch2500: linux-2.6.13-taskaux.patch
Patch2501: linux-2.6.13-keys.patch
Patch2502: linux-2.6.13-key-syscall.patch
Patch2503: linux-2.6.13-key-reiserfs.patch
Patch2504: linux-2.6.13-key-calculate-keyring-size.patch
Patch2505: linux-2.6.13-key-updates.patch


# Core FS patches
Patch2550: linux-2.6.12-free-secdata.patch
Patch2551: linux-2.6.12-osync-bdev.patch
Patch2552: linux-2.6.9-blkgetsize-compat-ioctl.patch
Patch2553: linux-2.6.9-dio-vs-truncate.patch
Patch2554: linux-2.6.9-olargefile.patch
Patch2555: linux-2.6.9-osync-error.patch
Patch2556: linux-2.6.9-generic-aio-retval.patch
Patch2557: linux-2.6.9-auditfs.patch
Patch2558: linux-2.6.9-auditfs-lock-contention.patch
Patch2559: linux-2.6.9-audit-panic.patch
Patch2560: linux-2.6.9-audit-cleanup.patch
Patch2561: linux-2.6.9-odirect-2G.patch
Patch2562: linux-2.6.9-register-disk.patch
Patch2563: linux-2.6.9-iosched.patch
Patch2565: linux-2.6.9-readpage-invalidate.patch
Patch2566: linux-2.6.9-fd-limit.patch
Patch2567: linux-2.6.9-dio-gfs-locking.patch
Patch2568: linux-2.6.9-poll.patch
Patch2569: linux-2.6.9-fs-lsm-hooks.patch

# Device Mapper patches
Patch2600: linux-2.6.13-dm-swap-error.patch
Patch2601: linux-2.6.13-dm-private-workqueue.patch
Patch2602: linux-2.6.13-dm-emc-memset.patch
Patch2603: linux-2.6.13-dm-flush-workqueue.patch
Patch2604: linux-2.6.13-dm-raid1-limit-bios-size.patch
Patch2605: linux-2.6.13-dm-email.patch
Patch2606: linux-2.6.13-dm-snapshot-origin.patch
Patch2607: linux-2.6.13-dmc-locking.patch
Patch2608: linux-2.6.13-dm-mpath-suspend.patch
Patch2609: linux-2.6.13-dm-mpath-eio.patch
Patch2610: linux-2.6.13-dm-mpath-pg-init.patch
Patch2611: linux-2.6.13-dm-mpath-scsi-error.patch
Patch2612: linux-2.6.14-dm-updates.patch
Patch2613: linux-2.6.9-dm-mirror-update.patch

# OpenIB Infiniband patches
Patch2700: linux-2.6.9-OFED-1.0-rc6.patch
Patch2701: linux-2.6.9-spinlock-define.patch
Patch2702: linux-2.6.9-if_infiniband.patch
Patch2703: linux-2.6.9-gfp_t-typedef.patch
Patch2704: linux-2.6.9-empty-debugfs.patch
Patch2705: linux-2.6.9-mutex-backport.patch
Patch2706: linux-2.6.9-pci_find_next_cap.patch
Patch2707: linux-2.6.9-scsi_scan_target-export.patch
Patch2708: linux-2.6.9-wait_for_completion_timeout.patch
Patch2709: linux-2.6.9-OpenIB-build.patch
Patch2710: linux-2.6.9-OpenIB-core.patch
Patch2711: linux-2.6.9-OpenIB-idr.patch
Patch2712: linux-2.6.9-OpenIB-mthca-dev.patch
Patch2713: linux-2.6.9-OpenIB-mthca-provider.patch
Patch2714: linux-2.6.9-OpenIB-sdp-orphan.patch
Patch2715: linux-2.6.9-OpenIB-srp-locking.patch
Patch2716: linux-2.6.9-OpenIB-umad.patch
Patch2717: linux-2.6.9-OpenIB-uverbs.patch
Patch2718: linux-2.6.9-OpenIB-srp-header.patch
Patch2719: linux-2.6.9-OpenIB-addr-arp.patch
Patch2720: linux-2.6.9-OpenIB-addr-include.patch
Patch2721: linux-2.6.9-OpenIB-ucm-devt.patch
Patch2722: linux-2.6.9-OpenIB-ucma.patch
Patch2723: linux-2.6.9-OpenIB-device-backport.patch
Patch2724: linux-2.6.9-OpenIB-read_mostly.patch
Patch2725: linux-2.6.9-OpenIB-scatterlist.patch
Patch2726: linux-2.6.9-OpenIB-ipoib-neighbour.patch
Patch2727: linux-2.6.9-OpenIB-skb_header_release.patch
Patch2728: linux-2.6.9-OpenIB-ia64-bitop.patch
Patch2729: linux-2.6.9-OpenIB-net-includes.patch
Patch2730: linux-2.6.9-OpenIB-workqueue.patch
Patch2731: linux-2.6.9-OpenIB-add_lmc_cache.patch
Patch2732: linux-2.6.9-OpenIB-flush_core_git.patch
Patch2733: linux-2.6.9-OpenIB-flush_users.patch
Patch2734: linux-2.6.9-OpenIB-git_ucm_ib_listen.patch
Patch2735: linux-2.6.9-OpenIB-ipath_rollup.patch
Patch2736: linux-2.6.9-OpenIB-ipoib_misaligned.patch
Patch2737: linux-2.6.9-OpenIB-ipoib_netif_wake_fix.patch
Patch2738: linux-2.6.9-OpenIB-local_sa.patch
Patch2739: linux-2.6.9-OpenIB-mad_rmpp_requester_retry.patch
Patch2740: linux-2.6.9-OpenIB-rdma_misc.patch
Patch2741: linux-2.6.9-OpenIB-request_check_GID_LID.patch
Patch2742: linux-2.6.9-OpenIB-sa_pack_unpack.patch
Patch2743: linux-2.6.9-OpenIB-srp_avoid_null_deref.patch
Patch2744: linux-2.6.9-OpenIB-srp_saquery.patch
Patch2745: linux-2.6.9-OpenIB-ipath-backport.patch
Patch2746: linux-2.6.9-OpenIB-srp-host.patch
Patch2747: linux-2.6.9-OFED-rc6-to-final.patch
Patch2748: linux-2.6.9-OpenIB-mthca_cq_error.patch
Patch2749: linux-2.6.9-OpenIB-sdp_fix.patch

# EDAC Support
Patch2800: linux-2.6.9-edac.patch


Patch2999: linux-2.6.3-printopen.patch

#
# External drivers that are about to get accepted upstream
#

# Emulex FC driver
Patch3000: linux-2.6.9-emulex-lpfc.patch
Patch3001: linux-2.6.9-emulex-lpfc-80163.patch
Patch3002: linux-2.6.9-emulex-lpfc-80166.patch
Patch3003: linux-2.6.9-emulex-lpfc-80166x2.patch
Patch3004: linux-2.6.9-emulex-lpfc-801611.patch
Patch3005: linux-2.6.9-emulex-lpfc-801617.patch
Patch3006: linux-2.6.9-emulex-lpfc-801618.patch
Patch3007: linux-2.6.9-emulex-lpfc-801626.patch
Patch3008: linux-2.6.9-emulex-lpfc-shutdown.patch
Patch3009: linux-2.6.9-emulex-lpfcdfc-20014.patch

# Speedtouch USB DSL modem driver.
#Patch3010: linux-2.6.9-speedtouch.patch

# Speedtouch and Conexant USB DSL modem driver.
Patch3010: linux-2.6.9-endian-usbatm-CVS-2005-07-02.patch

# Intel Centrino wireless drivers.
Patch3020: linux-2.6.9-ipw2100.patch
Patch3021: linux-2.6.9-ipw2200.patch
Patch3022: linux-2.6.9-ieee80211.patch
Patch3023: linux-2.6.9-80211-update.patch
Patch3024: linux-2.6.9-ipw2100-update.patch
Patch3025: linux-2.6.9-ipw2200-update.patch

# Misc bits.
Patch4001: linux-2.6.10-ac-selected-bits.patch
Patch4002: linux-2.6.9-pty-smp-race.patch
Patch4003: linux-2.6.9-intel8x0-sound-ids.patch
Patch4004: linux-2.6.9-x86-sysrq-b-oops.patch
Patch4005: linux-2.6.9-sys_io_setup-unwritable-addr.patch
Patch4006: linux-2.6.9-ptrace-fixes.patch
Patch4007: linux-2.6.9-panic_on_oops-default.patch
Patch4008: linux-2.6.11-sys_ipc-fix.patch
Patch4009: linux-2.6.9-gpt-partition-noprobe.patch
Patch4010: linux-2.6.9-tmpfs-truncate-BUG.patch
Patch4011: linux-2.6.9-cpufreq-silence-warnings.patch
Patch4012: linux-2.6.9-vesafb-probe-error.patch
Patch4013: linux-2.6.9-dellserial.patch
Patch4014: linux-2.6.9-autofs-leak.patch
Patch4015: linux-2.6.9-tty-locking-fix.patch
Patch4016: linux-2.6.9-execshield-iret.patch
Patch4017: linux-2.6.9-sysrq-enhancements.patch
Patch4018: linux-2.6.9-do_task_stat-accounting-fixes.patch
Patch4019: linux-2.6.11-serial-ns16550a-baud-rate-adjust.patch
Patch4020: linux-2.6.9-quirks.patch
Patch4021: linux-2.6.9-tmpfs-symbolic-oops.patch
Patch4022: linux-2.6.9-esb2-support.patch
Patch4023: linux-2.6.9-sigkill.patch
Patch4024: linux-2.6.9-bio-clone.patch
Patch4025: linux-2.6.9-acpi-powernow-fix.patch
Patch4026: linux-2.6.9-hangcheck-timer.patch
Patch4027: linux-2.6.9-aio.patch
Patch4028: linux-2.6.9-kallsyms-insmod.patch
Patch4029: linux-2.6.9-locks-after-close.patch
Patch4030: linux-2.6.9-autofs.patch
Patch4031: linux-2.6.9-isdn.patch
Patch4032: linux-2.6.9-sound-i810.patch
Patch4033: linux-2.6.9-get-set-priority.patch
Patch4034: linux-2.6.9-disassociate-ctty.patch
Patch4035: linux-2.6.9-signal-coredump.patch
Patch4036: linux-2.6.9-mq.patch
Patch4037: linux-2.6.9-wacom-driver-update.patch
Patch4038: linux-2.6.9-rbu-firmware-driver.patch
Patch4039: linux-2.6.9-docs.patch
Patch4040: linux-2.6.9-blank-screen-console.patch
Patch4041: linux-2.6.9-softrepeat-off.patch
Patch4042: linux-2.6.9-sound-updates.patch
Patch4043: linux-2.6.9-procfs-removal.patch
Patch4044: linux-2.6.9-dcdbas.patch
Patch4045: linux-2.6.9-serial-hang.patch
Patch4046: linux-2.6.9-pci-bist.patch
Patch4047: linux-2.6.9-proc-devices.patch
Patch4048: linux-2.6.9-tunable-per-cpu-pages.patch
Patch4049: linux-2.6.9-tunable-wake-balance.patch
Patch4050: linux-2.6.9-proc-meminfo.patch
Patch4051: linux-2.6.9-i2c.patch
Patch4052: linux-2.6.9-audit-execve.patch
Patch4053: linux-2.6.9-rsa-driver-fixes.patch
Patch4054: linux-2.6.9-boot-cpu-id.patch

# ALSA fixes.
Patch4100: linux-2.6.9-alsa-vx222-newid.patch
Patch4101: linux-2.6.9-alsa-intel-hd-driver.patch
Patch4102: linux-2.6.9-alsa-realtek-alc260.patch
Patch4103: linux-2.6.9-alsa-intel-hd-driver-update.patch

# Security fixes.
Patch5000: linux-2.6.9-CAN-2004-1056-drm-insufficient-locking.patch
Patch5001: linux-2.6.9-CAN-2004-1137-igmp-flaws.patch
Patch5002: linux-2.6.9-CAN-2004-1235-do_brk.patch
Patch5003: linux-2.6.9-CAN-2005-0001-expand-stack-race.patch
Patch5004: linux-2.6.9-CAN-2005-0135-ia64-unwind.patch
Patch5005: linux-2.6.9-CAN-2005-0136-ia64-ptrace.patch
Patch5006: linux-2.6.9-CAN-2005-0176-shmlockperms.patch
Patch5007: linux-2.6.9-CAN-2005-0204-outs-iobitmap.patch
Patch5009: linux-2.6.9-CAN-2005-0209-dst-leak.patch
Patch5010: linux-2.6.9-CAN-2005-0384-ppp-dos.patch
Patch5011: linux-2.6.9-CAN-2005-0400-ext2-infoleak.patch
Patch5012: linux-2.6.9-CAN-2005-0449-ip_defrag.patch
Patch5013: linux-2.6.9-CAN-2005-0531-size_t.patch
Patch5014: linux-2.6.9-CAN-2005-0736-epoll-overflow.patch
Patch5015: linux-2.6.9-CAN-2005-0749-elfloader-kfree.patch
Patch5016: linux-2.6.9-CAN-2005-0750-bluetooth-rangecheck.patch
Patch5017: linux-2.6.9-CAN-2005-1762-x86_64-ptrace-canonical-addr.patch
Patch5018: linux-2.6.9-CAN-2005-0767-drm-radeon-race.patch
Patch5019: linux-2.6.9-CAN-2005-0815-isofs.patch
Patch5020: linux-2.6.9-CAN-2005-0839-N_MOUSE.patch
Patch5021: linux-2.6.10-CAN-2005-0867-sysfs-signedness.patch
Patch5022: linux-2.6.9-CAN-2005-1263-binfmt_elf.patch
Patch5023: linux-2.6.9-CAN-2005-1264-raw-blkdev_ioctl.patch
Patch5024: linux-2.6.12-CAN-2005-1761-ia64-ptrace.patch
Patch5025: linux-2.6.9-CAN-2005-0756-x8664-ptrace-check-segment.patch
Patch5026: linux-2.6.9-CAN-2005-1765-x8664-ptrace-overflow.patch
Patch5027: linux-2.6.9-CAN-2005-2555-cap-net-admin.patch
Patch5028: linux-2.6.9-CAN-2005-2100-44split.patch
Patch5029: linux-2.6.9-CAN-2005-2490-sendmsg-compat.patch
Patch5030: linux-2.6.9-CAN-2005-2492-sendmsg.patch
Patch5031: linux-2.6.9-CAN-2005-2872-ipt-recent.patch
Patch5032: linux-2.6.9-CAN-2005-3053-set-mempolicy.patch
Patch5033: linux-2.6.9-CAN-2005-3110-ebtables-race.patch
Patch5034: linux-2.6.9-CAN-2005-3119-key-leak.patch
Patch5035: linux-2.6.9-CAN-2005-3180-orinoco-etherleak.patch
Patch5036: linux-2.6.9-CAN-2005-3181-getname-leak.patch
Patch5037: linux-2.6.9-CAN-2005-2458-gzip-zlib.patch
Patch5038: linux-2.6.9-CAN-2005-3106-exec-mmap.patch
Patch5039: linux-2.6.9-CAN-2005-2709-sysctl-unregister.patch
Patch5040: linux-2.6.9-CAN-2005-2800-proc-scsi.patch
Patch5041: linux-2.6.9-CVE-2005-3857-printk-dos.patch
Patch5042: linux-2.6.9-CVE-2005-3848-dst-entry-leak.patch
Patch5043: linux-2.6.9-CVE-2005-3858-ip6-input-finish-dos.patch
Patch5044: linux-2.6.9-CVE-2005-3806-ip6-flowlabel-dos.patch
Patch5045: linux-2.6.9-CVE-2005-2185-igmp-dos.patch
Patch5046: linux-2.6.9-CVE-2005-3358-mempolicy.patch
Patch5047: linux-2.6.9-CVE-2005-3784-auto-reap.patch
Patch5048: linux-2.6.9-CVE-2005-4605-proc-info-leak.patch
Patch5049: linux-2.6.9-CVE-2005-2973-ipv6-infinite-loop.patch
Patch5050: linux-2.6.9-CVE-2005-3359-atm-mod-count.patch
Patch5051: linux-2.6.9-CVE-2005-3623-nfs-acl-read.patch
Patch5052: linux-2.6.9-CVE-2006-1052-selinux-ptrace.patch
Patch5053: linux-2.6.9-CVE-2005-3055-usb-perms.patch
Patch5054: linux-2.6.9-CVE-2006-0741-elf.patch
Patch5055: linux-2.6.9-CVE-2006-1056-fpu.patch
Patch5056: linux-2.6.9-CVE-2006-2451-dumpable.patch
Patch5057: linux-2.6.9-CVE-2004-2660-odirect-mem.patch
Patch5058: linux-2.6.9-CVE-2006-1858-sctp-overflow.patch
Patch5059: linux-2.6.9-CVE-2006-2936-ftdi-sio-dos.patch
Patch5060: linux-2.6.9-CVE-2006-2935-cdrom-typo.patch
Patch5061: linux-2.6.9-CVE-2006-3468-nfs-fh.patch
Patch5062: linux-2.6.9-CVE-2006-3626-proc-setuid.patch
Patch5063: linux-2.6.9-CVE-2006-2444-snmp-nat-mem.patch
Patch5064: linux-2.6.9-CVE-2006-2932-ds-es-dos.patch

# Security fixes that don't have CANs assigned (yet?)
# These get renamed if one is later assigned.
Patch5100: linux-2.6.9-ptrace-sched-race.patch

#
# original from: http://mesh.dl.sourceforge.net/sourceforge/colinux/colinux-0.6.2.tar.gz
# patch does apply only to 2.6.8
#Patch8000: colinux-0.6.2.patch
#Patch8002: linux-2.6.4-syslog.patch
Patch8003: linux-2.6.11-broken_conntrack_nf_fix.patch
Patch8005: kernel-2.6.9-2.6.10-layer7-1.2.patch
Patch8006: http://www.openswan.org/download/openswan-2.4.0.kernel-2.6-natt.patch.gz

#
# 10000 to 20000 is for stuff that has to come last due to the
# amount of drivers they touch. But only these should go here. 
# Not patches you're too lazy for to put in the proper place.
#

Patch10000: linux-2.6.0-compile.patch
Patch10001: linux-2.6.9-exports.patch
Patch10002: linux-2.6.9-slab-update.patch
Patch10003: linux-2.6.9-pci-ids.patch

# empty final patch file to facilitate testing of kernel patches
Patch20000: linux-kernel-test.patch

Patch99999: xen.patch

# patchomatic patches
Patch100000: iptables-1.3.2-pptp-20050720-workaround.patch

# END OF PATCH DEFINITIONS

BuildRoot: %{_tmppath}/kernel-%{KVERREL}-root

%description 
The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

%package devel
Summary: Development package for building kernel modules to match the kernel.
Group: System Environment/Kernel
AutoReqProv: no
Provides: kernel-devel-%{_target_cpu} = %{rpmversion}-%{release}

%description devel
This package provides kernel headers and makefiles sufficient to build modules
against the kernel package.

%package sourcecode
Summary: The source code for the Linux kernel.
Group: Development/System
Prereq: fileutils
Requires: make >= 3.78
Requires: gcc >= 3.2
Requires: /usr/bin/strip
# for xconfig and gconfig
Requires: qt-devel, gtk2-devel readline-devel ncurses-devel
Provides: kernel-source
Obsoletes: kernel-source <= 2.6.6

%description sourcecode
The kernel-sourcecode package contains the source code files for the Linux
kernel. The source files can be used to build a custom kernel that is
smaller by virtue of only including drivers for your particular hardware, if
you are so inclined (and you know what you're doing). The customisation
guide in the documentation describes in detail how to do this. This package
is neither needed nor usable for building external kernel modules for
linking such modules into the default operating system kernels.

%package doc
Summary: Various documentation bits found in the kernel source.
Group: Documentation
%if !%{buildsource}
Obsoletes: kernel-source <= 2.6.6
Obsoletes: kernel-sourcecode <= 2.6.6
%endif

%description doc
This package contains documentation files from the kernel
source. Various bits of information about the Linux kernel and the
device drivers shipped with it are documented in these files. 

You'll want to install this package if you need a reference to the
options that can be passed to Linux kernel modules at load time.


%package smp
Summary: The Linux kernel compiled for SMP machines.

Group: System Environment/Kernel
Provides: kernel = %{version}
Provides: kernel-drm = 4.3.0
Prereq: %{kernel_prereq}
Conflicts: %{kernel_dot_org_conflicts}
Conflicts: %{package_conflicts}
Conflicts: %{nptl_conflicts}
# upto and including kernel 2.4.9 rpms, the 4Gb+ kernel was called kernel-enterprise
# now that the smp kernel offers this capability, obsolete the old kernel
Obsoletes: kernel-enterprise < 2.4.10
# We can't let RPM do the dependencies automatic because it'll then pick up
# a correct but undesirable perl dependency from the module headers which
# isn't required for the kernel proper to function

Provides: kernel-smp-%{_target_cpu} = %{rpmversion}-%{release}
%if %{kabi}
Provides: kABI(%{kabi_major}smp.%{_target_cpu}) = %{kabi_minor}
%endif

%description smp
This package includes a SMP version of the Linux kernel. It is
required only on machines with two or more CPUs as well as machines with
hyperthreading technology.

Install the kernel-smp package if your machine uses two or more CPUs.

%package smp-devel
Summary: Development package for building kernel modules to match the SMP kernel.
Group: System Environment/Kernel
Provides: kernel-smp-devel-%{_target_cpu} = %{rpmversion}-%{release}
AutoReqProv: no

%description smp-devel
This package provides kernel headers and makefiles sufficient to build modules
against the SMP kernel package.

%package hugemem
Summary: The Linux kernel compiled for machines with 16 Gigabytes of memory or more.
Group: System Environment/Kernel
Provides: kernel = %{version}
Provides: kernel-drm = 4.3.0
Prereq: %{kernel_prereq}
Conflicts: %{kernel_dot_org_conflicts}
Conflicts: %{package_conflicts}
Conflicts: %{nptl_conflicts}
Obsoletes: kernel-enterprise < 2.4.10
# We can't let RPM do the dependencies automatic because it'll then pick up
# a correct but undesirable perl dependency from the module headers which
# isn't required for the kernel proper to function

Provides: kernel-hugemem-%{_target_cpu} = %{rpmversion}-%{release}
%if %{kabi}
Provides: kABI(%{kabi_major}hugemem.%{_target_cpu}) = %{kabi_minor}
%endif

%description hugemem
This package includes an SMP version of the Linux kernel which
supports systems with 16 Gigabytes of memory or more.

%package hugemem-devel
Summary: Development package for building kernel modules to match the hugemem kernel.
Group: System Environment/Kernel
Provides: kernel-hugemem-devel-%{_target_cpu} = %{rpmversion}-%{release}
AutoReqProv: no

%description hugemem-devel
This package provides kernel headers and makefiles sufficient to build modules
against the hugemem kernel package.

%package largesmp
Summary: The Linux kernel compiled for machines with more than 64 CPUs.

Group: System Environment/Kernel
Provides: kernel = %{version}
Provides: kernel-drm = 4.3.0
Prereq: %{kernel_prereq}
Conflicts: %{kernel_dot_org_conflicts}
Conflicts: %{package_conflicts}
Conflicts: %{nptl_conflicts}
# upto and including kernel 2.4.9 rpms, the 4Gb+ kernel was called kernel-enterprise
# now that the largesmp kernel offers this capability, obsolete the old kernel
Obsoletes: kernel-enterprise < 2.4.10
# We can't let RPM do the dependencies automatic because it'll then pick up
# a correct but undesirable perl dependency from the module headers which
# isn't required for the kernel proper to function

Provides: kernel-largesmp-%{_target_cpu} = %{rpmversion}-%{release}
%if %{kabi}
Provides: kABI(%{kabi_major}largesmp.%{_target_cpu}) = %{kabi_minor}
%endif

%description largesmp

This package includes a version of the Linux kernel configured to handle up to
64 CPUs on X86-64, 128 CPUs on PPC64 and 512 CPUs on IA-64.

Install the kernel-largesmp package if your machine has more than 8 CPUs on 
x86-64, more than 64 CPUs on PPC64, or more than 64 CPUs on IA-64.

%package largesmp-devel
Summary: Development package for building modules for the many-CPUs kernel.
Group: System Environment/Kernel
Provides: kernel-largesmp-devel-%{_target_cpu} = %{rpmversion}-%{release}
AutoReqProv: no

%description largesmp-devel
This package provides kernel headers and makefiles sufficient to build modules
against the many CPUs kernel package.

%package xenU
Summary: The Linux kernel compiled for the Xen hypervisor.

Group: System Environment/Kernel
Provides: kernel = %{version}
Provides: kernel-drm = 4.3.0
Prereq: %{kernel_prereq}
Conflicts: %{kernel_dot_org_conflicts}
Conflicts: %{package_conflicts}
Conflicts: %{nptl_conflicts}
# upto and including kernel 2.4.9 rpms, the 4Gb+ kernel was called kernel-enterprise
# now that the xenU kernel offers this capability, obsolete the old kernel
Obsoletes: kernel-enterprise < 2.4.10
# We can't let RPM do the dependencies automatic because it'll then pick up
# a correct but undesirable perl dependency from the module headers which
# isn't required for the kernel proper to function

Provides: kernel-xenU-%{_target_cpu} = %{rpmversion}-%{release}
%if %{kabi}
Provides: kABI(%{kabi_major}xenU.%{_target_cpu}) = %{kabi_minor}
%endif

%description xenU
This package includes a version of the Linux kernel compiled for
Xen.

Install the kernel-xenU package if your machine is a virtual machine
running on Xen.

The port to Xen was performed by, and is supported by, XenSource,
Inc. (version 8a9d268dc9d1)

%package xenUpae
Summary: The Linux kernel compiled for the Xen hypervisor.

Group: System Environment/Kernel
Provides: kernel = %{version}
Provides: kernel-drm = 4.3.0
Prereq: %{kernel_prereq}
Conflicts: %{kernel_dot_org_conflicts}
Conflicts: %{package_conflicts}
Conflicts: %{nptl_conflicts}
# upto and including kernel 2.4.9 rpms, the 4Gb+ kernel was called kernel-enterprise
# now that the xenU kernel offers this capability, obsolete the old kernel
Obsoletes: kernel-enterprise < 2.4.10
# We can't let RPM do the dependencies automatic because it'll then pick up
# a correct but undesirable perl dependency from the module headers which
# isn't required for the kernel proper to function

Provides: kernel-xenUpae-%{_target_cpu} = %{rpmversion}-%{release}
%if %{kabi}
Provides: kABI(%{kabi_major}xenUpae.%{_target_cpu}) = %{kabi_minor}
%endif

%description xenUpae
This package includes a version of the Linux kernel compiled for
Xen.

Install the kernel-xenU package if your machine is a virtual machine
running on Xen.

The port to Xen was performed by, and is supported by, XenSource,
Inc. (version 8a9d268dc9d1)

%package xenU-devel
Summary: Development package for building modules for the many-CPUs kernel.
Group: System Environment/Kernel
Provides: kernel-xenU-devel-%{_target_cpu} = %{rpmversion}-%{release}
AutoReqProv: no

%description xenU-devel
This package provides kernel headers and makefiles sufficient to build modules
against the many CPUs kernel package.

%define KERNEL_PATH ${RPM_BUILD_DIR}/%{name}-%{version}/linux-%{kversion}
%define IPTABLES_PATH ${RPM_BUILD_DIR}/%{name}-%{version}/iptables-%{iptables_version}

%prep

%setup -q -n %{name}-%{version} -c
cd linux-%{kversion}

#
# Patches 0 through 100 are meant for core subsystem upgrades
# 

# Various fixes from Alan's -ac tree.
%patch3 -p1
%patch4 -p1

#
# Patches to back out
#

# -AC bits we don't want.
%patch10 -p1 -R
# iobitmap increase that breaks booting
%patch11 -p1 -R

#
# Architecture patches
#

#
# x86(-64)
#
# fix x86_64 copy_user_generic
%patch201 -p1
# Share cache descriptors between x86/x86-64
%patch202 -p1
# x86_64: add an option to configure oops stack dump
%patch203 -p1
# x86[64]: display phys_proc_id only when it is initialized
%patch204 -p1
# x86_64: no TIOCSBRK/TIOCCBRK in ia32 emulation
%patch205 -p1
# Fix show_trace() in irq context with CONFIG_4KSTACKS
%patch206 -p1
# x86_64: Fix lost edge triggered irqs on UP kernel
%patch207 -p1
# x86_64: Reenable MGA DRI
%patch208 -p1
# Fix Buffer overrun in arch/x86_64/sys_ia32.c:sys32_ni_syscall()
%patch209 -p1
# Flexible mmap patch for x86-64 
%patch210 -p1
# Fix wrong TASK_SIZE on x86_64 for 32bit processes
%patch211 -p1
# Clear ebp on sysenter return.
%patch212 -p1
# Fix up wrong argument order in dma_declare_coherent_memory()
%patch213 -p1
# ICH7 ID additions
%patch214 -p1
# HPET init needs register to be whacked twice.
%patch215 -p1
# fix i386 vsyscall-sysenter unwind info
%patch216 -p1
# missing lock in switch_to()
%patch217 -p1
# Intel enhanced speedstep fixes.
%patch218 -p1
# NMI switch support for x86_64
%patch219 -p1
# Fix panic() w/panic_timeout hangs instead of rebooting
%patch220 -p1
# SRAT NUMA support.
%patch221 -p1
# Fix hugepages for x86_64
%patch222 -p1
# Fix flush of multiple pages in change_page_attr
%patch223 -p1
# fix syscall/signal restart bug
%patch224 -p1
# Clustered APIC support for x86-64.
%patch225 -p1
# Dual core support for AMD64.
%patch226 -p1
# x86: use the IRQ stack in APIC contexts too
%patch227 -p1
# Numerous ioremap fixes.
%patch228 -p1
# make newer intel cpus recognize cpuid4
%patch229 -p1
# HPET legacy
%patch230 -p1
# intel dual core support
%patch231 -p1
# x8664 acpi off
%patch232 -p1
# powernow k8 support
%patch233 -p1
# x8664 reboot fix
%patch234 -p1
# x8664 hotplug fix
%patch235 -p1
# x8664 enable numa
%patch236 -p1
# x8664 csum partial copy
%patch237 -p1
# x8664 morrison numa fixes
%patch238 -p1
# x86 disable irqs during bogomips calcuation
%patch239 -p1
# x8664 correct pfn_valid
%patch240 -p1
# fix x86 thread info leak
%patch241 -p1
# largesmp patches for x86664
%patch242 -p1
# add cpu_relax() calls
%patch243 -p1
# add noht option for x86 and x86-64
%patch244 -p1
# fix cpufrequency
%patch245 -p1
# implement dma_sync_single_range_for_{cpu,device}
%patch246 -p1
# support for unisys boxes
%patch247 -p1
# eliminate noiommu panic
%patch248 -p1
# fix 32-bit hang
%patch249 -p1
# include iomap.h
%patch250 -p1
# avoid calling node_to_cpumask too early
%patch251 -p1
# autodetect and setup bigsmp mode
%patch252 -p1
# make i810, i830, and i915 build on x86_64
%patch253 -p1
# x8664: add core map support
%patch254 -p1
# x8664: mce updates
%patch255 -p1
# make sure we don't re-assign ioapic addresses
%patch256 -p1
# make oprofile work on p4 systems
%patch257 -p1
# let the BIOS tell us how to set lapic/ioapic for up kernels
%patch258 -p1
# irq compression
%patch259 -p1
# srat paring fix
%patch260 -p1
# find space for pagetables
%patch261 -p1
# mem limit
%patch262 -p1
# setup gap
%patch263 -p1
# dmi scan update
%patch264 -p1
# Mark vDSO signal trampoline EH with the new S flag
%patch265 -p1
# support longer x86_64 cmd line
%patch266 -p1
# disable tlb flush filter
%patch267 -p1
# modern_apic()
%patch268 -p1
# proper sci overridate
%patch269 -p1
# automatically set timer_over_8254
%patch270 -p1
# lapic status for installer
%patch271 -p1
# avoid EBDA for early memory map allocation
%patch272 -p1

# 
# ppc64
#

# Patch for Kconfig and Makefile build issues
%patch300 -p1
%patch301 -p1
# Fix single stepping on PPC64
%patch302 -p1
# HVSI udbg support
%patch303 -p1
# Make HVSI console survive FSP reset
%patch304 -p1
# Make PCI hostbridge hotplugging work
%patch305 -p1
# Fix IBM VSCSI problems
%patch306 -p1
# Store correct backtracking info in ppc64 signal frames
%patch307 -p1
# Prevent HVSI from oopsing on hangup
%patch308 -p1
# Make ppc64 NUMA map CPU->node before bringing up the CPU
%patch309 -p1
# sched domains / cpu hotplug cleanup
%patch310 -p1
# Add a CPU_DOWN_PREPARE hotplug CPU notifier
%patch311 -p1
# Register a cpu hotplug notifier to reinitialize the scheduler domains hierarchy
%patch312 -p1
# Make arch_destroy_sched_domains() conditional
%patch313 -p1
# Use CPU_DOWN_FAILED notifier in the sched-domains hotplug code
%patch314 -p1
# PPC64 sigsuspend stomping on r4 and r5
%patch315 -p1
# Enable ICOM serial driver
%patch316 -p1
# IBM VSCSI driver race fix
%patch317 -p1
# Ensure PPC64 interrupts don't end up hard-disabled
%patch318 -p1
# Add PURR and version data to /proc/ppc64/lparcfg
%patch319 -p1
# Convert to using ibm,read-slot-reset-state2 RTAS call
%patch320 -p1
# Fix inability to find space for TCE table on ppc64
%patch321 -p1
# Prevent block device queues from being shared in viocd
%patch322 -p1
# Align PACA buffer for ppc64 hypervisor's use
%patch323 -p1
# Indicate that the veth link is always up
%patch324 -p1
# Quiesce OpenFirmware stdin device at boot.
%patch325 -p1
# Make ppc64's pci_alloc_consistent() conform to documentation
%patch326 -p1
# fix stack alignment for signal handlers on ppc64
%patch327 -p1
# Provide working PCI EEH error recovery on ppc64 (#135115)
%patch328 -p1
# Move idle loop setup to after main ppc64 arch setup init. (#142634)
%patch329 -p1
# Provide 64-bit translations for 32-bit TIOCMIWAIT/TIOCGICOUNT ioctls
%patch330 -p1
# Fix PPC64 pSeries VPA registration
%patch331 -p1
# Fix communication to PROM to close stdin on PPC64
%patch332 -p1
# Implement h/w PPC64 CPU utilisation data gathering
%patch333 -p1
# Stop xmon=on from jumping immediately into xmon on ppc64
%patch334 -p1
# Fix race and memory leak in iSeries veth module unloading
%patch335 -p1
# Prevent an iSeries partition oopsing with no CDROM drive.
%patch336 -p1
# IBM veth driver buffer starvation fix
%patch337 -p1
# Don't map objects to non-existent PPC64 NUMA nodes
%patch338 -p1
# Fix PPC64 NUMA's handling of memory nodes with holes in them
%patch339 -p1
# move clearing of RI bit to after stack restoration
%patch340 -p1
# Fix a dangling pointer in the IBM vscsi driver
%patch341 -p1
# Implement correct logic for determining hotplug capabilities
%patch342 -p1
# Tell the firmware what the kernels capabilities are
%patch343 -p1
# avoid probing pci devices marked as failed.
%patch344 -p1
# set pci I/O base dynamically
%patch345 -p1
# don't request legacy I/O regions if no ISA bus
%patch346 -p1
# allow hotplug of eeh devices
%patch347 -p1
# add pci eeh error recovery documentation
%patch348 -p1
# update vscsi to v. 1.5.5
%patch349 -p1
# ppc64 signal frame
%patch350 -p1
# Only access extended PCI config regs if available
%patch351 -p1
# make sure sys_sigreturn calls audit
%patch352 -p1
# fix iommu_map_sg to terminate scatter gather list correctly
%patch353 -p1
# veth driver updates
%patch354 -p1
# add jasmine serial driver
%patch355 -p1
# fix xmon locking
%patch356 -p1
# evade hypervisor bug
%patch357 -p1
# add power5+ cpu support
%patch358 -p1
# js20++ cpu enablement
%patch359 -p1 
#add chip id for ATI RN50
%patch360 -p1
#fix offb crash
%patch361 -p1
# fix oprofile for
%patch362 -p1
# fix time going backwards
%patch363 -p1
# fix cpu hotplug
%patch364 -p1
# support early serial console
%patch365 -p1
# fix incorrect get_uswer usage
%patch366 -p1
# eeh dynamic
%patch367 -p1
# ptrace fixes
%patch368 -p1
# fix userspace access checks
%patch369 -p1

#
# ia64
#

# Basic build fixes
%patch400 -p1
%patch401 -p1
%patch402 -p1
%patch403 -p1
%patch404 -p1
%patch405 -p1
%patch406 -p1
%patch407 -p1
%patch408 -p1
%patch409 -p1
%patch410 -p1
%patch411 -p1
%patch412 -p1
%patch413 -p1
%patch414 -p1
%patch415 -p1
%patch416 -p1
%patch417 -p1
%patch418 -p1
# tollhouse support
%patch419 -p1
%patch420 -p1
%patch421 -p1
%patch422 -p1
%patch423 -p1
# make sure gate page is mapped
%patch424 -p1
# sn update
%patch425 -p1
%patch426 -p1
%patch427 -p1
%patch428 -p1
%patch429 -p1
%patch430 -p1
%patch431 -p1
%patch432 -p1
%patch433 -p1
%patch434 -p1
%patch435 -p1
%patch436 -p1
%patch437 -p1
%patch438 -p1
%patch439 -p1
%patch440 -p1
%patch441 -p1

#
# s390
#

# Basic build fixes
%patch500 -p1
# Auto raidstart for S390
%patch501 -p1
# Fix fake_ll for QETH device  (#136175)
%patch502 -p1
# Recover after aborted nameserver request.
%patch503 -p1
# zfcp: Kernel stack frame for zfcp_cfdc_dev_ioctl() is too big
%patch504 -p1
# Fixed buffers for DASD devices.
%patch506 -p1
# Fix coredumps on S390
%patch507 -p1
# lcs device will not start anymore after first detection.
%patch508 -p1
# Fix possible failure of IP addr registration
%patch509 -p1
# Support broadcast on z800/z900 HiperSockets
%patch510 -p1
# fix race condition on s390 when going idle
%patch511 -p1
# include watchdog config on s390
%patch512 -p1
# introduce sequence numbers for lcs packets.
%patch513 -p1
# qeth fake_ll fixes
%patch514 -p1
# delay dasd retries to prevent i/o error
%patch515 -p1
# s390 qdio packet loss
%patch516 -p1
# Fix various problems in s390 common I/O layer.
%patch517 -p1
# s390 common i/o layer vary on/off
%patch518 -p1
# s390 qdio time delay missing interrupt problem
%patch519 -p1
# s390 fix pagefault handler deadlock
%patch520 -p1
# s390 fix qeth stalls and update
%patch521 -p1
# s390 zfcp driver update
%patch522 -p1
# s390 correct memory size read
%patch523 -p1
# s390 fix fadvise for s390x and compat
%patch524 -p1
# s390 dasd + cio driver updates
%patch525 -p1
# s390 crypto driver update to 1.16
%patch526 -p1
# s390 pfault interrupt race fix
%patch527 -p1
# s390 ptrace peek poke fixes
%patch528 -p1
# s390 swap offset fixes
%patch529 -p1
# s390 internal return
%patch530 -p1
# s390 cio patch retry
%patch531 -p1
# s390: add vmcp device driver
%patch532 -p1
# s390: stop debug feature on oops
%patch533 -p1
# s390: add vm logreader driver
%patch534 -p1
# s390: add vm watchdog driver
%patch535 -p1
# qeth driver updates
%patch536 -p1
# s390: semaphore performance fixes
%patch537 -p1
# s390: add ctc mpc driver
%patch538 -p1
# fix signal quiesce
%patch539 -p1
# s390: add fixup exception for diag10 instruction
%patch540 -p1
# s390: make strnlen_user correct
%patch541 -p1
# s390: qeth ui64 fixes
%patch542 -p1
# s390: test_bit fixes
%patch543 -p1
# s390: fix and enable dcssblk driver
%patch544 -p1
# s390: fix possible kernel stack corruption
%patch545 -p1
# s390: sysrq backtrace oops
%patch546 -p1
# s390: fix crypto driver memory overwrite
%patch547 -p1
# s390: lcs driver fixes
%patch548 -p1
# s390: add hypfs filesystem
%patch549 -p1

#
# Patches 500 through 1000 are reserved for bugfixes to the core system
# and patches related to how RPMs are build
#


# This patch adds a "make nonint_oldconfig" which is non-interactive and
# also gives a list of missing options at the end. Useful for automated
# builds (as used in the buildsystem).
%patch900 -p1


#
# The execshield patch series, broken into smaller pieces
#
# 1) Exec shield core
%patch910 -p1
# 2) Option to printk fatal signals, useful for debugging
%patch911 -p1
# 3) The Execshield VA rearrangements
%patch912 -p1
# fix nx for large pages
%patch913 -p1
# ht active load balancing bugfix
%patch914 -p1

#
# 4G/4G split
#
%patch920 -p1 -R
%patch921 -p1
%patch922 -p1
%patch923 -p1
%patch924 -p1

#
# Patch that adds a __must_check attribute for functions for which checking
# the return value is mantadory (eg copy_from_user)
#
%patch930 -p1

#
# TUX
#
%patch940 -p1

# rwsem update
%patch945 -p1

# propogate bounce errors up
%patch946 -p1
# mmiowb support, no-op except for ia64
%patch947 -p1

#
# GPG signed kernel modules
#
%patch950 -p1
%patch951 -p1
%patch952 -p1
%patch953 -p1
%patch954 -p1
%patch955 -p1
%patch956 -p1
%patch957 -p1


#
# Patches 1000 to 4999 are reserved for bugfixes to drivers and filesystems
#


# add vidfail capability; 
# without this patch specifying a framebuffer on the kernel prompt would
# make the boot stop if there's no supported framebuffer device; this is bad
# for the installer cd that wants to automatically fall back to textmode
# in that case
%patch1000 -p1

#
# Fix the extreme stack usage in some kernel functions
#
%patch1020 -p1
# make smbfs honor uid and gid mount options
%patch1021 -p1
# make pci-sysfs do 2-byte accesses 
%patch1022 -p1
# selected ipmi updates
%patch1023 -p1
# update CIFS
%patch1024 -p1
# hfs fixes
%patch1025 -p1

# EXT3 bits.
# Ext3 reservations. reduces fragmentation bigtime
%patch1030 -p1
%patch1031 -p1
# improves ext3's error logging when we encounter an on-disk corruption.
%patch1032 -p1
# ext3 online resize
%patch1033 -p1
# improves ext3's ability to deal with corruption on-disk
%patch1034 -p1
# Handle double-delete of indirect blocks
%patch1035 -p1
# Fix xattr/mbcache race
%patch1036 -p1
%patch1037 -p1
# Fix percpu data leak on umount of ext2/ext3
%patch1038 -p1
# Fix ext2/3 maximum size limits
%patch1039 -p1
# Fix ext3 release race.
%patch1040 -p1
# Fix buffer leak in ext3
%patch1041 -p1
# fix kjournad vs umount race
%patch1042 -p1
# nfs enoent
%patch1043 -p1
# xattr share
%patch1044 -p1
# sub-second timestamp
%patch1045 -p1
# extend ACL limit on ext3 to EA limit
%patch1046 -p1
# fix log_do_checkpoint assertion failure
%patch1047 -p1
# ext2: fix hang on symlink removal for loop devices
%patch1048 -p1
# ext3: fix ext3/jbd race releasing journal heads
%patch1049 -p1


#
# Make /dev/mem a need-to-know function 
#
%patch1050 -p1
%patch1051 -p1


#
# /dev/crash driver for the crashdump analysis tool
#
%patch1060 -p1

#
# Most^WAll users of sleep_on are broken; fix a bunch
#
%patch1070 -p1

#
# Ingo's patch for voluntary preemption
#
%patch1080 -p1
%patch1081 -p1

#ramfs fixes
%patch1082 -p1

#
# Sata update
# 
%patch1100 -p1
%patch1101 -p1
%patch1102 -p1
%patch1103 -p1
%patch1104 -p1
%patch1105 -p1
%patch1106 -p1
%patch1107 -p1
%patch1108 -p1

#
# SCSI Bits.
#
# Additions to the SCSI whitelist to make card readers work.
%patch1120 -p1
# fix SCSI bounce limit
%patch1121 -p1
# AIC host raid support.
%patch1122 -p1
# SCSI midlayer updates from 2.6.10rc
%patch1123 -p1
# Avoid oops when insmod'ing aic79xx on machine without hardware
%patch1124 -p1
# scsi: Add reset ioctl capability to ULDs
%patch1125 -p1
# scsi: Update ips driver to 2.6.10rc version.
%patch1126 -p1
# avoid extra 'put' on devices in __scsi_iterate_device()
# http://marc.theaimsgroup.com/?l=linux-scsi&m=109886580930570&w=2
%patch1127 -p1
# Update Qlogic driver to 2.6.10-rc2
%patch1128 -p1
# cciss: fixes for clustering
%patch1129 -p1
# Fix USB forced remove oops
%patch1130 -p1
# Fix up scsi_test_unit_ready() to work correctly with CD-ROMs
%patch1131 -p1
# Plug leaks in error paths in aic driver
%patch1132 -p1
# Add refcounting to scsi command allocation
%patch1133 -p1
# return full SCSI status byte in SG_IO
%patch1134 -p1
# sg: Fix oops of sg_cmd_done and sg_release race
%patch1135 -p1
# aacraid: remove aac_handle_aif
%patch1136 -p1
# Prevent kernel panic if an application issues an ioctl with an unrecognized subopcode.
%patch1137 -p1
# Fix refcounting order in sd/sr, fixing cable pulls on USB storage.
%patch1138 -p1
# IOCTL integer overflow and information leak.
%patch1139 -p1


# Block / MD layer fixes.
# Fix blocklayer races
%patch1140 -p1
# fix bad segment coalescing in blk_recalc_rq_segments()
%patch1141 -p1
# cciss: Off-by-one error causing oops in CCISS_GETLUNIFO ioctl
%patch1142 -p1
# Fix sx8 device naming in sysfs
%patch1143 -p1
# blkdev_get_blocks(): handle eof
%patch1144 -p1
# Fix CCISS ioctl return code
%patch1145 -p1
# CCISS ID updates
%patch1146 -p1
# __getblk_slow can loop forever when pages are partially mapped
%patch1147 -p1
# md: fix two little bugs in raid10
%patch1150 -p1
# md: make sure md always uses rdev_dec_pending properly
%patch1151 -p1
# dm multipath: Add target message ioctl
%patch1152 -p1
# dm multipath: ioctl ref by device no
%patch1153 -p1
# dm: fix mirror log ref count
%patch1154 -p1
# dm multipath: Split suspend hook
%patch1155 -p1
# dm raid1: deadlock fix
%patch1156 -p1
# device-mapper: tidy error kprintfs
%patch1157 -p1
# linux-2.6.9-dm-add-dm_dev-name.patch
%patch1158 -p1
# dm multipath: bio details record/restore
%patch1159 -p1
# dm multipath: export mapinfo
%patch1160 -p1
# dm multipath.
%patch1161 -p1
# Fix 64 bit issues in device mapper.
%patch1162 -p1
# dm multipath: fix infinite suspend requeueing
%patch1163 -p1
# Avoid a bdget in device mapper.
%patch1164 -p1
# raid5/raid6 bi_max_vec fixes.
%patch1165 -p1
# fix multipath assembly bug
%patch1166 -p1
# Fix bogus level check in resync code
%patch1167 -p1
# Fix various thinkos in md.
%patch1168 -p1
# Device Mapper mirroring
%patch1169 -p1
# device mapper refcount fix
%patch1170 -p1
# device mapper raid1 race fix
%patch1171 -p1
# make clear that md does not support i/o barriers
%patch1172 -p1
# make sure md linear doesn't wrap 
%patch1173 -p1

#
# Various upstream NFS/NFSD fixes.
#
%patch1200 -p1
%patch1201 -p1
%patch1202 -p1
%patch1203 -p1
%patch1204 -p1
%patch1205 -p1
%patch1206 -p1
%patch1207 -p1
%patch1208 -p1
%patch1209 -p1
%patch1210 -p1
%patch1211 -p1
%patch1212 -p1
%patch1213 -p1
%patch1214 -p1
%patch1215 -p1
%patch1216 -p1
%patch1217 -p1
%patch1218 -p1
%patch1219 -p1
%patch1220 -p1
%patch1221 -p1
%patch1222 -p1
%patch1223 -p1
%patch1224 -p1
%patch1225 -p1
%patch1226 -p1
%patch1227 -p1
%patch1228 -p1
%patch1229 -p1
%patch1230 -p1
%patch1231 -p1
%patch1232 -p1
%patch1233 -p1
%patch1234 -p1
%patch1235 -p1
%patch1236 -p1
%patch1237 -p1
%patch1238 -p1
%patch1239 -p1
%patch1240 -p1
%patch1241 -p1
%patch1242 -p1

# Networking fixes.
# Fix IPV6 MTU calculation
%patch1300 -p1
# vlan_dev: return 0 on vlan_dev_change_mtu success
%patch1301 -p1
# Handle SIOCGIFHWADDR NULL dev->dev_addr
%patch1302 -p1
# fix missing security_*() check in net/compat.c
%patch1303 -p1
# XFRM layer bug fixes
%patch1304 -p1
# Fix CMSG validation checks wrt. signedness.
%patch1305 -p1
# Fix memory leak in ip_conntrack_ftp
%patch1306 -p1
# [IPV4]: Do not leak IP options.
%patch1307 -p1
# /proc/net/route stale pointer OOPS fix
%patch1308 -p1
# bonding: avoid kernel panic when 802.3ad link brought down.
%patch1309 -p1
# sk_forward_alloc() BUG assertion fix
%patch1310 -p1
# TCP BIC bug fix
%patch1311 -p1
# Fix fragment corruption
%patch1312 -p1
# sctp: add receive buffer accounting to protocol
%patch1313 -p1
# Fix IPSEC SA sequence collision
%patch1314 -p1
# Fix sctp sendbuffer accounting
%patch1315 -p1
# snmp6: avoid crash on dev shutdown
%patch1316 -p1
# bonding: Send IGMP traffic out only "active" link of bond+in ALB or TLB mode
%patch1317 -p1
# Fix IPSEC output spinlock deadlock.
%patch1318 -p1
# Remove ip_conntrack proc files on module removal.
%patch1319 -p1
# bonding with arp_ip_target failover sometime does not work
%patch1320 -p1
# Fix call to ipv6_skip_exthdr with an incorrect length argument.
%patch1321 -p1
# enable sctp to honour IP_FREEBIND option/ip_nonlocal_bind sysctl
%patch1322 -p1
# update bonding docs
%patch1323 -p1
# esure qeth driver gets proper eui64 values
%patch1324 -p1
#make sure ipv6 doesn't leak routes
%patch1325 -p1
# fix netlink hangs
%patch1326 -p1
# make sctp honor SO_BINDTODEVICE
%patch1327 -p1
# make net.ipv[4,6].route.flush file write only
%patch1328 -p1
# prevent list corruption in ip_vs_conn_flush
%patch1329 -p1
# fix tcp assertions
%patch1330 -p1
# network updates from 2.6.12
%patch1331 -p1
# bonding fixes
%patch1332 -p1
# make sctp properly call shutdown
%patch1333 -p1
#fix sctp receive buffer accounting
%patch1334 -p1
# various sctp fixes
%patch1335 -p1

# NIC driver fixes.
# Fix problems with b44 & 4g/4g
%patch1350 -p1
# Use correct spinlock functions in token ring net code
%patch1351 -p1
# make tulip_stop_rxtx() wait for DMA to fully stop
%patch1352 -p1
# reload EEPROM values at rmmod for needy cards
%patch1353 -p1
# [TG3]: Fix fiber hw autoneg bounces
%patch1354 -p1
# e100: fix improper enabling of interrupts
%patch1355 -p1
# rx checksum support for gige nForce ethernet
%patch1356 -p1
# via-rhine: references __init code during resume
%patch1357 -p1
# Workaround for the E1000 erratum 23
%patch1358 -p1
# Workaround E1000 post-maturely writing back to TX descriptors
%patch1359 -p1
# e100/e1000: return -EINVAL when setting rx-mini or rx-jumbo
%patch1360 -p1
# E1000 64k-alignment fix
%patch1361 -p1
# s2io update
%patch1362 -p1
# E1000 update from 2.6.10
%patch1364 -p1
# e100 update to 3.3.6-k2
%patch1365 -p1
# avoid panic in e100_tx_timeout on ppc64
%patch1366 -p1
# sk98lin: add MODULE_DEVICE_TABLE entry
%patch1367 -p1
# tg3: update + support BCM5752
%patch1368 -p1
# E100: fix state machine handling w/ NAPI
%patch1369 -p1
# ICH7 IDs for E100
%patch1370 -p1
# e1000: avoid sleep in timer context
%patch1371 -p1
# e1000: flush workqueues on remove
%patch1372 -p1
# Some nVidia network controllers show up as bridges.
%patch1373 -p1
# update ixgb to upstream 2.6.11
%patch1374 -p1
# E1000 update to upstream 2.6.11
%patch1375 -p1
# b44: fix bounce buffer allocation
%patch1376 -p1
# 3c59x: backport from 2.6.12-rc2 (enhanced ethtool support)
%patch1377 -p1
# tg3: update to 3.27 (support xw4300)
%patch1378 -p1
# e100: update to version 3.4.8
%patch1379 -p1
# fix driver name in dl2k as returned by ETHTOOL_GDRVINFO
%patch1380 -p1
# make sure b44 driver displays proper state on open
%patch1381 -p1
# update typhoon drvier
%patch1382 -p1
# update pcnet32
%patch1383 -p1
# update forcedeth
%patch1384 -p1
# tg3 update
%patch1385 -p1
# add bnx2
%patch1386 -p1
# update mii
%patch1387 -p1
# add sky2 driver
%patch1388 -p1
# add skge net driver
%patch1389 -p1

# ACPI bits
# Eliminate spurious ACPI breakpoint msgs
%patch1400 -p1
# Make LEqual less strict about operand types matching.
%patch1401 -p1
# Fix ACPI debug level
%patch1402 -p1
# Implement ACPI reset mechanism.
%patch1403 -p1
# Fix panic in acpi_pci_root_add()
%patch1404 -p1
# Support ACPI 2.0 systems with no XSDT
%patch1405 -p1

#kprobes
%patch1450 -p1
%patch1451 -p1
%patch1452 -p1
%patch1453 -p1
#relayfs
%patch1454 -p1
#ia64 kprobes support
%patch1455 -p1
%patch1456 -p1
%patch1457 -p1
#kprobes scalability
%patch1458 -p1

# storage driver updates
%patch1470 -p1
%patch1471 -p1
%patch1472 -p1
%patch1473 -p1
%patch1474 -p1
%patch1475 -p1
%patch1476 -p1
%patch1477 -p1

#
# Various crash dumping patches
#
%patch1500 -p1
%patch1501 -p1
%patch1510 -p1
%patch1520 -p1
%patch1521 -p1

%patch1530 -p1
%patch1540 -p1
%patch1541 -p1
%patch1542 -p1
%patch1543 -p1
%patch1544 -p1
%patch1545 -p1
%patch1546 -p1
%patch1547 -p1
%patch1548 -p1
%patch1549 -p1
%patch1550 -p1
%patch1551 -p1
%patch1552 -p1
%patch1554 -p1
%patch1555 -p1
%patch1556 -p1
%patch1557 -p1
%patch1558 -p1
%patch1559 -p1
%patch1560 -p1
%patch1561 -p1
%patch1562 -p1
%patch1563 -p1
%patch1564 -p1
%patch1565 -p1
%patch1566 -p1
%patch1567 -p1
%patch1568 -p1
%patch1569 -p1
%patch1570 -p1

#
# Various SELinux fixes from 2.6.10rc
#
%patch1600 -p1
%patch1601 -p1
%patch1602 -p1
%patch1603 -p1
%patch1604 -p1
%patch1605 -p1
# SELinux xattr for tmpfs (from 2.6.9-mm)
%patch1606 -p1
%patch1608 -p1
%patch1609 -p1
%patch1610 -p1
%patch1611 -p1
%patch1612 -p1
%patch1613 -p1
%patch1614 -p1
%patch1615 -p1
%patch1616 -p1
%patch1617 -p1
%patch1618 -p1
%patch1619 -p1

# Misc fixes
# Fix ps showing wrong ppid. (#132030)
%patch1700 -p1
# Make proc_pid_status not dereference dead task structs.
%patch1701 -p1
# Add ability to clear setting in /proc/self/attr
%patch1702 -p1
# Make EDD runtime configurable.
%patch1710 -p1
# Backport sysfs changes from 2.6.10 (#140372)
%patch1720 -p1
# Optimize away the unconditional write to debug registers on signal delivery path
%patch1730 -p1
# Add barriers to generic timer code to prevent race
%patch1740 -p1
# Fix problems with non-power-of-two sector size discs
%patch1750 -p1
# Add missing MODULE_VERSION tags to some modules.
%patch1760 -p1
# disable sw irqbalance/irqaffinity for e7520-e7320-e7525
%patch1780 -p1
# ASPM workaround for PCIe
%patch1781 -p1
# Hot-plug driver updates due to MSI change
%patch1782 -p1
# Workaround for 80332 IOP hot-plug problem
%patch1783 -p1
# ExpressCard hot-plug support for ICH6M
%patch1784 -p1
# Various PCI-X hotplug fixes
%patch1785 -p1
# hugetlb_get_unmapped_area fix
%patch1790 -p1
# Various statm accounting fixes
%patch1800 -p1
# Suppress ide-floppy 'medium not present' noise
%patch1810 -p1
# Fix possible hang in do_wait()
%patch1820 -p1
# flush error in pci_mmcfg_write
%patch1830 -p1
# Fix boot crash on VIA systems
%patch1840 -p1
# autofs4 - allow map update recognition
%patch1850 -p1
# Add additional tainting mechanisms.
%patch1860 -p1
%patch1861 -p1
%patch1862 -p1
# xtime correctness.
%patch1870 -p1
# pagevec alignment
%patch1880 -p1
# ia64/x86_64/s390 overlapping vma fix
%patch1890 -p1
# Remove Futex Warning
%patch1900 -p1
# Futex mmap_sem deadlock
%patch1901 -p1
# Make spinlock debugging panic instead of continue.
%patch1910 -p1
# Fix compat fcntl F_GETLK{,64}
%patch1920 -p1
# fix uninitialized variable in waitid(2)
%patch1930 -p1
# Missing Cache flushes in AGPGART code.
%patch1950 -p1
# Workaround broken pci posting in AGPGART.
%patch1951 -p1
# Bounds checking for vc resize
%patch1960 -p1
# fix & clean up zombie/dead task handling & preemption
%patch1970 -p1
# Don't cache /proc/pid dentry for dead process
%patch1971 -p1
# Random poolsize sysctl handler integer overflow.
%patch1990 -p1
#make sure i8042 properly release resources
%patch1991 -p1
#allow rom flashes on intel motherboads 
%patch1992 -p1
# NR_KEYS
%patch1993 -p1
# Active pci support
%patch1994 -p1
# fix master abort in pci_scan_device
%patch1995 -p1
# fix pci bar size
%patch1996 -p1
# schedule updates
%patch1997 -p1

#
# VM related fixes.
#
# Make the OOM killer less aggressive.
%patch2000 -p1
# vm_dirty_ratio initialisation fix.
%patch2001 -p1
# VM pageout throttling.
%patch2002 -p1
# Lower dirty limit for mappings which can't be cached in highmem
%patch2003 -p1
# Don't oomkill when congested
%patch2004 -p1
# Increment total_scanned var to throttle kswapd
%patch2005 -p1
# RLIMIT_MEMLOCK bypass and unpriveledged user DoS.
%patch2007 -p1
# tweak for the oomkiller.
%patch2009 -p1
# Print some extra debugging info on oom_kill.
%patch2010 -p1
# fix invalidate page race
%patch2011 -p1
# Fix the mincore syscall's error handling
%patch2012 -p1
# Fix DMA zone exhaustion problem
%patch2013 -p1
# Improve try_to_free_pages scanning
%patch2014 -p1
# swap token NULL mm check
%patch2015 -p1
# Prevent incrementing pte off end of kmap'd virtual page
%patch2016 -p1
# bounce page accounting
%patch2018 -p1
# ensure topdown allocator doesn't map page at 0
%patch2019 -p1
# mm tracker
%patch2020 -p1
# fix prune_icache vs iput race
%patch2021 -p1
# ability to disable oom kills via /proc/sys/oom-kill
%patch2022 -p1
# cache coherency fixes for ia64
%patch2023 -p1
# patch for buffer.c oops
%patch2024 -p1
# prio-tree fixes
%patch2025 -p1
# readahead fixes
%patch2026 -p1
# fix vm committed sign error
%patch2027 -p1
# allow vmalloc to allocate larger regions
%patch2028 -p1
# get watermarks correct on numa; allow fine grained dirty ratio setting
%patch2029 -p1
# properly update hugetlb number of pages
%patch2030 -p1
# optimize pte copying in fork()
%patch2031 -p1
# fix do_swap_page vs. shrink_list race
%patch2032 -p1
# make bootmem_low work 
%patch2033 -p1
# fix busy inodes after unmount
%patch2034 -p1

# IDE bits.
# Make CSB6 driver support configurations.
%patch2100 -p1
# Handle early EOF on CD's.
%patch2101 -p1
# Prevent panic with CD error
%patch2102 -p1
# Suppress Error Message on IDE probe
%patch2103 -p1
# Update IDE blacklist.
%patch2104 -p1
# convert __init to __devinit in serverworks for hotplug
%patch2105 -p1
# Do not load IDE driver on ServerWorks CSB6 chipsets
%patch2106 -p1
# IDE updates pci ids
%patch2107 -p1

# USB bits
# IO edgeport overflows.
%patch2200 -p1
# Allow usb-storage to be reloaded
%patch2201 -p1
# Add NOGET quirk for Chicony keyboards.
%patch2202 -p1
# fix usb acm modem interactions with line discipline
%patch2203 -p1
# fix usb memory sticks
%patch2204 -p1
# fix usb keys
%patch2205 -p1
# usb handoff
%patch2206 -p1
# khubd deadlock fixes
%patch2207 -p1
# fix endless loops in HID on disconnect
%patch2208 -p1
# properly implement usb compat ioctls
%patch2209 -p1
# Workaround for EHCI on some nVidia silicon
%patch2210 -p1
# get correct cd size
%patch2211 -p1
# usb error handling
%patch2212 -p1
# pizzaro reboot fix
%patch2213 -p1

# SCSI bits.
# Drop the 'deprecated SG_IO warning'.
%patch2300 -p1
# fix incorrect hw segment counting in qla2x00 drivers
%patch2301 -p1
# aacraid: remove unused module parameter "commit"
%patch2302 -p1
# Update megaraid.
%patch2303 -p1
# Megaraid diskdump warnings.
%patch2304 -p1
# Update mpt fusion driver, include SAS support.
%patch2305 -p1
# Increase i2o_block timeout, fixing installs with Adaptec 2400A
%patch2306 -p1
# SCSI Fix oops with faulty DVD
%patch2307 -p1
# Blacklist devices that falsely claim an echo buffer
%patch2308 -p1
# call __scsi_done in SDEV_DEL state
%patch2309 -p1
# add iscsi-sfnet driver - iscsi support
%patch2310 -p1
# qla1280: remove __inidata from driver_setup for hotplug
%patch2311 -p1
# update ipr driver to 2.0.11.1
%patch2312 -p1
# ide-scsi transform
%patch2313 -p1
# fix mt tell
%patch2314 -p1
# sg_io handling
%patch2315 -p1
# fix sg oops
%patch2316 -p1
# properly handle highmem in ide-scsi
%patch2317 -p1
# megaraid update
%patch2318 -p1
# fix cdrom sizing
%patch2319 -p1
# add megaraid_sas driver
%patch2320 -p1
# aacraid update
%patch2321 -p1
# add serial attached scsi, aic94xx
%patch2322 -p1
# fix scsi delete timer race
%patch2323 -p1
# fix scsi_eh_tur retry logic
%patch2324 -p1
# fix /proc/scsi/scsi overflows
%patch2325 -p1
# update qla2xxx to version 8.01.04-d7
%patch2326 -p1
# support 16-byte cdbs
%patch2327 -p1
# add adp94xx driver
%patch2328 -p1
# 3ware updates
%patch2329 -p1

# Audit layer
%patch2400 -p1
%patch2401 -p1
%patch2402 -p1
%patch2403 -p1
%patch2404 -p1
%patch2405 -p1
%patch2406 -p1
%patch2407 -p1
%patch2408 -p1
%patch2409 -p1
%patch2410 -p1
%patch2411 -p1
%patch2412 -p1
%patch2413 -p1
%patch2414 -p1
%patch2415 -p1
%patch2416 -p1
%patch2417 -p1
%patch2418 -p1
%patch2419 -p1
%patch2420 -p1
%patch2421 -p1
%patch2422 -p1
%patch2423 -p1
%patch2424 -p1
%patch2425 -p1
%patch2426 -p1
%patch2427 -p1
%patch2428 -p1
%patch2429 -p1
%patch2430 -p1
%patch2431 -p1
%patch2432 -p1
%patch2433 -p1
%patch2434 -p1
%patch2435 -p1
%patch2436 -p1
%patch2437 -p1
%patch2438 -p1
%patch2439 -p1
%patch2440 -p1
%patch2441 -p1
%patch2442 -p1
%patch2443 -p1
%patch2444 -p1
%patch2445 -p1
%patch2446 -p1
%patch2447 -p1
%patch2448 -p1
%patch2449 -p1
%patch2450 -p1
%patch2451 -p1
%patch2452 -p1
%patch2453 -p1
%patch2454 -p1
%patch2455 -p1
%patch2456 -p1
%patch2457 -p1
%patch2458 -p1

# Key management patches
%patch2500 -p1
%patch2501 -p1
%patch2502 -p1
%patch2503 -p1
%patch2504 -p1
%patch2505 -p1

# Core FS patches
# free_secdata on mount
%patch2550 -p1
# properly osync block devices
%patch2551 -p1
# add blkgetsize compat ioctl
%patch2552 -p1
# fix direct IO vs truncate for out of tree filesystems
%patch2553 -p1
# fix olarge file semantics for 32-bit apps on ia64
%patch2554 -p1
# fix error reporting on o_sync
%patch2555 -p1
# fix aio hang
%patch2556 -p1
# auditfs
%patch2557 -p1
# auditfs fixes
%patch2558 -p1
# audit_panic when out of memory
%patch2559 -p1
# avoid unnecessary audit records
%patch2560 -p1
# break up o_direct iovecs that are too large
%patch2561 -p1
# remove partition check in register_disk
%patch2562 -p1
# ioscheduler updates
%patch2563 -p1
# fix readpage vs. truncate race
%patch2565 -p1
# dont' create a new file on -ENFILE
%patch2566 -p1
# GFS dio locking
%patch2567 -p1
# make poll timeout correct large values on  64-bit platforms
%patch2568 -p1
# make readv/writev go through lsm
%patch2569 -p1

# Device Mapper fixes
%patch2600 -p1
%patch2601 -p1
%patch2602 -p1
%patch2603 -p1
%patch2604 -p1
%patch2605 -p1
%patch2606 -p1
%patch2607 -p1
%patch2608 -p1
%patch2609 -p1
%patch2610 -p1
%patch2611 -p1
%patch2612 -p1
%patch2613 -p1

# OpenIB Infiniband support
%patch2700 -p1
%patch2701 -p1
%patch2702 -p1
%patch2703 -p1
%patch2704 -p1
%patch2705 -p1
%patch2706 -p1
%patch2707 -p1
%patch2708 -p1
%patch2709 -p1
%patch2710 -p1
%patch2711 -p1
%patch2712 -p1
%patch2713 -p1
%patch2714 -p1
%patch2715 -p1
%patch2716 -p1
%patch2717 -p1
%patch2718 -p1
%patch2719 -p1
%patch2720 -p1
%patch2721 -p1
%patch2722 -p1
%patch2723 -p1
%patch2724 -p1
%patch2725 -p1
%patch2726 -p1
%patch2727 -p1
%patch2728 -p1
%patch2729 -p1
%patch2730 -p1
%patch2731 -p1
%patch2732 -p1
%patch2733 -p1
%patch2734 -p1
%patch2735 -p1
%patch2736 -p1
%patch2737 -p1
%patch2738 -p1
%patch2739 -p1
%patch2740 -p1
%patch2741 -p1
%patch2742 -p1
%patch2743 -p1
%patch2744 -p1
%patch2745 -p1
%patch2746 -p1
%patch2747 -p1
%patch2748 -p1
%patch2749 -p1

# Intial EDAC support
%patch2800 -p1

#
# Local hack (off for any shipped kernels) to printk all files opened 
# the first 180 seconds after boot for debugging userspace startup 
# speeds
#
# %patch2999 -p1

#
# External drivers that are about to get accepted upstream
#

# Emulex FC
%patch3000 -p1
%patch3001 -p1
%patch3002 -p1
%patch3003 -p1
%patch3004 -p1
%patch3005 -p1
%patch3006 -p1
%patch3007 -p1
%patch3008 -p1
%patch3009 -p1

# Speedtouch
%patch3010 -p1

# Intel wireless
%patch3020 -p1
%patch3021 -p1
%patch3022 -p1
%patch3023 -p1
%patch3024 -p1
%patch3025 -p1

# Misc bits
# Various fixes from 2.6.10-ac
%patch4001 -p1
# Fix pty race condition on SMP machine
%patch4002 -p1
# AC97 ID additions.
%patch4003 -p1
# Fix Alt-Sysrq-B panics x86/x86_64
%patch4004 -p1
# Fix oops when io_setup is called with unwritable addr
%patch4005 -p1
# Various ptrace fixes.
%patch4006 -p1
# set panic_on_oops=1 by default
%patch4007 -p1
# Fix shmget for ppc64, s390-64 & sparc64.
%patch4008 -p1
# gpt partition noprobe
%patch4009 -p1
# tmpfs caused truncate BUG()
%patch4010 -p1
# Silence some cpufreq warnings.
%patch4011 -p1
# Fix Vesafb probe error.
%patch4012 -p1
# Add support for a brace of Dell PCI serial cards
%patch4013 -p1
# Fix leak in autofs
%patch4014 -p1
# Fix tty locking.
%patch4015 -p1
# cope with faults in iret
%patch4016 -p1
# sysrq key enhancements
%patch4017 -p1
# Fix accounting in do_task_stat()
%patch4018 -p1
# adjust baud rate for serial ns16550a
%patch4019 -p1
# quirks patch
%patch4020 -p1
# fix oops with symbolic links on tmpfs
%patch4021 -p1
# esb2 support
%patch4022 -p1
# sigkill
%patch4023 -p1
# bio clone copy idx
%patch4024 -p1
# acpi fix for powernow
%patch4025 -p1
# update hangcheck timer
%patch4026 -p1
# aio fixes
%patch4027 -p1
# fix kallsyms race against insmod
%patch4028 -p1
# fix locks vs. close race
%patch4029 -p1
# fix autofs possibe infinite recursion on bind mounts
%patch4030 -p1
# isdn fixes
%patch4031 -p1
# fix release_region order in i810
%patch4032 -p1
# fix get/set_priority semantics
%patch4033 -p1
# fix disassociate ctty semantics
%patch4034 -p1
# remove bogus BUG_ON calls while dumping core
%patch4035 -p1
# fix mqueue refcounting
%patch4036 -p1
# Wacom driver update
%patch4037 -p1
# add firmware update driver
%patch4038 -p1
# updates to kernel documentation
%patch4039 -p1
# fix boot BUG call when blank_console_t is called before keventd is up
%patch4040 -p1
# default softreapeat to off for atkbd.c
%patch4041 -p1
# sound driver updates
%patch4042 -p1
# procfs removal races fix
%patch4043 -p1
# add Dell dcbas driver
%patch4044 -p1
# fix hanging serial console
%patch4045 -p1
# pci bist
%patch4046 -p1
# /proc/devices overflow protection
%patch4047 -p1
# tunable per cpu pages
%patch4048 -p1
# tunable wake balance
%patch4049 -p1
# updated /proc/meminfo
%patch4050 -p1
# add i2 drivers
%patch4051 -p1
# audit execve 
%patch4052 -p1
# rsa driver fixes
%patch4053 -p1
# recognize boot cpu apic id properly
%patch4054 -p1

# ALSA fixes
# New ID for vx222 driver.
%patch4100 -p1
# Intel HD audio driver.
%patch4101 -p1
# improve support for alc260 codec
%patch4102 -p1
# intel hd audio driver update, remove empty files
%patch4103 -p1 -E

# Security issues.
%patch5000 -p1
%patch5001 -p1
%patch5002 -p1
%patch5003 -p1
%patch5004 -p1
%patch5005 -p1
%patch5006 -p1
%patch5007 -p1
%patch5009 -p1
%patch5010 -p1
%patch5011 -p1
%patch5012 -p1
%patch5013 -p1
%patch5014 -p1
%patch5015 -p1
%patch5016 -p1
%patch5017 -p1
%patch5018 -p1
%patch5019 -p1
%patch5020 -p1
%patch5021 -p1
%patch5022 -p1
%patch5023 -p1
%patch5024 -p1
%patch5025 -p1
%patch5026 -p1
%patch5027 -p1
%patch5028 -p1
%patch5029 -p1
%patch5030 -p1
%patch5031 -p1
%patch5032 -p1
%patch5033 -p1
%patch5034 -p1
%patch5035 -p1
%patch5036 -p1
%patch5037 -p1
%patch5038 -p1
%patch5039 -p1
%patch5040 -p1
%patch5041 -p1
%patch5042 -p1
%patch5043 -p1
%patch5044 -p1
%patch5045 -p1
%patch5046 -p1
%patch5047 -p1
%patch5048 -p1
%patch5049 -p1
%patch5050 -p1
%patch5051 -p1
%patch5052 -p1
%patch5053 -p1
%patch5054 -p1
%patch5055 -p1
%patch5056 -p1
%patch5057 -p1
%patch5058 -p1
%patch5059 -p1
%patch5060 -p1
%patch5061 -p1
%patch5062 -p1
%patch5063 -p1
%patch5064 -p1

# Security fixes without CAN-CVE's yet.
%patch5100 -p1

#
# final stuff
#

# xxx: EFW2
%patch8005 -p1
%patch8006 -p1

#
# misc small stuff to make things compile or otherwise improve performance
#
%patch10000 -p1

# Remove a bunch of exports that went away in 2.6.10rc1
%patch10001 -p1

# Add kzalloc and kstrdup, removes duplicate kstrdup definitions in various
# code as well
%patch10002 -p1
# patch for pci ids
%patch10003 -p1

# xxx: EFW2
%if %{buildprepom}
cp -R %{KERNEL_PATH} ${RPM_BUILD_DIR}/%{name}-%{version}/linux-prepom-%{kversion}
%endif

%setup -q -n %{name}-%{version} -c -a 2 -T -D
%setup -q -n %{name}-%{version} -c -a 3 -T -D

cd patch-o-matic-ng-%{patchomatic_version}
sed -i -e 's/head\ -1/head\ -n\ 1/' runme

pushd patchlets

# mainline
rm -rf CLUSTERIP

# base
rm -rf connlimit
rm -rf set
rm -rf NETLINK
rm -rf nth
rm -rf random
rm -rf NETMAP
rm -rf iprange
rm -rf HOPLIMIT
rm -rf fuzzy
rm -rf TTL
rm -rf u32
rm -rf IPV4OPTSSTRIP

# extra
rm -rf ACCOUNT
rm -rf IPMARK
rm -rf ROUTE
rm -rf TARPIT
rm -rf TCPLAG
rm -rf TRACE
rm -rf ULOG
rm -rf XOR
rm -rf condition
rm -rf connbytes
rm -rf connrate
rm -rf conntrack-event-api
rm -rf conntrack_locking
rm -rf conntrack_nonat
rm -rf ctnetlink
rm -rf goto
rm -rf ip_queue_vwmark
rm -rf ipsec-01-output-hooks
rm -rf ipsec-02-input-hooks
rm -rf ipsec-03-policy-lookup
rm -rf ipsec-04-policy-checks
rm -rf nat-reservations
rm -rf nf_conntrack
rm -rf nfnetlink
rm -rf nfnetlink_queue
rm -rf owner-socketlookup
rm -rf owner-supgids
rm -rf policy
rm -rf rpc
rm -rf rsh
rm -rf string
rm -rf tproxy
rm -rf unclean
rm -rf h323-conntrack-nat

popd

%patch100000 -p1 -b .pptpworkaround

cp %{SOURCE100} patchlets/CONNMARK/linux.patch

# patches of the base repository or do apply well or are already applied
./runme --batch --kernel-path=%{KERNEL_PATH} --iptables-path=%{IPTABLES_PATH} extra

cd %{KERNEL_PATH}

#%patch8003 -p1

%patch99999 -p1

# make sure the kernel has the sublevel we know it has. This looks weird
# but for -pre and -rc versions we need it since we only want to use
# the higher version when the final kernel is released.
perl -p -i -e "s/^SUBLEVEL.*/SUBLEVEL = %{sublevel}/" Makefile
perl -p -i -e "s/^EXTRAVERSION.*/EXTRAVERSION = -prep/" Makefile

# conditionally applied test patch for debugging convenience
%if %([ -s %{PATCH20000} ] && echo 1 || echo 0)
%patch20000 -p1
%endif

# END OF PATCH APPLICATIONS

cp %{SOURCE10} Documentation/

mkdir configs

cp -fv %{all_arch_configs} .


# now run oldconfig over all the config files
for i in *xen*.config 
do 
	mv $i .config
	# This is needed so that nonint_oldconfig passes on the Xen kernel
	echo CONFIG_SMP_ALTERNATIVES=y >> .config
	make ARCH=`echo $i | cut -d"-" -f3 | cut -d"." -f1 | sed -e s/i.86/i386/ -e s/s390x/s390/ -e s/ppc64.series/ppc64/  ` oldconfig 
	cp .config configs/$i 
done

# get rid of unwanted files resulting from patch fuzz
find . -name "*.orig" -exec rm -fv {} \;
find . -name "*~" -exec rm -fv {} \;


###
### build
###
%build

#
# Create gpg keys for signing the modules
#

%if %{signmodules}
gpg --homedir . --batch --gen-key %{SOURCE11} 
gpg --homedir . --export --keyring ./kernel.pub Red > extract.pub
make linux-%{kversion}/scripts/bin2c
linux-%{kversion}/scripts/bin2c ksign_def_public_key __initdata < extract.pub > linux-%{kversion}/crypto/signature/key.h
%endif

cd linux-%{kversion}



BuildKernel() {

    # Pick the right config file for the kernel we're building
    if [ -n "$1" ] ; then
	Config=kernel-%{kversion}-%{_target_cpu}-$1.config
	DevelDir=/usr/src/kernels/%{KVERREL}-$1-%{_target_cpu}
    else
	Config=kernel-%{kversion}-%{_target_cpu}.config
	DevelDir=/usr/src/kernels/%{KVERREL}-%{_target_cpu}
    fi

    KernelVer=%{version}-%{release}$1
    echo BUILDING A KERNEL FOR $1 %{_target_cpu}...

    # make sure EXTRAVERSION says what we want it to say
    perl -p -i -e "s/^EXTRAVERSION.*/EXTRAVERSION = -%{release}$1/" Makefile

    # and now to start the build process

    make -s mrproper
    cp configs/$Config .config

    make -s nonint_oldconfig > /dev/null
    make -s include/linux/version.h 

    make -s %{?_smp_mflags} %{make_target}
    make -s %{?_smp_mflags} modules || exit 1
    # Incompatible with smp alternatives patch.
    # make buildcheck
    
    # Start installing the results

    mkdir -p $RPM_BUILD_ROOT/usr/lib/debug/boot
    mkdir -p $RPM_BUILD_ROOT/%{image_install_path}
    install -m 644 .config $RPM_BUILD_ROOT/boot/config-$KernelVer
    install -m 644 System.map $RPM_BUILD_ROOT/boot/System.map-$KernelVer
    cp vmlinuz $RPM_BUILD_ROOT/%{image_install_path}/vmlinuz-$KernelVer

    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer
    make -s INSTALL_MOD_PATH=$RPM_BUILD_ROOT modules_install KERNELRELEASE=$KernelVer
%if %{kabi}
    mkdir -p $RPM_BUILD_ROOT/lib/modules/kabi-%{kabi_major}-%{kabi_minor}$1
%endif
 
    # And save the headers/makefiles etc for building modules against
    #
    # This all looks scary, but the end result is supposed to be:
    # * all arch relevant include/ files
    # * all Makefile/Kconfig files
    # * all script/ files 

    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/source
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    (cd $RPM_BUILD_ROOT/lib/modules/$KernelVer ; ln -s build source)
    # first copy everything
    cp --parents `find  -type f -name Makefile -o -name "Kconfig*"` $RPM_BUILD_ROOT/lib/modules/$KernelVer/build 
    cp Module.symvers $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    # then drop all but the needed Makefiles/Kconfig files
    rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/Documentation
    rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts
    rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
    cp arch/%{_arch}/kernel/asm-offsets.s $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/arch/%{_arch}/kernel || :
    cp .config $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    cp -a scripts $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    cp -a arch/%{_arch}/scripts $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/arch/%{_arch} || :
    cp -a arch/%{_arch}/*lds $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/arch/%{_arch}/ || :
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts/*.o
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts/*/*.o
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
    cd include
    cp -a acpi config linux math-emu media net pcmcia rxrpc scsi sound video asm asm-generic $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
    cp -a `readlink asm` $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
%ifarch x86_64
    mkdir $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/asm-i386
    cp -a asm-i386/ide.h asm-i386/node.h asm-i386/cpu.h $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/asm-i386
%endif
    # Make sure the Makefile and version.h have a matching timestamp so that
    # external modules can be built
    touch -r $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/Makefile $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/linux/version.h
    touch -r $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/.config $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/linux/autoconf.h
    cd .. 

    #
    # save the vmlinux file for kernel debugging into the kernel-debuginfo rpm
    #
    mkdir -p $RPM_BUILD_ROOT/usr/lib/debug/lib/modules/$KernelVer
    cp vmlinux $RPM_BUILD_ROOT/usr/lib/debug/lib/modules/$KernelVer

    # gpg sign the modules
%if %{signmodules}
    gcc -o scripts/modsign/mod-extract scripts/modsign/mod-extract.c -Wall
	KEYFLAGS="--no-default-keyring --homedir .." 
	KEYFLAGS="$KEYFLAGS --secret-keyring ../kernel.sec" 
	KEYFLAGS="$KEYFLAGS --keyring ../kernel.pub" 
	export KEYFLAGS 
    for i in ` find $RPM_BUILD_ROOT/lib/modules/$KernelVer -name "*.ko" -type f` ; do
	if [ x`echo \`basename $i \` | join - $RPM_SOURCE_DIR/modsign_exclude | wc -l` = x0 ]
	then
		sh ./scripts/modsign/modsign.sh $i Red
		mv -f $i.signed $i
	fi
    done
	unset KEYFLAGS
%endif

    # mark modules executable so that strip-to-file can strip them
    find $RPM_BUILD_ROOT/lib/modules/$KernelVer -name "*.ko" -type f  | xargs chmod u+x

    # detect missing or incorrect license tags
    for i in `find $RPM_BUILD_ROOT/lib/modules/$KernelVer -name "*.ko" ` ; do echo -n "$i " ; /sbin/modinfo -l $i >> modinfo ; done
    cat modinfo | grep -v "^GPL" | grep -v "^Dual BSD/GPL" | grep -v "^Dual MPL/GPL" | grep -v "^GPL and additional rights" | grep -v "^GPL v2" && exit 1 
    rm -f modinfo
    # remove files that will be auto generated by depmod at rpm -i time
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/modules.*

    # Move the devel headers out of the root file system
    mkdir -p $RPM_BUILD_ROOT/usr/src/kernels
    mv $RPM_BUILD_ROOT/lib/modules/$KernelVer/build $RPM_BUILD_ROOT/$DevelDir
    ln -sf $DevelDir $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
}

###
# DO it...
###

# prepare directories
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/boot

%if %{buildup}
BuildKernel
%endif

%if %{buildsmp}
BuildKernel smp
%endif

%if %{buildhugemem}
BuildKernel hugemem
%endif

%if %{buildlargesmp}
BuildKernel largesmp
%endif

%if %{buildxenU}
BuildKernel xenU
%endif

%if %{buildxenUpae}
BuildKernel xenUpae
%endif

###
### install
###

%install

cd linux-%{kversion}

# architectures that don't get kernel-source (i586/i686/athlon) dont need
# much of an install because the build phase already copied the needed files

%if %{builddoc}
mkdir -p $RPM_BUILD_ROOT/usr/share/doc/kernel-doc-%{kversion}/Documentation

# sometimes non-world-readable files sneak into the kernel source tree
chmod -R a+r *
# copy the source over
tar cf - Documentation | tar xf - -C $RPM_BUILD_ROOT/usr/share/doc/kernel-doc-%{kversion}
%endif

%if %{buildsource}

mkdir -p $RPM_BUILD_ROOT/usr/src/linux-%{KVERREL}
chmod -R a+r *

# clean up the source tree so that it is ready for users to build their own
# kernel
make -s mrproper
# copy the source over
tar cf - . | tar xf - -C $RPM_BUILD_ROOT/usr/src/linux-%{KVERREL}

# set the EXTRAVERSION to <version>custom, so that people who follow a kernel building howto
# don't accidentally overwrite their currently working moduleset and hose
# their system
perl -p -i -e "s/^EXTRAVERSION.*/EXTRAVERSION = -%{release}custom/" $RPM_BUILD_ROOT/usr/src/linux-%{KVERREL}/Makefile

# some config options may be appropriate for an rpm kernel build but are less so for custom user builds,
# change those to values that are more appropriate as default for people who build their own kernel.
perl -p -i -e "s/^CONFIG_DEBUG_INFO.*/# CONFIG_DEBUG_INFO is not set/" $RPM_BUILD_ROOT/usr/src/linux-%{KVERREL}/configs/*
perl -p -i -e "s/^.*CONFIG_DEBUG_PAGEALLOC.*/# CONFIG_DEBUG_PAGEALLOC is not set/" $RPM_BUILD_ROOT/usr/src/linux-%{KVERREL}/configs/*
perl -p -i -e "s/^.*CONFIG_DEBUG_SLAB.*/# CONFIG_DEBUG_SLAB is not set/" $RPM_BUILD_ROOT/usr/src/linux-%{KVERREL}/configs/*
perl -p -i -e "s/^.*CONFIG_DEBUG_SPINLOCK.*/# CONFIG_DEBUG_SPINLOCK is not set/" $RPM_BUILD_ROOT/usr/src/linux-%{KVERREL}/configs/*
perl -p -i -e "s/^.*CONFIG_DEBUG_HIGHMEM.*/# CONFIG_DEBUG_HIGHMEM is not set/" $RPM_BUILD_ROOT/usr/src/linux-%{KVERREL}/configs/*
perl -p -i -e "s/^.*CONFIG_MODULE_SIG.*/# CONFIG_MODULE_SIG is not set/" $RPM_BUILD_ROOT/usr/src/linux-%{KVERREL}/configs/*

install -m 644 %{SOURCE10}  $RPM_BUILD_ROOT/usr/src/linux-%{KVERREL}
%endif

###
### clean
###

%clean
rm -rf $RPM_BUILD_ROOT

###
### scripts
###

# load the loop module for upgrades...in case the old modules get removed we have
# loopback in the kernel so that mkinitrd will work.
%pre 
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
exit 0

%pre smp
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
exit 0

%pre hugemem
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
exit 0

%pre largesmp
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
exit 0

%post 
[ -x /usr/sbin/module_upgrade ] && /usr/sbin/module_upgrade
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --package kernel --mkinitrd --depmod --install %{KVERREL}

%post devel
if [ -x /usr/sbin/hardlink ] ; then
pushd /usr/src/kernels/%{KVERREL}-%{_target_cpu} > /dev/null ; {
	cd /usr/src/kernels/%{KVERREL}-%{_target_cpu}
	find . -type f | while read f; do hardlink -c /usr/src/kernels/*/$f $f ; done
}
popd > /dev/null
fi

%post smp
[ -x /usr/sbin/module_upgrade ] && /usr/sbin/module_upgrade
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --package kernel-smp --mkinitrd --depmod --install %{KVERREL}smp

%post smp-devel
if [ -x /usr/sbin/hardlink ] ; then
pushd /usr/src/kernels/%{KVERREL}-smp-%{_target_cpu} > /dev/null ; {
	cd /usr/src/kernels/%{KVERREL}-smp-%{_target_cpu}
	find . -type f | while read f; do hardlink -c /usr/src/kernels/*/$f $f ; done
}
popd > /dev/null
fi

%post hugemem
[ -x /usr/sbin/module_upgrade ] && /usr/sbin/module_upgrade
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --package kernel-hugemem --mkinitrd --depmod --install %{KVERREL}hugemem

%post hugemem-devel
if [ -x /usr/sbin/hardlink ] ; then
pushd /usr/src/kernels/%{KVERREL}-hugemem-%{_target_cpu} > /dev/null ; {
	cd /usr/src/kernels/%{KVERREL}-hugemem-%{_target_cpu}
	find . -type f | while read f; do hardlink -c /usr/src/kernels/*/$f $f ; done
}
popd > /dev/null
fi

%post largesmp
[ -x /usr/sbin/module_upgrade ] && /usr/sbin/module_upgrade
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --package kernel-largesmp --mkinitrd --depmod --install %{KVERREL}largesmp

%post largesmp-devel
if [ -x /usr/sbin/hardlink ] ; then
pushd /usr/src/kernels/%{KVERREL}-largesmp-%{_target_cpu} > /dev/null ; {
	cd /usr/src/kernels/%{KVERREL}-largesmp-%{_target_cpu}
	find . -type f | while read f; do hardlink -c /usr/src/kernels/*/$f $f ; done
}
popd > /dev/null
fi

%post xenU
[ -x /usr/sbin/module_upgrade ] && /usr/sbin/module_upgrade
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --package kernel-xenU --mkinitrd --depmod --install %{KVERREL}xenU
# Symbolic links used by XenEnterprise
ln -sf vmlinuz-%{KVERREL}xenU /boot/xenkernel
[ -e /boot/initrd-%{KVERREL}xenU.img ] && ln -sf initrd-%{KVERREL}xenU.img /boot/xeninitrd

%post xenUpae
[ -x /usr/sbin/module_upgrade ] && /usr/sbin/module_upgrade
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --package kernel-xenUpae --mkinitrd --depmod --install %{KVERREL}xenUpae
# Symbolic links used by XenEnterprise
ln -sf vmlinuz-%{KVERREL}xenUpae /boot/xenUpaekernel
[ -e /boot/initrd-%{KVERREL}xenUpae.img ] && ln -sf initrd-%{KVERREL}xenUpae.img /boot/xenUpaeinitrd

%post xenU-devel
if [ -x /usr/sbin/hardlink ] ; then
pushd /usr/src/kernels/%{KVERREL}-xenU-%{_target_cpu} > /dev/null ; {
	cd /usr/src/kernels/%{KVERREL}-xenU-%{_target_cpu}
	find . -type f | while read f; do hardlink -c /usr/src/kernels/*/$f $f ; done
}
popd > /dev/null
fi

%preun 
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --rminitrd --rmmoddep --remove %{KVERREL}

%preun smp
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --rminitrd --rmmoddep --remove %{KVERREL}smp

%preun hugemem
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --rminitrd --rmmoddep --remove %{KVERREL}hugemem

%preun largesmp
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --rminitrd --rmmoddep --remove %{KVERREL}largesmp

%preun xenU
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --rminitrd --rmmoddep --remove %{KVERREL}xenU

%preun xenUpae
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --rminitrd --rmmoddep --remove %{KVERREL}xenUpae


###
### file lists
###

%if %{buildup}
%files 
%defattr(-,root,root)
/%{image_install_path}/*-%{KVERREL}
/boot/System.map-%{KVERREL}
/boot/config-%{KVERREL}
%dir /lib/modules/%{KVERREL}
/lib/modules/%{KVERREL}/kernel
%if %{kabi}
%dir /lib/modules/kabi-%{kabi_major}-%{kabi_minor}
%endif

%files devel
%defattr(-,root,root)
/lib/modules/%{KVERREL}/build
/lib/modules/%{KVERREL}/source
%verify(not mtime) /usr/src/kernels/%{KVERREL}-%{_target_cpu}
%endif

%if %{buildsmp}
%files smp
%defattr(-,root,root)
/%{image_install_path}/*-%{KVERREL}smp
/boot/System.map-%{KVERREL}smp
/boot/config-%{KVERREL}smp
%dir /lib/modules/%{KVERREL}smp
/lib/modules/%{KVERREL}smp/kernel
%if %{kabi}
%dir /lib/modules/kabi-%{kabi_major}-%{kabi_minor}smp
%endif

%files smp-devel
%defattr(-,root,root)
/lib/modules/%{KVERREL}smp/build
/lib/modules/%{KVERREL}smp/source
%verify(not mtime) /usr/src/kernels/%{KVERREL}-smp-%{_target_cpu}
%endif

%if %{buildhugemem}
%files hugemem
%defattr(-,root,root)
/%{image_install_path}/*-%{KVERREL}hugemem
/boot/System.map-%{KVERREL}hugemem
/boot/config-%{KVERREL}hugemem
%dir /lib/modules/%{KVERREL}hugemem
/lib/modules/%{KVERREL}hugemem/kernel
%if %{kabi}
%dir /lib/modules/kabi-%{kabi_major}-%{kabi_minor}hugemem
%endif

%files hugemem-devel
%defattr(-,root,root)
/lib/modules/%{KVERREL}hugemem/build
/lib/modules/%{KVERREL}hugemem/source
%verify(not mtime) /usr/src/kernels/%{KVERREL}-hugemem-%{_target_cpu}
%endif

%if %{buildlargesmp}
%files largesmp
%defattr(-,root,root)
/%{image_install_path}/*-%{KVERREL}largesmp
/boot/System.map-%{KVERREL}largesmp
/boot/config-%{KVERREL}largesmp
%dir /lib/modules/%{KVERREL}largesmp
/lib/modules/%{KVERREL}largesmp/kernel
%if %{kabi}
%dir /lib/modules/kabi-%{kabi_major}-%{kabi_minor}largesmp
%endif

%files largesmp-devel
%defattr(-,root,root)
/lib/modules/%{KVERREL}largesmp/build
/lib/modules/%{KVERREL}largesmp/source
%verify(not mtime) /usr/src/kernels/%{KVERREL}-largesmp-%{_target_cpu}
%endif

%if %{buildxenU}
%files xenU
%defattr(-,root,root)
/%{image_install_path}/*-%{KVERREL}xenU
/boot/System.map-%{KVERREL}xenU
/boot/config-%{KVERREL}xenU
%dir /lib/modules/%{KVERREL}xenU
/lib/modules/%{KVERREL}xenU/kernel
%if %{kabi}
%dir /lib/modules/kabi-%{kabi_major}-%{kabi_minor}xenU
%endif
%endif

%if %{buildxenUpae}
%files xenUpae
%defattr(-,root,root)
/%{image_install_path}/*-%{KVERREL}xenUpae
/boot/System.map-%{KVERREL}xenUpae
/boot/config-%{KVERREL}xenUpae
%dir /lib/modules/%{KVERREL}xenUpae
/lib/modules/%{KVERREL}xenUpae/kernel
%if %{kabi}
%dir /lib/modules/kabi-%{kabi_major}-%{kabi_minor}xenUpae
%endif
%endif

# only some architecture builds need kernel-source and kernel-doc

%if %{buildsource}
%files sourcecode
%defattr(-,root,root)
/usr/src/linux-%{KVERREL}/
%endif


%if %{builddoc}
%files doc
%defattr(-,root,root)
/usr/share/doc/kernel-doc-%{kversion}/Documentation/*
%endif

%changelog
* Thu Sep 21 2006 XenSource, Ltd. <xensource.com> [2.6.9-42.0.2.EL.xs148]
- Rebuild kernel patched for Xen.

* Thu Aug 17 2006 Jason Baron <jbaron@redhat.com> [2.6.9-42.0.2]
-sctp: Fix data overflow in iovec computation (Neil Horman) [202122]

* Fri Aug 4 2006 Jason Baron <jbaron@redhat.com> [2.6.9-42.0.1]
-fix O_DIRECT writes to memory holes can leak a page reference (Jeff Moyer) [191736] {CVE-2004-2660}
-fix sctp chunk length overflow (Neil Horman) [192636] {CVE-2006-1858}
-fix possible DoS in write routine of ftdi_sio driver (Pete Zaitcev) [197610] {CVE-2006-2936}
-fix typo in drivers/cdrom/cdrom.c (Chip Coldwell) [197670] {CVE-2006-2935}
-Fix reboot on IBM Pizzaro machines (Bastien Nocera) [200111]
-don't shut down on bogus filehandles from nfs clients (Eric Sandeen) [199172] {CVE-2006-3468}
-fix for prevention of setuid/gid on /proc/<pid> files (Ernie Petrides) [198973] {CVE-2006-3626}
-fix SNMP NAT netfilter memory corruption (Thomas Graf) [192632] {CVE-2006-2444}
-fix for non-hugemem x86 DoS w/bogus %ds/%es values (Ernie Petrides) [196280] {CVE-2006-2932]

* Wed Jul 12 2006 Jason Baron <jbaron@redhat.com> [2.6.9-42]
-s390: qeth IP address parsing fix (Jan Glauber/Pete Zaitcev) [195604]

* Wed Jul 12 2006 Jason Baron <jbaron@redhat.com> [2.6.9-41]
-ia64: fix kprobes for Montecito (Anil Keshavamurthy) [198256]
-sctp: fix netfilter code to avoid incorrect pointer dereference (Neil Horman) [197387] {CVE-2006-2934}
-ia64: add cow icache flush (Anil Keshavamurthy) [194469]

* Fri Jul 7 2006 Jason Baron <jbaron@redhat.com> [2.6.9-40.1]
-s390: fix channel path measurement data typo (Jan Glauber) [195682]
-s390: hypfs fixes (Jan Glauber) [180564 195463 195464]
-restrict prctl() syscall to setting PR_SET_DUMPABLE to 0 or 1 (Ernie Petrides) [195902] {CVE-2006-2451}
-megaraid: fix potential data corrupter (Tom Coughlan) [194533 196573]
-infiniband: fix out of tree object directory builds (Doug Ledford) [196712]

* Mon Jun 26 2006 Jason Baron <jbaron@redhat.com> [2.6.9-40]
-Fix 32-bit sched_rr_get_interval (Jim Paradis) [196687 195664]

* Fri Jun 23 2006 Jason Baron <jbaron@redhat.com> [2.6.9-39.4]
-emu10k1: audigy4 support (John Linville) [180065]

* Thu Jun 22 2006 Jason Baron <jbaron@redhat.com> [2.6.9-39.3]
-infiniband: update to 1.0 OFED (Doug Ledford) [193126]

* Thu Jun 22 2006 Jason Baron <jbaron@redhat.com> [2.6.9-39.2]
-x86(64) Fix FPU information leak (Jim Paradis) [187910] {CVE-2006-1056}
-fix MSI-X 64-bit support (Chip Coldwell) [192098]
-fix kernel BUG() in __kfree_skb while running TCP+Kernel stress (Andy Gospodarek) [192779] {CVE-2006-2446}
-fix netdump regression on e1000 (Neil Horman) [193688]
-Add diskdump support for Servraid cards (Nobuhiro Tachino) [172202]
-ppc64: fix unprivileged process can read arbitrary kernel memory (David Woodhouse) [194215]
-make mmap PROT_WRITE imply PROT_READ (Josef Whiter) [194289]
-make network cards visible on HP xw9400 (Bastien Nocera) [195254]
-fix resync device-mapper mirror hang (Jonathan Brassow) [193728 195502]
-force noapic for ES7000 (Konrad Rzeszutek) [195002]
-bonding: back-out sysfs updates (John Linville) [194410]
-azx: re-instate special case for HP xw{4,6,8,9}400 (John Linville) [195544]
-e1000: fix for 6321ESB (John Linville) [195699]

* Fri Jun 16 2006 Jason Baron <jbaron@redhat.com> [2.6.9-39.1]
-avoiding EBDA for early memory map allocation (Robert Hentosh) [172729]
-stex: add diskdump support (Nobuhiro Tachino) [191934]
-fix overflow when reading malformed Heartbeat ACK (Neil Horman) [192635] {CVE-2006-1857}
-fix some raid partitions left out-of-sync on reboot (Kimball Murray) [194241]
-disable nfs v2 ACL support (Steve Dickson) [178848]
-azx: support hp laptops w/ ad1981 codecs (John Linville) [180381]
-fix f_count leak in NLM granted callback code (Jeff Layton) [194367]

* Thu Jun 1 2006 Jason Baron <jbaron@redhat.com> [2.6.9-39]
-better KABI fixup for 'memnodemap' (Konrad Rzeszutek) [193717]

* Thu Jun 1 2006 Jason Baron <jbaron@redhat.com> [2.6.9-38]
-fixup KABI for 'memnodemap'

* Fri May 19 2006 Jason Baron <jbaron@redhat.com> [2.6.9-37]
-Introduce netpoll over bonded interfaces (Thomas Graf) [174184 126164 190162 146164]
-fix MCFG table parsing (Konrad Rzeszutek) [191039 164429 192408]
-x86_64: cleanup page tracking (Kimball Murray) [179696]
-fix acpi table already exists (Geoff Gustafson) [192303]
-revert: fix NFS cache consistency when a file is mmap'ed

* Thu May 18 2006 Jason Baron <jbaron@redhat.com> [2.6.9-36.1]
-i386: complete fix for APIC tests (Jim Paradis) [166885]
-add missing unlock_kernel in nfs_mkdir codepath (Jeff Layton) [191269]
-fix smbfs chroot issue (Peter Staubach) [189435] {CVE-2006-1864}
-add adp94xx driver (Konrad Rzeszutek) [191330]
-update 3ware 9xxx SATA RAID driver (Chip Coldwell)
-sctp: fix fixes for various vulnerabilities (Neil Horman) [191201 191202 191258] {CVE-2006-2271 CVE-2006-2272 CVE-2006-2274}
-device-mapper mirroring: Fix failed write handling (Jonathan Brassow) [191723]
-fix local crash by dio/mmap sg/st driver (Doug Ledford) [168791]
-remove incorrect choose_new_parent BUG() call (Jason Baron) [187841]
-cciss: ia64: disable MSI/MSI-X (Tom Coughlan) [179860]
-fix bad error handling in several compat_nfs_* (Jeff Layton) [191776]
-fix bridge poisoning (Thomas Graf) [171383] {CVE-2005-3272}
-netfilter/sctp: fix lockup in sctp_new (Thomas Graf) [190460] {CVE-2006-1527}
-ia64: replace acpi_register_gsi() panic call with warning message (Prarit Bhargava) [191847]
-update lpfcdfc ioctl driver to version 2.0.15 (Chip Coldwell) [181475]

* Mon May 8 2006 Jason Baron <jbaron@redhat.com> [2.6.9-35.4 2.6.9-36]
-Recognize boot CPU APIC id properly (Jim Paradis) [176612 174627]
-s3390: update add channel path measurement data support (Jan Glauber) [180410]
-Infiniband: merge OFED 1.0-rc4-pre (Doug Ledford)
-revert: netpoll over bonded interfaces

* Fri May 5 2006 Jason Baron <jbaron@redhat.com> [2.6.9-35.3]
-Introduce netpoll over bonded interfaces (Thomas Graf)
-x86_64: implement lapic-status just for the installer (Prarit Bhargava) [184583]
-sky2: update to version 1.1 (John Linville) [179560]
-SCSI whitelist update (Doug Ledford) [161333]
-st: add check_tape() call for correct status return for open tape files (Doug Ledford) [168234]
-x86_64: fix vsyscall misalignment (Peter Martuccelli) [181780]

* Thu May 4 2006 Jason Baron <jbaron@redhat.com> [2.6.9-35.2]
-fix clock runs too fast on AMD Athlon 64 w/ATI chipset (Brian Maly) [173236]
-s390: add hypfs support (Jan Glauber) [180564]
-s390: qeth fixes (Jan Glauber) [190428]
-fix RSA driver (Konrad Rzeszutek) [182270]
-s390: qeth system crash during transmission (Jan Glauber) [190641]
-ia64: fix ia64_mv kabi breakage (Prarit Bhargava)
-export acpi_prt (Kimball Murray) [189793]

* Wed May 3 2006 Jason Baron <jbaron@redhat.com> [2.6.9-35.1]
-fix oops when more than 4k of data present in /proc/devices (Neil Horman) [156145]
-allow for SCI override (Kimball Murray) [180937]
-diskdump: lpfc support (Nobuhiro Tachino) [180749]
-device-mapper mirror: Fix clean_bits after shrinking fix (Jonathan Brassow) [186104]
-fix kabi for acpi_register_gsi() (Anil Keshavamurthy) [170266]
-fix busy inodes after unmount (Peter Staubach) [173843]
-audit: add execve() argument logging support (Aristeu S. Rozanski F.) [168285]
-revert: netpoll over bonded interfaces

* Tue May 2 2006 Jason Baron <jbaron@redhat.com> [2.6.9-35]
-revert: fix hanging serial console
-Introduce netpoll over bonded interfaces (Thomas Graf)
-fix USB error handling (Kimball Murray) [189279]
-qla2xxx update v. 8.01.04-d7 (Mike Christie) [188912]
-Fix coredump vs exec deadlock (David Howells) [168112]
-add i2c sensors drivers (Eric Paris) [171507]
-s390: fix sysrq backtrace oops (Jan Glauber) [185736]
-s390: fix crypto driver memory overwrite (Jan Glauber)
-s390: lcs driver fixes (Jan Glauber)
-add hpet_period finetuning to allow correction of hpet drift (Brian Maly) [169876]
-bonding updates (Thomas Graf) [180431]
-Add MSI/MSI-X support to cciss (Tom Coughlan) [179860]
-add modern_apic() tests (Jim Paradis) [166885]
-SUNRPC: rpcbind should retry if server's portmapper becomes unavailable (Steve Dickson) [172082]
-device-mapper mirroring: error on log failure override (Jonathan Brassow)
-make aic7xxx and aic79xx Drivers Support 16-byte CDBs (Chip Coldwell)
-fix ipmi driver broken on HP Integrity platform (Brian Maly) [174986]
-fix mmap wastes too much virtual address space for 32-bit environment (Larry Woodman) [173662]
-IPMI: Resolve startup race condition (Peter Martuccelli) [189390]
-ati sb600 support (John Linville) [189844]
-Emulex lpfc/lpfcdfc drivers re-organizations (Chip Coldwell) [179752]

* Mon May 1 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.28]
-Fix support for cmdline > 256 chars (Jim Paradis) [175616]
-s390: add support for crypto cex2a cards (Jan Glauber) [180918]
-s390: add channel path measurement data support (Jan Glauber) [180410]
-getcwd() returns odd answer under special conditions (Peter Staubach) [189274]
-diskdump: support multiple dump device/partitions (Akira Imamura) [168967]
-add perfmon support for Montecito (Anil Keshavamurthy) [178819]
-fix udevd vs. file create race (Jason Baron) [151981]
-NFS: Connectathon tests fail against newer Irix server (Steve Dickson) [186066]
-(big)Demand Based Switching (DBS) support (Konrad Rzeszutek) [173676]
-fix 8250_acpi.c can't find Fixed-IO port (Jason Baron) [165480]
-fix oops in md linear.c (Doug Ledford) [167856]
-fix PCI interrupts on ioapic incorrectly asigned non legacy (IRQ>15) IRQ's (Brian Maly) [184254 185123]
-fix erronious kernel general protection fault message (Larry Woodman) [174994]
-PCI Hotplug: get pciehp to work on the downstream port of a switch (Eric Paris) [168543]
-fix ide_hwif_release_regions leaves DMA resources behind (Kimball Murray) [189902]

* Fri Apr 28 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.27]
-add CommitLimit to /proc/meminfo (Don Zickus) [176991]
-fix bt command fails with a dump via OS_INIT (Nobuhiro Tachino) [172156]
-ext3/jbd: fix releasing inuse journal heads race (David Milburn) [185451]
-usb: fix cd sizing issue (Pete Zaitcev) [178288]
-DMI entry to resolve an HP xw9400 boot issue (Peter Martuccelli) [188223]
-Add Promise SuperTrak EX SATA RAID driver (Jeff Garzik) [180434 189392]
-LSM: add missing hooks to readv/writev (James Morris) [191524]
-SATA update (Jeff Garzik) [181852 179496 179216 179206 171304 176107 141342 156663 157404 157902 168289]
-Mark vDSO signal trampoline EH with the new S flag (Jakub Jelinek) [187036]
-revert: netpoll over bonded interfaces
-revert: fix oops when more than 4k of data present in /proc/devices

* Fri Apr 28 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.26]
-correct /proc/cpuinfo siblings field (Geoff Gustafson)
-Turning on bigsmp support - default x86 kernel boots on 8 Opteron system (Bhavana Nagendra) [158845]
-fix 'Cannot allocate memory' when cat /proc/scsi/scsi (Chip Coldwell) [164511]
-device-mapper: unify chunk_size (Alasdair Kergon) [188080]
-device-mapper: Fix mapped device references (Alasdair Kergon) [189797]
-iscsi: update driver version (Mike Christie) [182684]
-Add support for volumes > 2TB to megaraid_sas (Tom Coughlan) [179691]
-device-mapper: Fix bio_endio size (Alasdair Kergon) [187249]
-device-mapper: Fix failed write handling (Alasdair Kergon) [186004]
-device-mapper mirror fixes (Alasdair Kergon, Jonathan Brassow) [187249 185782 186104 185785]

* Wed Apr 26 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.25]
-diskdump: fix OS_INIT dump function (Nobuhiro Tachino) [155926]
-properly timeout large values to sys_polll (Peter Staubach) [160065]
-Use e820 map to establish PCI address range (Jim Paradis) [162977 169009]
-fix gcore terminating i386 target process abnormally on x86-64 (Nobuhiro Tachino) [185308]
-x86_64: make more room for the swiotlb (Geoff Gustafson) [173895]
-nfs4: properly handle when path contains a symlink (Steve Dickson, Josef Whiter) [189026]
-autofs: return -ENOENT for a successful replicated server mount (Jeff Moyer) [187951]
-qla2xxx: diskdump support (Nobuhiro Tachino) [180749]
-Introduce netpoll over bonded interfaces (Thomas Graf)
-MSI interrupt fix for multiple PCIe NICs (Geoff Gustafson) [188712]
-update lpfc driver to 8.0.16.26 (Chip Coldwell) [179752]
-lpfc driver: add managment ioctl module (Chip Coldwell) [181475]
-Workaround for EHCI on some nVidia silicon (Pete Zaitcev) [181828]
-qla1280: fix reference count (Tom Coughlan) [170831]
-Fix panic in ip_route_input() via inet_rtm_getroute() (Thomas Graf) [189346] {CVE-2006-1525}
-Downsize TCP hashes (Thomas Graf) [179671]

* Tue Apr 25 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.24]
-fix oops when more than 4k of data present in /proc/devices (Neil Horman) [156145]
-ieee80211, we-18, ipw2100, ipw2200 updates (John Linville) [171740 180965 180965]
-fix Promise IDE hotplug (Kimball Murray) [186482]
-s390: ctcmpc driver fixes (Jan Glauber) [163895]
-add tunable fraction of pages in zone percpu lists (Geoff Gustafson) [180489]
-add tunable wake-balance (Geoff Gustafson) [184398]
-fix fcntl_setlease with F_RDLCK and writers (Guy Streeter) [188956]
-azx: update from 2.6.16-rc5 (John Linville) [180383 180395]
-ppc: Number CPUs correctly after failed CPU skipped on start up (Manoj Iyer) [172586]
-nfsd: NFSD fails SETCLIENTID_CONFIRM (Steve Dickson) [186071]
-nfs: fix client panic using O_DIRECT (Steve Dickson) [181795] {CVE-2006-0555}
-revert: perfmon support for Montecito

* Mon Apr 24 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.23]
-correct L2/L3 cache reporting (Geoff Gustafson) [182143]
-fix PCI Master Abort when device access occurs during BIST (Manoj Iyer) [127888]
-ppc: fix how ibmveth driver handles the receive buffers (Manoj Iyer) [185404]
-x86: fix mem= boundary condition (Konrad Rzeszutek) [177299]
-e1000: update to 7.0.33-k2 (John Linville) [180512]
-fix ibmveth fix failed addbuf (Manoj Iyer) [183647]
-avoid deadlock in sctp (Neil Horman) [187494]
-x86_64: swiotlb is not working in NUMA mode (Konrad Rzeszutek) [187160]
-kabi fixes for netfilter (Jeff Layton)
-fix corner case where system does not OOM kill (Larry Woodman) [173471]

* Fri Apr 21 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.22]
-revised x86_64 page tracking (Kimball Murray) [179696 189128]
-Support ACPI 2.0 systems with no XSDT (Jim Paradis) [165809 186564]
-x86_64: allow kernel page table memory allocations to succeed on large memory (Konrad Rzeszutek) [179660]
-update ips driver (Mike Christie) [168576]
-s390: fix possible kernel stack corruption (Jan Glauber) [180653]
-Fix ipv6_add_addr() (David Miller) [169871]
-ppc: make lsmap display client ID (Manoj Iyer) [189241]
-ppc: update PACA on SLB flushes for hugepage (Manoj Iyer) [185956]
-ia64: add perfmon support for Montecito (Anil Keshavamurthy) [178819]
-fix crash when using a kretprobe module (Anil Keshavamurthy) [189460]

* Thu Apr 20 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.21]
-Add diskdump capability to IDE (Nobuhiro Tachino) [183392]
-add dcdbas driver (Neil Horman) [170138]
-diskdump for megaraid_sas (Nobuhiro Tachino) [180585]
-Possible hang when ptracing and using hugepages (Bastien Nocera) [182726]
-ia64: fix system hang with large number of processes (Doug Chapman) [186542]
-add CCISS diskdump support (Nobuhiro Tachino) [161161]
-various diskdump fixes (Alexander Viro) [187498 187500 187501 187502]
-fix hanging serial console (Alan Cox)
-fix ipt_recent problem during jiffies wrap (Josef Whiter) [189127]
-bonding: allow vlan traffic over bond (John Linville) [174671]

* Wed Apr 19 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.20]
-nm256: update (John Linville) [158989]
-ppc: Enable EEH on dynamic add P5IOC/DDR slots (Manoj Iyer) [181419]
-ppc: enable ptrace system call to use altivec registers (Manoj Iyer) [175608]
-ia64: hugetlb page fault handling (Norm Murray) [187204]
-fix remove_proc_entry race condition (David Milburn) [187418]
-fix Missing LUNs with Hitachi Open-* SANs (Bastien Nocera) [184208]
-ich8: add chipset support to appropriate drivers (John Linville) [180522]
-nfs: path_release() should be called only afterpath_lookup() is successful (Manoj Iyer) [186256]
-revert: vm: wired pagetables patch (Larry Woodman) [188141 185110]
-fix use after free in cciss driver initialization (Jeff Layton) [189352]

* Tue Apr 18 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.19]
-reorder timesource selection on x86 (Brian Maly) [172199]
-emu10k1: add support for Sound Blaster Audigy 2 Value (John Linville) [154984]
-sym53c8xx_2 - IGNORE WIDE RESIDUE (David Milburn) [167366]
-fix and enable dcssblk driver (Jan Glauber) [180738]
-iseries_veth: Fix bogus counting of TX errors (John Linville) [167372]
-fix SRAT parser (Konrad Rzeszutek) [181895]
-ppc64: fix invalid use of get_user() (Manoj Iyer) [171780]
-fix lsof causes kernel oops under heavy load (Adam Stokes) [189260]
-prevent anonymous page from being in an inconsistant state and crashing system (Larry Woodman) [171645]

* Mon Apr 17 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.18]
-fix possible DoS attack via nfsservctl (Peter Staubach) [183416]
-fix ENOMEM errors when adding large numbers of netfilter rules (Jeff Layton) [182573]
-nfsv4: fix oops resulting from incorrect propogation of nfsv4 specific errors to vfs (Neil Horman) [185306]
-Bonding: Layer3+4 hashing support for XOR and 802.3ad modes (Andy Gospodarek) [168857]
-Bonding: Stop reception of duplicate frames (Andy Gospodarek) [187746]
-optimize fork() by not copying ptes that can be faulted in later (Adam Stokes) [185386]
-VLAN initialization before interface link-up stops VLAN activation (Andy Gospodarek) [188087]
-ppc64: System crash when kprobing conditional trap instructions (Anil Keshavamurthy) [188262]
-fix race in net bonding driver (Kimball Murray) [188296]
-revert: x86_64 page tracking

* Tue Apr 11 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.17]
-irq compression for x86/x86_64 (Jim Paradis) [168361]
-x86_64: default gtod to tsc for Intel (Jason Baron)
-Do not force softrepeat on certain keyboards (Pete Zaitcev) [181457]
-Fix Direct IO deadlock for out of tree fs (Peter Staubach) [173586]
-ramfs: update dir mtime and ctime (Peter Staubach) [183661]
-fix ibmvscsi (Doug Ledford) [183502]
-bnx2: update to 1.4.38 (John Linville) [182105]
-tg3: update to 3.52-rh (John Linville) [174019 174470 180070 180081]
-ia64: sn update (Prarit Bhargava) [183156]

* Mon Apr 10 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.16]
-fix Tar with verify (-W) gives 'Cannot seek: Illegal seek' error (Peter Staubach) [174522]
-autofs4: fix race between mount/expire (Jeff Moyer) [175778]
-fix netconsole to emit proper message to trigger netdump-start script on server (Neil Horman) [177628]
-Enable DMA on SGI CDROMs (Prarit Bhargava)
-ia64: irq sharing (Jim Paradis) [170266]
-Resolve incorrect IPMI generator ID (Peter Martuccelli) [174606]
-revised x86_64 page tracking (Kimball Murray) [179696]
-fix NFS cache consistency when a file is mmap'ed (Jeff Layton)
-Keys: Fix oops when adding key to non-keyring (David Howells) [188466] {CVE-2006-1522}

* Fri Apr 7 2006 Jason Baron <jbaorn@redhat.com> [2.6.9-34.15]
-fix build break when CONFIG_4KSTACKS=n (Neil Horman) [165113]
-correct dpt_i2o proc_info oops (Don Howard) [180400]
-e100: update to 3.5.10-k2 (John Linville) [180912]
-s390: fix lost timer interrupts (Jan Glauber) [172418]
-s390: fix cio path recovery (Jan Glauber) [175350]
-s390: qdio: remove duplicate timeout (Jan Glauber)
-enable lapic and i/o apic for UP kernels (Konrad Rzeszutek) [168584]

* Thu Apr 6 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.14]
-SELinux: mls filesystem security labeling compatibility (James Morris) [177439]
-fix PPR negotiation in sym53c8xxx_2 driver (Jeff Layton) [180366]
-fix speed of diskdump on the CPU0 is slow (Nobuhiro Tachino) [177959]
-make scheduler multi-core aware (Ingo Molnar,Geoff Gustafson ) [182128]
-fix speedstep for constant TSC on new processors (Geoff Gustafson) [182140]
-diskdump: dump memory with a swap partition whose size is less than memory size (Akira Imamura) [175854]
-Correctly ignore expired IPv6 default routes (Thomas Graf) [180621]
-Fix Linux zero IP ID vulnerability (Thomas Graf) [186057] {CVE-2006-1242}
-Fix small information leak in SO_ORIGINAL_DST (Thomas Graf) {CVE-2006-1343}
-Fix netfilter do_replace() overflow (Thomas Graf) {CVE-2006-0038}

* Wed Apr 5 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.13]
-add 'panic_on_unrecovered_nmi' proc setting (Linda Wang) [186141]
-OProfile: Support model 4 P4 (Jeff Burke) [176601]

* Tue Apr 4 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.12]
-usb HCs need TRSTRCY (Pete Zaitcev) [165245]
-s390:  make __constant_test_bit return a boolean (Eric Paris) [179626]
-s390: qeth driver update (Jan Glauber) [180940]
-Kprobes fixes back port (Anil Keshavamurthy) [180260]
-ppc64: fix adding a dedicated processor on lpar drops into xmon (Manoj Iyer) [180627]
-ibmveth: update timestamps to work w/ bonding arp monitor (John Linville) [179867]
-ppc64: support for early serial console or console debugging (Manoj Iyer) [185755]
-fix for ELF exec vulnerability on EM64T (Ernie Petrides) [183489 175663] {CVE-2006-0741 CVE-2006-0744}

* Fri Mar 31 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.11]
-fix Tux oops with symlinks (Dave Jones) [185971]
-fix async usb devio oops (Pete Zaitcev) [169260] {CVE-2005-3055}
-pcibios ioapic fix (Kimball Murray) [176342]
-fix shutdown deadlock on emulex cards with disconnected FC cable (Jeff Layton) [170434]
-Add Emulex IOCTL module (Tom Coughlan)
-fix NFSv4 mounts hang in un-interruptible state (Andy Gospodarek) [184549]
-fix overcommit_memory docs (Bryn Reeves) [175763]
-Fix mdadm --grow infinite resync problem (Doug Ledford) [166541]

* Thu Mar 30 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.10]
-fix x86_64 mce arg parsing (Jim Paradis) [171277]
-x8664, x86: Add support for cpu siblings and cpu core maps (Bhavana Nagendra) [182168]
-Support MCE Threshold Counters in the kernel for Opterons (Bhavana Nagendra) [169574]
-support new machine check error bank (Geoff Gustafson) [180568]
-fix typo in spinlock.h (Jason Baron) [180568]
-fix PAGE_KERNEL_EXEC definition (Jason Baron) [186316]

* Mon Mar 27 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.9]
-make md layer properly refuse I/O barrier requests (David Milburn) [185425]
-device-mapper: free_dev: add missing bdput() (Alasdair Kergon) [185444]
-device-mapper: fix free_dev del_gendisk() (Alasdair Kergon) [185445]
-device-mapper mirroring: fix resync suspend state (Alasdair Kergon) [177067]
-device-mapper: flush queued bios if suspend is interrupted (Alasdair Kergon) [185447]
-device-mapper mirroring: log bitset fix BE find_next_zero_bit (Alasdair Kergon) [185450]
-device-mapper snapshots: replace siblings list (Alasdair Kergon) [185455]
-device-mapper mirroring: status output incorrect (Jonathan Brassow) [185454]
-device-mapper mirroring: fix bad argument count check (Jonathan Brassow) [185431]
-device-mapper snapshots: fix invalidation (Alasdair Kergon) [185459]
-device-mapper striping: Avoid device overrun (Alasdair Kergon) [185468]
-device-mapper: bio split bvec fix (Alasdair Kergon) [185991]

* Thu Mar 23 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.8]
-fix IBM x336 hang on reboot (Eric Paris) [173151]
-Fix race in set_max_huge_pages for multiple updaters of nr_huge_pages (Eric Paris) [173617]
-fix ipc missing wakeup (Norm Murray) [149933]
-set BLIST_LARGELUN for HITACHI OPEN-9 (David Milburn) [179762]
-ppc64: correct sys_rt_sigreturn to avoid truncated return code (Neil Horman) [184381 183396]
-Keys: Use strnlen_user() correctly in key management (David Howells) [181879]
-update ipr driver to support enhanced RAID5 and RAID6 functions in new adapters on i5 systems (Manoj Iyer) [180931]
-make JSM driver to work properly at high baudrates (Manoj Iyer) [179881]

* Wed Mar 22 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.7]
-allow for a more fine grained dirty_ratio (Larry Woodman) [181529 174086]
-setup zone thresholds correctly for numa (Eric Paris) [178355]

* Tue Mar 21 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.6]
-ia64: Fix corrupt ar.bspstore (Prarit Bhargava) [177297]
-fix Invalid arguments passed to fault_in_pages_readable() (Larry Woodman) [162760]
-ppc64: fix sys64_time is actually able to go backwards (Eric Paris) [178098]
-fix O_DIRECT read of last block in a sparse file (Jeff Moyer) [178084]
-fix last AIO read of a file opened with O_DIRECT returns wrong length (Jeff Moyer) [178074]
-Prevent system deadlock when using AltSysrq-M (Larry Woodman)
-x86_64: fix 32bit sys_io_setup (Jeff Moyer) [176361 185646]
-s390/s390x: Fix strnlen_user() (David Howells) [181881] {CVE-2006-0456}

* Fri Mar 17 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.5]
-add skge net driver (John Linville) [157247 167768]
-knfsd: improve hasing function (Steve Dickson) [176173]
-revert: USB storage change which breaks remote installs using an IBM RSAII adapter (Mike Gahagan) [178271]
-Move ip_vs defense work to keventd (Thomas Graf) [174990]
-Fix [rw]mem_max < [rw]mem_default (Thomas Graf) [174709]
-Remove CAP_NET_ADMIN requirement for INFOQUERY ioctl (Thomas Graf) [174833]
-device-mapper mirrors: fix missing monitoring workqueue destruction (Alasdair Kergon) [180138]
-ia64: fix system crash (Anil Keshavamurthy) [183495]


* Thu Mar 16 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.4]
-make vmalloc() succeed for larger memory allocations (Larry Woodman) [173193]
-fix premature return of socket errors until queued data is received in sctp (Neil Horman) [169456]
-fix ipv4->ipv6 adddress mapping in sctp (Neil Horman) [174499]
-fix erroneous return of POLLOUT event for sctp sockets (Neil Horman) [173820]
-fix Cyclone key kills USB stack (Pete Zaitcev) [166061]
-AMD PowerNow! patches to support Opteron Rev G (Bhavana Nagendra) [178845 176273]
-atiixp: add pci ids for sb450 chipset (John Linville) [173919 180505]
-amd74xx: add pci ids for Nvidia MCP51 (John Linville) [181793]

* Tue Mar 14 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.3]
-s390: fix diag10 exception (Jan Glauber) [172429]
-docs: update bonding.txt to discuss the showing of IP's on slave interfaces (Eric Paris) [178335]
-fix signing comparrision between vm_committed_space and allowed (Eric Paris) [179469]
-add ext2 compat ioctl for use with ext2online (Christopher Lalancette) [182422]
-fix boot BUG() on un-initialized spinlock (Jason Baron) [184523 179334 173489 165498]
-cfq-iosched: prevent I/O starvation (Larry Woodman) [184535]
-nfs: prevent ACL from being set on read-only filesystems (Steve Dickson) [185043] {CVE-2005-3623}
-Fix SELinux ptrace bug (James Morris) [185289] {CVE-2006-1052}

* Fri Mar 10 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.2]
-s390: add s390 CTC-MPC driver (Jan Glauber) [163895]
-s390: fix signal quiesce (Jan Glauber) [171703]
-s390: zfcp driver update (Jan Glauber) [174615 171982]
-Keys: Fix key quota management on key allocation (David Howells) [181870]
-Keys: Replace duplicate non-updateable keys rather than failing (David Howells) [181869]
-Fix scsi_mod parameter docs (Doug Ledford) [174155]
-x86_64: fix enumeration of opteron cores for /proc/cpuinfo (Bhavana Nagendra) [182590]
-make initcall_debug work (Prarit Bhargava) [182597]

* Tue Mar 7 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34.1]
-revert: workaround for NEC Express5800 not booting
-ppc64: oprofile: enable proper performance monitoring control bits (William Cohen) [172229]
-ipv6: fix possible infinite loop condition (Thomas Graf) [170772] {CVE-2005-2973}
-fix incorrect inrement/decrement in atm module (Thomas Graf) [175769] {CVE-2005-3359}
-Fix collision between pmtimer and pit/hpet timekeeping on IBM x460 (Eric Paris) [175293]
-x86_64: build i810.o, i830.o, i915.o (Jason Baron) [181912]
-nfs: fix lock recovery (Steve Dickson) [182137]
-ext2: rm command hangs when removing a symlink on ext2 loop filesystem (Peter Staubach) [170143 180028]

* Fri Feb 24 2006 Jason Baron <jbaron@redhat.com> [2.6.9-34]
-Resolve ACPI SCI sharing and IRQ re-assignment (Peter Martuccelli) [182387]

* Mon Feb 20 2006 Jason Baron <jbaron@redhat.com> [2.6.9-33]
-fixup kcopyd nr_jobs accouting (Jonathan Brassow) [181574]
-fixup "noht" bootline command option (Jim Paradis) [181884]

* Tue Feb 14 2006 Jason Baron <jbaron@redhat.com> [2.6.9-32]
-correctly initialize Opteron cores (Bhavana Nagendra) [180919]

* Thu Feb 9 2006 Jason Baron <jbaron@redhat.com> [2.6.9-31]
-fixup kabi changes in kcopyd changes 

* Tue Feb 7 2006 Jason Baron <jbaron@redhat.com> [2.6.9-30.1]
-sky2: allow MAC address change w/o PHY re-init (John Linville) [177987]
-fix kabi breakage in cpuinfo_ia64 (Geoff Gustafson) [180405]
-automatic detection and initialization of bigsmp mode (Peter Martuccelli) [172992]
-revert: wake-balance optimizations, fixes corner case performance issue [177634]
-optimize kprobes fault handling (Anil Keshavamurthy) [177634]
-fix NEC Express5800 not booting (Brian Maly) [178439]
-e1000: omnibus fixes (John Linville) [165118]
-device-mapper snapshots: fix snapshot kcopyd destructor [179751]

* Fri Jan 27 2006 Jason Baron <jbaron@redhat.com> [2.6.9-30]
-corrected HT sibling setup bug (Geoff Gustafson) [178975]

* Tue Jan 24 2006 Jason Baron <jbaron@redhat.com> [2.6.9-29]
-tg3: add wmb() (John Linville) [178231]
-sky2: updates from upstream (John Linville) [177882 178837]
-HT sibling setup bug (Geoff Gustafson) [178740]
-e1000: actually support 82571/2 (John Linville) [165118]

* Fri Jan 13 2006 Jason Baron <jbaron@redhat.com> [2.6.9-28]
-s390: add qeth CDLC support (Jan Glauber) [170689]
-s390: fix semaphore performance problem under LPAR (Jan Glauber) [171699]
-s390: qeth driver fixes (Jan Glauber) [175726 175725 175723]
-s390: fix swapped memset args (Dave Jones) [176825]
-add SAS support (Jeff Garzik) [165134 177527]
-fix ioctl compat for USBDEVFS_IOCTL (Pete Zaitcev) [158852]
-device-mapper mirroring: Increment mirror version number (Alasdair Kergon) [176874]
-device-mapper mirror log: avoid overrun while syncing (Alasdair Kergon) [177031]
-bnx2: update to version 1.4.30 (John Linville) [164825]
-add scsi2 support when pq3 is returned and fix regressions from scsi3 support (Mike Christie) [155725 177587]
-fix dm-crypt key leak (James Morris) [177136] {CVE-2006-0095}
-Bump MAX_APICS to support largesmp configs (Jim Paradis) [177561]
-nfs: fix acl hang (Steve Dickson) [177522]
-autofs4 regression: remove negative dentry caching (Jeff Moyer) [175687]
-s390: fix hangcheck-timer (Jan Glauber) [175988]
-device-mapper snapshots: Barriers are not supported (Alasdair Kergon) [177620]
-device-mapper snapshots: fix origin_write pending_exception submission (Alasdair Kergon) [172839]
-prevent LVM stripe on SATA resulting kernel panic (Larry Woodman) [166544]

* Thu Jan 12 2006 Jason Baron <jbaron@redhat.com> [2.6.9-27.1]
-fix lease printk DoS (Peter Staubach) [174337] {CVE-2005-3857}
-prevent panic caused by invalid arguments to set_mempolicy (Larry Woodman) [175683] {CVE-2005-3358}
-fix dst_entry leak DoS (Thomas Graf) [174345] {CVE-2005-3848}
-fix ip6_input_finish DoS (Thomas Graf) [174343] {CVE-2005-3858}
-fix ipv6 flowlabel DOS (Thomas Graf) [174081] {CVE-2005-3806}
-fix IGMP DoS (Thomas Graf) [174807] {CVE-2002-2185}
-fix auto-reap DoS (Peter Staubach) [174078] {CVE-2005-3784}
-fix kernel memory disclosure via /proc exploit (Jason Baron) [176812] {CVE-2005-4605}

* Tue Dec 20 2005 Jason Baron <jbaron@redhat.com> [2.6.9-27]
-re-build for gcc changes affecting the kernel-debuginfo package

* Tue Dec 20 2005 Jason Baron <jbaro@redhat.com> [2.6.9-26]
-nfs: fix return value setxattr() (Steve Dickson) [175812]
-revert: speedup raw dio and aio paths (Geoff Gustafson) [167645]
-fix security_ops kabi breakage (Jason Baron) [175680]
-set ipv6 fragment id correctly (David Miller) [173118]

* Mon Dec 12 2005 Jason Baron <jbaron@redhat.com> [2.6.9-25]
-Keys: Permission checking fix for key update vs add (David Howells) [171705]
-fix vmware mpt fusion regression (Mike Christie) [170985]
-gfs: fix DirectIO Deadlock (Wendy Cheng) [173912]
-Fix audit filtering on syscall failure (David Woodhouse) [175132]
-Turn off PCI parity check by default (Alan Cox)
-New range of userspace audit message types (David Woodhouse) [175415]
-fix scsi_eh_tur retry logic (Pete Zaitcev) [175188 160308]
-nfs: fix I/O stalls waiting on revalidation (Steve Dickson) [175236]
-azx: update (John Linville) [171985 172129 172920]

* Fri Dec 9 2005 Jason Baron <jbaron@redhat.com> [2.6.9-24.1]
-revert: aic94xx SAS driver [165134]
-restore diskdump for SATA (Peter Martuccelli) [175123]
-ia64: include iomap.h in io.h (Prarit Bhargava) [174734]
-update Emulex FC lpfc driver (Mike Christie) [149294 163150 175136 175142]
-ia64: Fix improper initcall loading on sn arch (Prarit Bhargava) [173523 174985]
-fix potential cifs data corrupter in 1.34a update (Steve Dickson) [170498]
-x86_64: fix random single bit corruption (Jason Baron) [175128 175292]
-sky2: add new driver (John Linville) [168246 171060]
-qlogic aen handling and jiffies fix (Mike Christie) [174427]
-prevent system deadlock (Larry Woodman) [174895 161101 162759]
-cciss: ioctl fixes (Tom Coughlan) [168571]
-e1000: restore 8086:1099 to PCI ID table (John Linville) [175092]

* Wed Nov 30 2005 Jason Baron <jbaron@redhat.com> [2.6.9-24]
-fix scsi delete timer race (Doug Ledford) [164629]
-x86_64: include iomap.h in io.h (Peter Martuccelli) [174583]
-fix powernow-k8 pending bit stuck (Brian Maly)

* Mon Nov 28 2005 Jason Baron <jbaron@redhat.com> [2.6.9-23]
-revert: fix memory mapped files not updating timestamps [173226]

* Wed Nov 23 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.27]
-revert: netpoll: avoid calling the napi poll routine recursiviely [146164]

* Wed Nov 23 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.26]
-ia64 diskdump using DUMP_EXCLUDE_FREE hangs when called from INIT (Keiichiro Tokunaga) [169519]
-autofs4: fix broken expiry of negative dentries (Jeff Moyer) [172986]
-netpoll: avoid calling the napi poll routine recursiviely (Jeff Moyer) [146164]
-add dell_rbu driver for Dell BIOS image updates (Brian Maly) [170132]
-fix Platform SMIs interfere with tsc based delay calibration (Brian Maly) [168811]
-update sg_io verify_command list (Mike Christie) [158861] {CVE-2004-1190}
-fix lost fput and sockfd_put could lead to DoS (Alexander Viro) [168659] {CVE-2005-3044}
-SATA update (Jeff Garzik) [131889 145061 166862 166880 169488]
-cciss: driver updates (Tom Coughlan) [168571]
-add aic94xx SAS driver (Jeff Garzik) [165134]
-add ATI RN50 ids to drivers/video/aty (Nathan Lynch)
-updated i82593 file license (John Linville) [172663]
-fix offb crash on IBM ppc blade (Nathan Lynch)
-ixgb: update to version 1.0.100-k2 (John Linville) [168502]
-fix memory mapped files not updating timestamps (Peter Staubach) [173226]
-Prevent sn2 code from executing on all ia64 platforms (Prarit Bhargava) [173354]
-Fix for SystemTap-  return probe on do_execve (Dave Anderson) [173304]

* Tue Nov 22 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.25]
-Wacom driver update (Kristian Høgsberg) [158842]
-fix endless loops in HID on disconnect (Pete Zaitcev) [167070]
-Make DVD-RAM writable on legacy iSeries VIOCD (David Howells) [168816]
-fix erratic behaviour when system fd limit reached (Peter Staubach) [166524]
-fix 32-bit program can hang x86_64 kernel (David Woodhouse) [168374]
-update MPT Fusion driver (Mike Christie) [168414]
-nfs: fix hangs with directio and aio using NFS (Steve Dickson) [161362]
-Fix "No such file or directory" errors when using autofs w/ghosting (Jeff Moyer) [173194]
-fix Diskdump fails through ipr driver (Nobuhiro Tachino) [159869]
-fix copy correct number of opcode bytes in sg_scsi_ioctl (Mike Christie) [169402]
-x8664: set NR_CPUS to 64

* Mon Nov 21 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.24]
-fix oops in raid1 code (Doug Ledford)
-fix sysctl races (Alexander Viro) [168924] {CVE-2005-2709}
-fix ia64 nested_dtlb_miss does not handle hugetlb address correctly (Dave Anderson) [168599]
-fix incorrect BUG_ON in signal.c after do_coredump() (Dave Anderson) [165581]
-speedup raw dio and aio paths (Geoff Gustafson) [167645]
-diskdump - support compressing dump data (Akira Imamura) [171141]
-fix kernel reporting init process cutime as very large negative value (Peter Staubach) [170146]
-add host port id to fc transport class (Mike Christie) [163150]
-add issue lisp fc class attribute (Mike Christie) [149294]
-update qla2xxx driver version to 8.01.02-d3 (Mike Christie)
-improve sctp receive buffer accounting (Neil Horman) [156602]
-add pci ids for 915/945 graphics (Geoff Gustafson) [170517 173882]
-ICH4L chipset support - pci id (Geoff Gustafson) [163171]
-fix message queue refcounting (Alexander Viro) [169130] {CVE-2005-3356}
-retry iscsi portal address after session address failure (Mike Christie) [170656]
-qla2xxx: update qlogic update (Mike Christie) [168544]
-fix /proc/scsi/scsi DoS (Doug Ledford) [167696] {CVE-2005-2800}
-Keys: Fix missed "struct key" types in reiserfs (David Howells) [171765]
-Keys: Permit key expiry time to be set (David Howells) [173486]
-Keys: Discard duplicate keys from a keyring on link (David Howells) [173486]
-fix  mount/umount can cause the block device reads to fail (Peter Staubach) [166589]
-Fix syscall auditing success indication on IA64 (David Woodhouse) [173500]
-Keys: Permit running process to instantiate keys (David Howells) [173493]
-IPMI - bug fix for dmi table off by one erro (Peter Martuccelli) [173815]

* Sun Nov 20 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.23]
-fix oops in gss_pipe_release() (Steve Dickson) [169149 171112]
-NFSv3 locking misses important kernel patches (Steve Dickson) [167192]
-Various Device Mapper updates (Alasdair Kergon) [168483 168824 170864 172892 173155 173156 173157 173158 173159 173161 173163 173164 173174 173206 173360]
-Support more detailed setting on partial dump (Keiichiro Tokunaga) [168638]
-fix HFS oops (Peter Staubach) [171002] {CVE-2005-3109}
-fix Kernel PANIC - not syncing: fatal exception (Steve Dickson) [163738]
-x64: x86_64: EDAC support (Alan Cox) [158247]
-must And iscsi opcode header (Mike Christie) [172487]
-prevent module unloading for ide-scsi (Tom Coughlan) [169648]
-fix NFS Cache invalidation bug in nfs v3 (Steve Dickson) [170423]
-ia64: fix access to extended config space (Jason Baron) [146516]

* Sun Nov 20 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.22]
-js20++ cpu enablement (Nathan Lynch) [170542]
-Generate a hotplug event when a CPU comes online (David Howells) [167469]
-Eliminate "no IOMMU" panic on ASUS motherboards (Jim Paradis) [169115]
-Update aacraid driver to 1.1-5[2412] (Tom Coughlan) [168567]
-Cure IA64 unaligns in sk_filter() (David Miller) [169396]
-ppc64: Assign CPUs to the correct NUMA node (David Howells) [164425]
-Update powernow-k8.c to support RevF Opterons (Brian Maly) [162178 171058]
-autofs4: don't expire in-use directory hierarchies (Jeff Moyer) [168431]
-IPMI: various fixes (Peter Martuccelli) [168090 169629 168796 169859 168596 168558 173343]

* Sat Nov 19 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.21]
-x86_64: set NR_CPUS to 255 for largesmp kernel
-Add initial Open Infiniband support (Doug Ledford) [108827 168445]
-Add megaraid_sas driver (Tom Coughlan) [167926]

* Fri Nov 18 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.20]
-wake-balance optimizations (Ingo Molnar) [167645]
-tg3: update to 3.43-rh (John Linville) [164892 165810 166111 167936 170527 168547]
-add PQ3 scsi scanning support (Mike Christie) [155725]
-add bnx2 driver (John Linville) [164825]
-mii: update to support gigabit (John Linville) [164825]
-Unisys Rascal Support (Brian Maly) [155017 137347 151986 157586 163847 167153 168604]

* Thu Nov 17 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.19]
-s390: add vm watchdog driver (Jan Glauber) [170358]
-s390: add vmcp device driver (Jan Glauber) [168513]
-s390: stop debug feature on oops (Jan Glauber) [168546]
-s390: add vm logreader driver (Jan Glauber) [168573]
-fix exec_mmap race  DoS (Dave Anderson) [170262] {CAN-2005-3106}
-s390: qeth driver layer 2 support (Jan Glauber) [168569 163741 168303]
-CIFS upgrade from version 1.20 to 1.34a (Steve Dickson) [170502 166667 170498]
-ppc64: inform hypervisor of VMX register use (Nathan Lynch) [170544]
-USB deadlock fix (Kimball Murray) [171220]
-fix calling disassociate ctty semantics (Jason Baron) [172740]
-fix gdb crashes on hugemem (Dave Anderson) [171980]

* Tue Nov 15 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.18]
-fix diskdump during OS_INIT (Norm Murray) [168262]
-fix NaT bit corrupution with coredump (Dave Anderson) [168954]
-fix ls hangs on krb5 mountd when user has not kinit-ed (Steve Dickson) [169184]
-ide: serverworks ht1000 support (John Linville) [168478]
-b44: alternate allocation option for DMA descriptors (John Linville) [161846]
-x86_64: implement dma_sync_single_range_for_{cpu,device} (John Linville) [161846]
-ia64: re-implement dma_get_cache_alignment to avoid EXPORT_SYMBOL (John Linville) [161846]
-swiotlb: allow sync of DMA_BIDIRECTIONAL mappings (John Linville) [161846]
-Fix missing finish_wait, resulting in OOPS (David Miller) [167211]
-Power5+: Add power5+ CPU support (David Howells) [168566]
-allow modules to load from prior kernel rpms (Jason Baron) [171989]
-fix sys_get|setpriority() semantics fix (Ingo Molnar) [162731]
-nfs: fix potential client oops when debugging is on (Steve Dickson) [169197]

* Sun Nov 13 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.17]
-correct wrong CPU frequency in acpi-cpufreq (Geoff Gustafson) [150893]
-add 'noht' boot option to disable hyper-threading (Jim Paradis) [165747]
-i810_audio: re-order release_region calls in i810_probe (John Linville) [165154]
-fixup usb-handoff for hotplug (Kimball Murray) [146859]
-x86_64: make spinlocks work for > 128 cpus (Ingo Molnar) [170711]
-update SCSI whitelist (Tom Coughlan) [167932 160082 170448 172214] 

* Thu Nov 10 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.16]
-pcnet32: fix leak in loopback test (John Linville) [163272]
-bonding: replicate IGMP outbound traffic on inactive slaves (John Linville) [167630]
-fix all-tasks-pinned (Ingo Molnar) [164444]
-forcedeth: update to 0.41 (John Linville) [167927]
-fix SHUTDOWN notification on 1:1 SCTP sockets (Neil Horman) [156785]
-pcnet32: support ethtool set_ringparam (John Linville) [167729]
-scheduler inlines (Geoff Gustafson) [167645]
-noop merge optimizations (Geoff Gustafson) [167645]
-ia64: hint@pause in udelay (Geoff Gustafson) [141699]
-kprobes: scalability enhancements - lockless handler execution (Ananth Mavinakayanahalli) [170747]
-cpu_relax on i386 and x86_64  (Geoff Gustafson) [141851]

* Tue Nov 8 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.15]
-s390: correct wrong swap space offset (Jan Glauber) [171006]
-aio run iocb optimization (Geoff Gustafson) [167645]
-s390: fix kernel internal return values returned to userspace (Jan Glauber) [171374]
-sym53c8xx_2 should only use PPR on LVD bus (Jeff Layton) [139949]
-fix a null pointer dereference in netpoll (Jeff Moyer) [172595]
-Add usb-handoff (Pete Zaitcev) [146859]
-Use ethtool ops in VETH driver and name driver consistently (David Howells) [168129]
-s390: fix cio path retry (Jan Glauber) [171013]

* Fri Nov 4 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.14]
-fix error messages during install, CD-ROM sizing (Pete Zaitcev) [162122 143539]
-fix kobject_register failed for sdb1 (-17) (Pete Zaitcev) [153971 166281]
-hotplug: fix Slot powered off after enabling (Keiichiro Tokunaga) [157241]
-SGI arch 2.6.13 backport (Prarit Bhargava) [158959 168953 168952]
-fix netdump hangs in processing of CPU stop after diskdump failed (Keiichiro Tokunaga) [170427]
-fix diskdump can generate a corrupted dump if dump_level=4 is used (Nobuhiro Tachino) [169522]
-allow renaming of directories located in NFS mounts (Neil Horman) [172081]
-remove i2o_config debug printk (Mike Christie) [169075]
-x86_64 largesmp update (Jim Paradis)

* Thu Nov 3 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.13]
-add ACL support for NFSv3 (Steve Dickson) [151549 158838]

* Wed Nov 2 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.12]
-fix restarts for SCTP associations (Neil Horman) [167907]
-x86_64 reboot fix (Jim Paradis) [166888 168229 171950]
-Fix VFS readahead performance problems for random large IOs (Stephen Tweedie) [167233]
-Fix log_do_checkpoint() assert failures (Stephen Tweedie) [162814]
-Fix ext3 reservations performance problems (Stephen Tweedie) [156437 167231]
-Keys: Remove incorrect obsolete '!' operators (David Howells) [171705]
-s390: fix pfault interrupt race (Jan Glauber) [171008]
-s390: fix ptrace peek and poke problem (Jan Glauber) [171373]
-fix read() with count > 0xffffffff panics kernel (Peter Staubach) [162094] 

* Tue Nov 1 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.11]
-rename hugeproc kernels to largesmp
-e1000: update to version 6.1.16-k2 (John Linville) [165118]
-prevent BUG in prio_tree.c (Larry Woodman) [171778]
-Fix locking bug in xmon (David Howells) [165584]
-Evade hypervisor bug when setting the time during iSeries boot (David Howells) [168535]
-Fix VSCSI client incorrect timeout in tape handling (David Howells) [164851]
-Update qla2xxx driver version to 8.01.02-d2 (Mike Christie) [168544]
-bonding: update docs (John Linville) [166603]

* Mon Oct 31 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.10]
-Improvements for key management facility (David Howells) [171705]
 -add supplementary rights to the mask for processes/threads that possess a key in a keyring
 -export user-defined key type operations
 -move the permissions check function from a .h file into a .c file
 -improve the request-key documentation
 -make possessor permissions additive with normal UID/GID/Other permissions
 -remove the key duplication facility
 -add LSM hooks for key management
 -fix a warning in kmod.c if keys are disabled

* Fri Oct 28 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.9]
-ia64: turn on SCHED_SMT (Geoff Gustafson) [158846]
-Fix AVM B1 ISDN deadlock (David Woodhouse) [158848]
-Fix usb keys (Pete Zaitcev) [160308]
-typhoon: update to version 1.5.7 (John Linville) [167489]
-fix blksectget 32-bit emulation breakage (Alexander Viro) [162906]
-VETH: Reduce verbosity (David Howells) [145557]
-Fix capifs oops (James Morris) [170487]
-x86_64: add missing include/asm-i386/ files (David Woodhouse) [165115]

* Thu Oct 27 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.8]
-ia64: multi-core / multi-thread detection (Geoff Gustafson) [164470]
-NFS/RPC - fix timestamp conversion (Steve Dickson) [165959]
-NFS/RPC - fix PANIC at rpc_wake_up_status (Steve Dickson) [164298 161617]
-fix nfsd oops on module unload/reload (Neil Horman) [165232]
-system accounting can not handle largefiles (Peter Staubach) [165741]
-s2io: update to 2.0.8.1 (John Linville) [167730 170887]
-fix i2o passthrough ioctl return value (Mike Christie) [160546]

* Tue Oct 25 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.7]
-nfsd: clear signals before exiting the nfsd() thread (Steve Dickson) [171715]
-add jasmine digi neo serial driver (Nathan Lynch) [168122 145370]
-Keys: Fix key management syscall interface bugs (David Howells) [165092]
-prevent panic in drop_buffers() (Larry Woodman) [162987]
-bonding: ALB -- allow slave to use bond's MAC address if its own MAC address conflicts (John Linvile) [144477]
-Fix netfilter reference bug in af_packet code (James Morris) [165744]
-ia64: fix __copy_user for unaligned accesses (Neil Horman) [167634]

* Mon Oct 24 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.6]
-fix dangling POSIX locks after close (Peter Staubach) [160844]
-exec-shield updates (Ingo Molnar) [152569]
-ia32 apps that are not large file aware can access files >= 4GB (Peter Staubach) [144703]
-autofs4: fix panic when using bind mounts (Jeff Moyer) [145374]
-fix memory leak with large sendmsg/rcvmsg calls in 32-bit apps (Jeff Layton) [169875]
-fix packet corruption in ip_conntrack_amanda (Jeff Layton) [152036]
-kNFSd/RPC - umount fails on nfs server side when nfs client does heavy io (Steve Dickson) [154387]
-fix TUX/ftp crash (Ingo Molnar) [172598]

* Fri Oct 21 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.5]
-create 'hugeproc' kernels: 512 cpus for ia64, 128 ppc64, 64 x86_64 (David Howells) [143166]
-IPv6 address addition error handling fix (David Howells) [164547]

* Wed Oct 19 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.4]
-orinoco: plug etherleak (John Linville) [170277] {CAN-2005-3180}
-fix sys_set_mempolicy() bounds check (Larry Woodman) [168993] {CAN-2005-3053}
-fix race in ebtables (James Morris) [170268] {CAN-2005-3110}
-fix memory leak in key management (David Howells) [170274] {CAN-2005-3119}
-fix names_cache memory leak (David Woodhouse) [170283] {CAN-2005-3181}
-nfs: add missing unlock_kernel() (Larry Woodman) [170546]
-fix gzip/zlib flaws (Peter Staubach) [165679] {CAN-2005-2458}

* Tue Oct 11 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.3]
-veth: iSeries veth driver fixes (David Howells) [145557 157935]
-Fix kallsyms vs insmod/rmmod race (David Howells) [145719]
-net: Disable queueing when carrier is lost (John Linville) [165018 167115]
-sys_get_thread_area has minor info leak (Larry Woodman) [168777] {CVE-2005-3276}
-fix false ECHILD result from wait (Dave Anderson) [166454 168775]
-Add EINVAL to sys_io_cancel (Wendy Cheng) [162732]
-x86_64: iounmap fix [168217 160135 170264] {CAN-2005-3108 }
-x86_64: add pageattr text mapping (Jim Paradis) [170154]

* Thu Oct 6 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.2]
-fix NX text/large-page interaction [163238 168936]
-Allow ICMP response source address configurable (David Miller) [164571]
-fix oops in sysfs_remove_dir() (Pete Zaitcev) [161597]
-fix ip_queue crash (James Morris)
-bindresvport: Address already in use (Steve Dickson) [169042]
-fix usb memory sticks, kabi fixes. (Pete Zaitcev) [167032]
-Fix cpu sibling count with buggy BIOS on i686 (Eric Paris) [169472]
-fix disassociate_ctty() vs. fork() race [165835]

* Mon Sep 26 2005 Jason Baron <jbaron@redhat.com> [2.6.9-22.1]
-remove: fix for NX text/large-page interaction (Ingo Molnar) [163238]
-update hangcheck-timer to 0.9.0 and add for ia64, ppc64 and s390 [167731]
-fix usb memory sticks (Pete Zaitcev) [167032]

* Mon Sep 19 2005 Jason Baron <jbaron@redhat.com> [2.6.9-21.1 2.6.9-22]
-fixup pmtimer 

* Thu Sep 15 2005 Jason Baron <jbaron@redhat.com> [2.6.9-21]
-add pmtimer for x8664 (Brian Maly) [167006]

* Tue Sep 13 2005 Jason Baron <jbaron@redhat.com> [2.6.9-20]
-azx: allow mono output to be un-muted (John Linville) [167038]

* Mon Sep 12 2005 Jason Baron <jbaron@redhat.com> [2.6.9-19]
-Fix multithread crash in exec dethread (David Howells) [167668]

* Fri Sep 9 2005 Jason Baron <jbaron@redhat.com> [2.6.9-18]
-fixup 4/4 split userspace bounds (Ingo Molnar) [167262]
-fix Netfilter NAT memory corruption udp (David Miller) [164450]
-Fix compat layer sendmsg() races (Alexander Viro, Dave Miller, David Woodhouse) [166248] {CAN-2005-2490}
-Enable 32-bit kernel to boot on dualcore xw9300 (Jim Paradis) [166212]
-Fix raw_sendmsg accesses (Alexander Viro) [166830] {CAN-2005-2492}
-update OpenIPMI version number to 33.4 (Peter Martuccelli) [166861] 
-dual-core detection gap for i386 (Geoff Gustafson) [167412]
-turn debugging off in powernow-k8 (Brian Maly) [167711]
-make sys_sigreturn() call audit (David Woodhouse) [166287]
-Fix module verification size check (David Howells) [167126]
-fix for pfn_valid() on x86_64 (Jim Paradis) [166785]
-Fix kernel crash/hang when task functions and isrs are kprobed in conjunction (Ananth Mavinakayanahalli) [167225]
-Fixup eip/rip on IA32/x86_64 during kprobe smp miss handling (Ananth Mavinakayanahalli) [167226]
-fix oops when loading ipmi_si module (Brian Maly) [166781]
-Identify and handle IA64 page_not_present fault in vmalloc/region-5 address space (Larry Woodman) [164823]
-ppc64: iommu entry merge fix (David Howells) [166653]
-fix ipt_recent integer handling (James Morris) [167703] {CAN-2005-2872}

* Fri Aug 26 2005 Jason Baron <jbaron@redhat.com> [2.6.9-17]
-require CAP_NET_ADMIN when creating policies (John Linville) [166131]
-cciss PCI ID additions (Tom Coughlan) [165762]

* Tue Aug 23 2005 Jason Baron <jbaron@redhat.com> [2.6.9-16.1]
-x86_64: fix morrison dual core numa support (Jim Paradis) [160230]
-fixup 4/4 split userspace bounds (Ingo Molnar)

* Mon Aug 15 2005 Jason Baron <jbaron@redhat.com> [2.6.9-16]
-make sure loopback is available for ipv6 (David Miller) [165669]
-device-mapper: fix read balancing (Jonathan Brassow) [165717]

* Mon Aug 15 2005 Jason Baron <jbaron@redhat.com> [2.6.9-15.2]
-device-mapper: make rh_inc and rh-dec atomic (Jonathan Brassow) [164630]
 
* Fri Aug 12 2005 Jason Baron <jbaron@redhat.com> [2.6.9-15.1]
-powernow-k8 cleanups (Brian Maly) [160011]
-fix x86_64 crash in csum_partial_copy_generic (Wendy Cheng) [164483]
-device-mapper multipath: Reinstate ability to set queue_if_no_path (Alasdair Kergon) [164822]
-fix audit emits superfluous records (David Woodhouse) [165362]
-device-mapper mirroring, properly handle -EWOULDBLOCK (Jonathan Brassow) [165242]
-Handle NUMA-config case w/missing SRAT (Jim Paradis) [159983]
-openipmi cleanups (Peter Martuccelli) [165731 165490 165466]

* Fri Aug 5 2005 Jason Baron <jbaron@redhat.com> [2.6.9-15]
-fix kabi with respect to Intel dual-core support
-add audit_panic() call when out of memory (David Woodhouse)

* Fri Aug 5 2005 Jason Baron <jbaron@redhat.com> [2.6.9-12.2 2.6.9-14]
-fix kabi with respect to Intel dual-core support (Jim Paradis) [158070]
-nfs: Retry lookups after ESTALES (Steve Dickson) [164173] 
-add HP xw9300 DMI quirk to 32-bit (Jim Paradis) [146481]
-fix acpi_processor_get_performance_states fails on empty table entries (Brian Maly) [165127]
-update emulex lpfc to version 8.0.16.17 (Tom Coughlan) 

* Thu Aug 4 2005 Jason Baron <jbaron@redhat.com> [2.6.9-12.1]
-enable NUMA on dual-core x86_64 (Jim Paradis) [158074]
-device-mapper mirroring - race condition fix (Jonathan Brassow) [164630]
-Prevent key session join from hanging in D state (David Howells) [164979]
-NFSv3 over Kerberos: gss_get_mic FAILED during xdm login attempt (Steve Dickson) [147233]
-__bio_clone fix idx copy (Jonathan Brassow) [164696]
-kNFSD: fixed '-p port' arg to rpc.nfsd and enables the defining prot (Steve Dickson) [154533]
-audit speedups (David Woodhouse) [165163]

* Tue Aug 2 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.43 2.6.9-12]
-fix IBM x236 for SHPC hotplugging (Brian Maly) [147831]
-s390: crypto driver: add CEX2C and zero pad support (Jan Glauber) [163933]
-change powernow-k8 to version 1.39.04 (Brian Maly) [158844]
-additional x86_64 HPET fixes for (Brian Maly)
-fix memset in ipw2100 driver (Dave Jones)
-update Intel dual core support (Jim Paradis) [158070]

* Mon Aug 1 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.42]
-x86_64 reboot fix (Dave Anderson) [144668]
-Intel dual-core support (Jim Paradis) [158070]
-Fix PCI BAR size interpretation on 64-bit arches (Nathan Lynch) [162734]

* Fri Jul 29 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.41]
-fix "nfs bindresvport: Address already in use" messages for mounting (Steve Dickson) [141773]
-enable CONFIG_QETH_IPV6 (Jan Glauber) [158778]
-esb2 chipset support (Geoff Gustafson) [158849]
-IBM active PCI support (Peter Martuccelli) [142504]
-SATA update (Jeff Garzik) [164094]
-Fix for HP xw9300 "acpi=off" issue (Jim Paradis) [162190]
-allow a task with signals outstanding to be OOM killed (Larry Woodman) [158980]
-fix ip6_queue deadlock (David Miller) 
-fix Netfilter NAT memory corruption (David Miller)
-Do not load IDE driver on ServerWorks CSB6 chipsets (Tom Coughlan) [137343]
-fix socket filters issue (David Miller) [164450]
-fix IPSEC socket array overflow (David Miller) [165560]
-Handle failed keyring destructio (David Howells) [130914]
-pci_scan_device causes master abort (Kimball Murray) [164628]
-Driver update for OpenIPMI (Peter Martuccelli) [138592 155344 158792]
-powernow-k8 support (Jim Paradis) [158844]

* Thu Jul 28 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.39]
-improve exec-shield coverage (Ingo Molnar) [160812 161136]
-Fix rmmod hang in the iSeries veth driver (David Howells) [157935]
-pci: fix sysfs access to config space (John Linville) [145646]
-ipw2100: update to version 1.1.0 (John Linville) [158775]
-CAN-2005-0756 x86_64 crash (ptrace-check-segment) (Peter Staubach) [159918]
-CAN-2005-1763 x86_64 crash (x86_64-ptrace-overflow) (Peter Staubach) [159921]
-ia64: cache coherency fixes for Montecito (Geoff Gustafson) [152098]
-no legacy time HPET fixes (Brian Maly) [158676]
-ht active load balancing bugfix (Ingo Molnar)
-nfs: intr flag prevents core dump (Steve Dickson)

* Wed Jul 27 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.38]
-fix sg oops (Wendy Cheng) [159937]
-fix kernel BUG at tcp_output (David Miller) [150044]
-fix 4/4 split userspace bounds (Ingo Molnar)
-fix oops when removing symbolic link on tmpfs (Yuichi Nagahama) [158956]
-Only access extended PCI config regs if available (David Howells) [158837]
-VIOCD driver clean up patch (David Howells) [141958]
-add /proc parameter to disable the OOM killer (Larry Woodman) [162238]
-fix ide-scsi oops when highmem buffers in use (Doug Ledford) [149979]
-fix NX text/large-page interaction (Ingo Molnar) [163238]
-Update Emulex lpfc driver to 8.0.16.11 (Tom Coughlan) [158789]
-Update megaraid_mbox driver (Tom Coughlan) [158824]
-allow ACLs to expand to extended attributes limits (Peter Staubach) [161642]

* Tue Jul 26 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.37]
-fix aio hang when reading beyond EOF (Jeff Moyer) [164338]
-File system auditing support (David Woodhouse)
-device-mapper: Event required on device removal (Alasdair Kergon) [144618]
-device-mapper: mirroring support (Jonathan Brassow) [116817 116819]
-SGI console driver interrupt fix (Prarit Bhargava)

* Mon Jul 25 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.35]
-fix for prune_icache()/forced final iput() races (Alexander Viro) [145405]
-Update Qlogic driver to 8.01.00b5-rh2 (Tom Coughlan) [138698]
-s390: system hangs when cable pull on zfcp tape (Jan Glauber) [163087]
-Export sys_recvmesg for cluster snapshot (Daniel Phillips) [164228]
-fix ppc64 signal frame with 32 bit emulation (Wendy Cheng) [163719]
-cciss update to 2.6.6 (Tom Coughlan) [159028]
-scsi tape fixes (Tom Coughlan) [155354]
-i20 fixes (Mike Christie) [158883 160882 155894 155894]

* Fri Jul 22 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.34]
-fix sporadic NFS ENOENT on ext3 with htree (Stephen Tweedie) [158293]
-fix ext2/3 xattr sharing bug (Stephen Tweedie) [155706] {CAN-2005-2801}
-fix sub-second timestamp granlurity on ext2/3 (Stephen Tweedie) [145976]
-fix O_SYNC error reporting (Stephen Tweedie) [149478]
-backport current HD audio sources (John Linville) [162610]
-ia64: perfmon update [136474, 154100]
-rmp3 console support [151495]
-ia64: identify sx2000 iommu chip [158850]
-ia64: fix sigprocmask() race [160345]
-fix tcsendbreak in compat mode [135669]

* Wed Jul 20 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.33]
-Dirty page tracking for HA systems (Kimball Murray) [160006]
-update dasd and cio drivers (Jan Glauber) [159910]
-fix ide tape transform deficiency (Doug Ledford) [147496]
-Make "mt -f /dev/st0 tell" work again (Doug Ledford) [161156]
-audit: Fix livelock in audit_serial (David Woodhouse)
-audit: Don't sleep in idle thread (David Woodhouse)
-whitelist NEC iStorage to properly configure its LUNs (Doug Ledford) [145512]

* Tue Jul 19 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.32]
-fix tty locking to allow non-blocking opens during blocking opens [161314]

* Mon Jul 18 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.31]
-update IPR driver to 2.0.11.1 (David Howells) [158072]
-fix jdb kjournald unmount race (Stephen Tweedie) [162728]
-enable /proc/dasd/statistics (Jan Glauber) [163082]
-increase NR_KEYS to 256 (Alan Cox) [158954]
-export kallsyms_lookup_name (Ananth Mavinakayanahalli) [157239]
-Fix POSIX_FADV_{DONTNEED,NOREUSE} for s390-64 (Ulrich Drepper)
-ia64: fix ia64 kprobe removal race (Ananth Mavinakayanahalli) [157239]
-enable CONFIG_MTD_ICHXROM to allow Intel BIOS motherboard flashes (Pete Zaitcev) [158831]
-s390: qeth fix empty if_name in sysfs (Jan Glauber) [163095]
-ia64: fix kabi breakage in mmiowb patch (Prarit Bhargava)  [161201]
-make auditd checks multi-thread aware (David Woodhouse) [158794]

* Thu Jul 14 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.30]
-set of device mapper changes: (Alasdair G Kergon)
 -fix dm_swap_table error cases
 -device-mapper multipath: Use private workqueue [154432]
 -device-mapper dm-emc: Fix a memset [154435]
 -device-mapper multipath: Flush workqueue when destroying [156412]
 -dm-raid1: Limit bios to size of mirror region
 -device-mapper snapshots: Handle origin extension
 -device-mapper dm.c - set of locking fixes [156569]
 -device-mapper multipath: Clean up presuspend hook
 -device-mapper multipath: Not every error is EIO [155427 151324]
 -device-mapper multipath: Fix pg initialisation races [154442]
 -device-mapper multipath: Default to SCSI error handler

* Wed Jul 13 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.29]
-prevent Citrine chipset's SCSI controller from accessing config register 0xA0 (David Howells) [158836]
-initialize wchan to ~0UL for multithread /proc entries (Ingo Molnar)
-upgrade ibmvscsi driver to 1.5.5 (David Howells) [146674]
-fix direct write vs truncate deadlock for out of tree filesystem (Prarit Bhargava) [160383]
-2.6.12 arch/ia64/sn update (Prarit Bhargava)
-Fix 32-bit BLKGETSIZE compatibility ioctl (Stephen Tweedie) [158930]
-fix sysctl interfaces for lockd on 64-bit platforms (Steve Dickson) [159640]

* Tue Jul 12 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.28]
-change next_tick of 3c59x.c from 60*HZ to 10*HZ
-diskdump: add partial diskdumps
-diskdump: allow diskdump to swap devices (#156010)
-make smbfs honor uid and gid mount options (#157402)
-s390: correctly read memory size (#162508)
-fix diskdump hang on ia64/mptfusion (#162213)
-observe O_SYNC semantics on block devices (#159765)
-don't mmap a page at addr 0, unless MAP_FIXED is specified (#158878)

* Mon Jul 11 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.27]
-add mmiowb, only implemented on ia64, and used by tg3 driver (#161201)
-kprobes for ia64 (#157239)
-Calculate keyring payload size properly
-fix ia64 ptrace vulnerability CAN-2005-1761 (#159671)
-export iucv_send2way_* symbols (#162761)

* Thu Jul 7 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.26]
-add relayfs for use by systemtap (#157239)
-update s390 zfcp driver
-fix buffer overflow in selinux_sb_copy_data (#162196)
-add support for Intel cpuid(4) (#158843)
-increase range of reserved ports (#141773)
-export generic_drop_inode (#161143)

* Wed Jul 6 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.25]
-upstream kprobes merge: (#157239)
  -update kprobes infrastructure (x64, x86_64, ppc64)
  -allow one jprobe to coexist with other kprobes at a given address
  -transparent handling of re-entrant kprobes
  -support probes on return addresses to trace function return values 

* Tue Jul 5 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.24]
-set of audit updates:
  -call audit_log() correctly from selinux_nlmsg_perm()
  -ensure auditd can't be OOM killed
  -convert KERN_ERR to KERN_NOTICE
  -set maximum time-out for audit callers and fix apparent hang condition
  -use pid value from task_struct instead of audit_context

* Fri Jul 1 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.23]
-make use of irqstacks on x86

* Thu Jun 30 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.22]
-make sctp honor SO_BINDTODEVICE option (#145659)
-provide PCI EEH error recovery documentation (#161554)
-change Serverwork IDE __init functions to __devinit for hotplug (#159739)
-drop __initdata tag from qla1280 driver setup for hotplug (#160535)
-fix GET_INDEX macro to use lower 3 bits of devfn (#161789)
-change permissions on sys/net/ipv[4,6]/route/flush to write only (#157725)
-prevent list corruption in ip_vs_conn_flush (#161947)
-fix memory leaks - mount,selinux_sb_copy_data (#161390) 

* Tue Jun 28 2005 David Woodhouse <dwmw2@redhat.com> [2.6.9-11.21]
-Audit merge from upstream (#158794)
-netlink hang fixes (#157963)

* Fri Jun 24 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.20]
-add key management code (#130914)
-make sure ACM driver interacts with line discipline properly (#147490)

* Wed Jun 22 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.16]
-release resources upon controller timeout (#155198, #145645)
-make qeth driver pick proper eui64 values (#158778)
-improve support for alc260 codec (#158332)
-set b44 link status properly during open (#160662)
-ia64: properly map gate pages (#155278)
-make sure ipv6 doesn't leak routes when brought down (#160010)

* Tue Jun 21 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.15]
-add iscsi-sfnet driver (#107089)

* Thu Jun 16 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.14]
-ppc64: set pci iobase dynamically (#155198)
-ppc64: skip ioports requests if no legacy ISA devices (#155198)
-ppc64: allow eeh to be dynamically loaded (#155198)
-make change_page_attr a symmetric api (#160028, #160135, #151315, #151323)
-s390: fix qeth network stalls and update (#142112)
-propogate specific bounce io errors on i/o completion (#149919)
-s390: fix pagefault deadlock (#159909)
-call __scsi_done in the SDEV_DEL state, since no timer has been added (#160548, #160547)

* Wed Jun 15 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.12]
-enable sctp to honour IP_FREEBIND option/ip_nonlocal_bind sysctl (#145648)
-update bonding.txt (#158841)
-bounce page accouting (#158636)
-adjust baud rate for serial ns16550a (#156705, #158107)

* Mon Jun 13 2005 Jason Baron <jbaron@redhat.com> [2.6.9-11.11]
- make up_read, up_write safe to call from interrupt context
- ia64: tollhouse support, map sn error codes to Linux error codes (#156206)
- ia64: tollhouse support, update pci topology (#156206)
- ia64: tollhouse support, fix infinite loop (#156206)
- ia64: tollhouse support, add geoid information (#156206)
- ia64: tollhouse support, update headers (#156206)

* Thu Jun  9 2005 Dave Jones <davej@redhat.com> [2.6.9-11.10]
- x86_64: ptrace can induce double-fault (CAN-2005-1762) (#154451)
- More md fixes.
  - Fix resync checkpoint at end of array cornercase.
  - Don't try to set a disk faulty if it's not in an active array.
- Make SELinux allow unknown netlink message types. (#155480,IT#69501) 
- Fix possible bonding with arp_ip_target failover failure. (#157576)
- diskdump: hangs when SCSI drive is busy. (#155932)
- ppc64: avoid probing pci devices marked as failed (#159391)
- Implement module signing blacklist. (#146654)
  | This works around the problem with loading the bonding driver twice.
- Fix call to ipv6_skip_exthdr with an incorrect length argument. (IT#71394)

* Thu Jun  9 2005 Dave Jones <davej@redhat.com> [2.6.9-11.9]
- Various md layer thinkos.
  - Incorrect loop indexing in v1 superblock handling.
  - Incorrect struct size allocated in raid1_reshape()
  - Off by one error in super_1_sync()
  - Missing recalculation of checksum in super_1_sync()
- Numerous ioremap() fixes. (#151315,#152429,IT69258)
  - Call change_page_attr correctly.
  - Fix a race during iounmap.
  - Handle mmio holes without mem_map correctly. 
  - Some cleanups.
  - Fix off by one.
- Fix buffer leak in EXT3.

* Thu Jun  9 2005 Dave Jones <davej@redhat.com> [2.6.9-11.8]
- x86: use the IRQ stack in APIC contexts too. (#151222)
- ppc64: Tell the firmware what the kernels capabilities are. (#145739)
- diskdump: signature check fails with large block_order. (#154926)
- Add DDN S2A devices to SCSI sparse LUNs blacklist. (IT#72769)
- Fix oops in keyring lookup for module insert (#158974, #156640)
- Make SELinux honor the ATTR_FORCE flag. (#160112, IT#68393)

* Wed Jun  8 2005 Dave Jones <davej@redhat.com> [2.6.9-11.7]
- Disable CONFIG_DEBUG_PAGEALLOC

* Wed Jun  8 2005 Dave Jones <davej@redhat.com> [2.6.9-11.6]
- Fix SELinux memory leak on error path of loading invalid policy.
- ppc64: Implement correct logic for determining hotplug capabilities. (#146059)
- Fix IPSEC output spinlock deadlock. (#154347)
- Remove ip_conntrack proc files on module removal. (#154733)
- NFSv4 callback authentication. (#150152)
- Add 32-bit compat for NFS4 mount syscall. (#152982)

* Tue Jun  7 2005 Dave Jones <davej@redhat.com> [2.6.9-11.5]
- Audit layer updates.
  - print return code correctly, specify error to netlink_ack() correctly.
  - Capabilities for audit control
  - audit congestion
  - clean up audit_log_lost() messages
  - Add /proc/$pid/loginuid
  - fix ppc64 syscall auditing
  - don't mask top bits of inode number
  - fix netlink reply misdirection
  - fix and improve inode audit records
  - CAPP-required auditing on SysV IPC objects

* Tue Jun  7 2005 Dave Jones <davej@redhat.com> [2.6.9-11.4]
- snmp6: avoid crash on dev shutdown.
- Add ability to clear setting in /proc/self/attr.
- SCSI Fix oops with faulty DVD
- Update E1000 driver to rev 6.0.54-k2 (#157533)
- SELinux: Fix ability to mount partition with bad root context even
  with enforcing off.
- Send IGMP traffic out only "active" link of bond+in ALB or TLB mode. (#145551)
- fix driver name in dl2k as returned by ETHTOOL_GDRVINFO

* Fri Jun  3 2005 Dave Jones <davej@redhat.com> [2.6.9-11.3]
- rebuild.

* Thu Jun  2 2005 Dave Jones <davej@redhat.com> [2.6.9-11.2]
- Add NOGET quirk for Chicony keyboards to usb input layer. (#146187)
- Fix bogus level check in md resync code.
- prevent OOM kills caused by lowmem exhaustion from wired page tables. (IT69919)
- ppc64: Fix a dangling pointer in the IBM vscsi driver.
- Fix panic in acpi_pci_root_add() (#158920)
- Re-add 1620 byte slabcache. (Can't remove due to kabi).
- vm: Prevent incrementing pte off end of kmap'd virtual page. (#158533)

* Thu Jun  2 2005 Dave Jones <davej@redhat.com> [2.6.9-11.1]
- U2 begin.
- Various network driver updates.
  - Update ixgb driver to upstream 2.6.11. (IT60082,IT68009)
  - Update E1000 driver to rev 5.7.6-k2 from upstream. (#149677)
  - Fix bounce buffer allocation in b44 driver. (#134790)
  - backport 3c59x driver from 2.6.12-rc2 (enhanced ethtool support)
  - Update tg3 to 3.27 (support xw4300) (#157900)
  - Update e100 driver to version 3.4.8. (#157887)
- Update mpt fusion driver, include SAS support. (FZ107088)
- ppc64: Move clearing of RI bit to after stack restoration. (IT69221)
- SELinux fixes.
  - Fix case where invalid SELinux policy can still update
    policydb_loaded_version resulting in invalid or cleared policy.
  - Fix possible null dereference on kmalloc() failure path. (#155245)
- SATA AHCI fixes. (Fix reset on error, ATA taskfile register
  reading, (and fixes a misleading error message).
- Increase i2o_block timeout, fixing installs with Adaptec 2400A (#140002)
- Remove the 1620 byte slab cache.
- Sysrq enhancements. (alt-sysrq-w & serial console sysrq).
- Support two new PCI IDs in ALSA VX222 driver. (IT #70160)
- Fix statistic accounting in do_task_stat(). (#152430)

* Fri May 13 2005 Dave Jones <davej@redhat.com> [2.6.9-11]
- Fix numa=off on x86-64

* Thu May 12 2005 Dave Jones <davej@redhat.com> [2.6.9-10]
- Further fixing for the nVidia network controller problem.
- Fix wait_task_inactive() race. (#157424) 

* Wed May 11 2005 Dave Jones <davej@redhat.com> [2.6.9-9]
- Fix data corruptor/local root in raw driver. (CAN-2005-1264)
- Fix ELF core dump privilege elevation. (CAN-2005-1263) (#157450)
- Avoid avc denial deadlock. (#154879)
- Don't map objects to non-existent PPC64 NUMA nodes. (#149132)
- Fix PPC64 NUMA's handling of memory nodes with holes in them.

* Mon May  9 2005 Dave Jones <davej@redhat.com> [2.6.9-8]
- Fix ABI regression in IA64 ptrace fix.
- Some nVidia network controllers show up as bridges. (#157240)
- Fix SATA issue when master supports LBA48 but slave doesn't. (#156875)

* Tue May  3 2005 Dave Jones <davej@redhat.com> [2.6.9-7]
- Rebuild.

* Tue May  3 2005 Dave Jones <davej@redhat.com> [2.6.9-6.47]
- Re-add E1000 MODULE_VERSION that got lost.

* Mon May  2 2005 Dave Jones <davej@redhat.com> [2.6.9-6.46]
- Fix regression with TEAC CD-210PU USB CD-ROM.  (#155870)
- Don't mess with IRQs when doing BogoMIPS calculation.

* Mon May  2 2005 Dave Jones <davej@redhat.com> [2.6.9-6.45]
- Fix possible crashme induced panic in page-fault handler on x86-64.

* Sat Apr 30 2005 Dave Jones <davej@redhat.com> [2.6.9-6.44]
- Fix sctp sendbuffer accounting. (#146797)

* Sat Apr 30 2005 Dave Jones <davej@redhat.com> [2.6.9-6.43]
- CAN-2005-0136 ptrace corner cases on ia64. (#155283)
- Redo fix to avoid sleep in timer context in E1000. (#154880,#154944,#154951)

* Wed Apr 27 2005 Dave Jones <davej@redhat.com> [2.6.9-6.42]
- Fix oopsable locking in NFS. (#152557)
- Fix incorrect use of memset/memcpy in ia64 ia32 signal handling.
- Cope with faults in iret/exec-shield bug (#154221, #154972)
- Potential NULL mm in swap token code. (#154639)

* Wed Apr 27 2005 Dave Jones <davej@redhat.com> [2.6.9-6.41]
- Fix up tty locking. (#152600, #155765)

* Fri Apr 22 2005 Dave Jones <davej@redhat.com> [2.6.9-6.40]
- Update the PCI EEH error recovery patch.

* Thu Apr 14 2005 Dave Jones <davej@redhat.com> [2.6.9-6.39]
- ata_piix: broken BIOS AHCI BAR setup work-around. (#154712)

* Wed Apr 13 2005 Dave Jones <davej@redhat.com> [2.6.9-6.38]
- Fix possible corruption in mmap over NFS. (#151284)
- Don't cache /proc/pid dentry for dead processes. (#147832)
- Add Itanium ZX2 chipset identification (#150110)
- Don't enable NUMA by default on dual core systems.

* Wed Mar 30 2005 Dave Jones <davej@redhat.com>
- Really apply patch for PCI EEH error recovery on ppc64.

* Mon Mar 28 2005 Dave Jones <davej@redhat.com> [2.6.9-6.37]
- Dual core support for AMD64.

* Mon Mar 28 2005 Dave Jones <davej@redhat.com> [2.6.9-6.36]
- Fix IP output route leak. (CAN-2005-0209)
- Fix oops when mounting Solaris NFSv4 volumes. (#152102)
- /proc/net/route stale pointer OOPS fix.

* Sun Mar 27 2005 Dave Jones <davej@redhat.com> [2.6.9-6.35]
- Additional fix for CAN-2005-0815

* Thu Mar 24 2005 Dave Jones <davej@redhat.com> [2.6.9-6.34]
- Fix potential DoS in ELF loader. (CAN-2005-0749)
- md: fix multipath assembly bug.
- diskdump cannot I/O on megaraid when the tasklet is in use (#151325)
- megaraid_diskdump_sleep actually sleeps for specified timeout (#151517)
- Fix information leak in ext2. (CAN-2005-0400)
- Further fixes to TCP BIC congestion handling.
- Add missing range checking in bluetooth. (CAN-2005-0750)
- Fix emulex lpfc driver LUN reset.
- Fix missing variable initialisation in clustered APIC code.

* Thu Mar 24 2005 Dave Jones <davej@redhat.com> [2.6.9-6.33]
- Keep fragment queues private to each user.

* Thu Mar 24 2005 Dave Jones <davej@redhat.com> [2.6.9-6.32]
- Improve scanning in try_to_free_pages(). (#147832)

* Tue Mar 22 2005 Dave Jones <davej@redhat.com> [2.6.9-6.31]
- NFS setclient improvements.
- lockd callback improvements.

* Mon Mar 21 2005 Dave Jones <davej@redhat.com> [2.6.9-6.30]
- ia64 unwind stack DOS. (CAN-2005-0135).
- Fix various ISO9660 handling flaws. (CAN-2005-0815)
- Fix swapped memset arguments in ieee802.11 code.
- e1000: avoid sleep in timer context.
- e1000: flush workqueues on remove.

* Mon Mar 21 2005 Dave Jones <davej@redhat.com> [2.6.9-6.29]
- Clustered APIC support for x86-64.

* Wed Mar 16 2005 Dave Jones <davej@redhat.com> [2.6.9-6.28]
- Fix IPSEC SA sequence collision. (#145424)
- Add missing crashdump_mode() check in x86_64 reboot code. (#151101)
- Update Emulex lpfc driver to 8.0.16.6

* Tue Mar 15 2005 Dave Jones <davej@redhat.com> [2.6.9-6.27]
- epoll: return proper error on overflow condition
- Fix up might_sleep warnings in previous futex deadlock fix.
- sctp: add receive buffer accounting to protocol.

* Tue Mar 15 2005 Dave Jones <davej@redhat.com> [2.6.9-6.26]
- Fix DMA zone exhaustion problems. (#142465)
- Fix IP fragment corruption. (#149589)
- CAN-2005-0384: Remote DoS on ppp. (#151240)

* Thu Mar 10 2005 Dave Jones <davej@redhat.com> [2.6.9-6.26]
- Add more diagnostic info to alt-sysrq-M.

* Tue Mar  8 2005 Dave Jones <davej@redhat.com> [2.6.9-6.25]
- shrink_cache() tweak to match upstream. (#147832)

* Sun Mar  6 2005 Dave Jones <davej@redhat.com> [2.6.9-6.24]
- Further fixing to the previous drm fix.

* Sat Mar  5 2005 Dave Jones <davej@redhat.com> [2.6.9-6.23]
- drm: fix race condition in radeon driver. (#149693)

* Sat Mar  5 2005 Dave Jones <davej@redhat.com> [2.6.9-6.22]
- Various cleanup of several patches (S390 common io fixes, Emulex update).
- Update megaraid driver. (#144810, #144902, #142539)
- Fix leak in error path in autofs.
- Fix release race in ext3. (#147443, #146037)

* Fri Mar  4 2005 Dave Jones <davej@redhat.com> [2.6.9-6.21]
- test

* Thu Mar  3 2005 Dave Jones <davej@redhat.com> [2.6.9-6.20]
- avoid a bdget in device mapper.
- IBM veth driver buffer starvation fix. (#147364)
- raid5/raid6 bi_max_vec fixes.
- Fix possible futex mmap_sem deadlock.
- Update Emulex lpfc driver to 8.0.16.3

* Thu Mar  3 2005 Dave Jones <davej@redhat.com> [2.6.9-6.19]
- Show extra debug info on page allocation failure.

* Thu Mar  3 2005 Dave Jones <davej@redhat.com> [2.6.9-6.18]
- Silence some cpufreq warnings. (#141983)
- Fix VESAFB probe error. (#142929)
- Add support for a bunch of Dell serial cards. (#146217)

* Wed Mar  2 2005 Dave Jones <davej@redhat.com> [2.6.9-6.17]
- s390: Fix for various problems in common i/o layer. (#133992)
- s390: common i/o layer vary on/off.
- s390: qdio time delay missing interrupt problem. (#145150)
- x86-64: Fix syscall/signal restart bug.
- Various size_t fixes. (CAN-2005-0531)
- ppc64: Fix race and memory leak in iSeries veth module unloading. (#144966)
- ppc64: Prevent an iSeries partition oopsing with no CDROM drive. (#146809)
- NFS: Fix O_DIRECT oops with oversized requests. (#148878)
- Only root should be able to set the N_MOUSE line discipline. (CAN-2005-0839)
- Fix tmpfs truncate BUG().
- Fix signedness issue in sysfs. (CAN-2005-0867)
- Remove Samsung SN-124 CD-ROM on DMA Blacklist. (#142937)
- Remainder of the previous diskdump deadlock fix. (#142167)

* Wed Mar  2 2005 Dave Jones <davej@redhat.com> [2.6.9-6.16]
- x86-64: Fix flush of multiple pages in change_page_attr
- Fix 64 bit issues in device mapper.
- dm multipath: fix infinite suspend requeueing

* Wed Mar  2 2005 Dave Jones <davej@redhat.com> [2.6.9-6.15]
- dm multipath: export mapinfo
- s390: qeth fake_ll fixes. (#136175)
- s390: delay dasd retries to prevent i/o error (#145115)
- s390: qdio didnt retry under some busy conditions. (#145116)
- Fix the mincore syscall's error handling. (#140523)
- ia64: wire up sys_waitid. (#137154)

* Tue Mar  1 2005 Dave Jones <davej@redhat.com>
- Don't probe last sector of a gpt partitioned disk. (#138563)

* Tue Mar  1 2005 Dave Jones <davej@redhat.com> [2.6.9-6.14]
- Additional fix for the earlier ACPI SRAT work.
- Fix possible diskdump deadlock (#142167)
- Intel HD audio support. (#146068, #146216)
- x86-64 huge pages fix. (#143472)
- device-mapper: Add dm_dev.name
- dm multipath: bio details record/restore.
- 802.11b/ipw2100/ipw2200 update. (#146763)

* Sat Feb 26 2005 Dave Jones <davej@redhat.com> [2.6.9-6.13]
- Put right the previous fix to scsi_disk_put() which was incorrect.
- Stop xmon=on from jumping immediately into xmon on ppc64. (#140751)
- reworked s390 dasd fixed buffers. (#134338)
- Fix oops in tg3_poll when using netconsole. (#143223)
- diskdump: remove "device has no block attribute" warning. (#146144)
- device-mapper: tidy error kprintfs
- ACPI reset support for x86. (#139104)
- Fix ia64 rx1600 pdh console. (#146274)
- Discover x86-64 NUMA topology through ACPI SRAT table.
- Silence additional deprecated SG_IO warning.
- Fix incorrect hw segment counting in qla2x00 drivers. (#140472)
- E100: fix state machine handling w/ NAPI (#140082)
- E100: Add PCI IDs for ICH7. (#146137)
- AHCI SATA fixes.
- Remove unused 'commit' parameter from aacraid. (#140780)

* Fri Feb 25 2005 Dave Jones <davej@redhat.com>
- avoid panic in e100_tx_timeout on ppc64. (#140116)
- sk98lin: add MODULE_DEVICE_TABLE entry
- Allow usb-storage to be reloaded. (#129165)
- diskdump support for megaraid. (#142736)
- ia64: Work around DMA timeouts on SGI IOC4 IDE. (#144265)
- sk_forward_alloc() BUG assertion fix. (#139430)
- Various ptrace fixes. (#143073,#146089,#132849,#133590,#140083,#147575)
- diskdump: add module parameter to disable WCE. (#146412)
- Clean up last remnants of kexec.
- TCP BIC bug fix
- Fix panic() w/panic_timeout hangs instead of rebooting. (#144668)
- Set panic_on_oops=1 by default. (#144657, #143993)
- tg3: update + support BCM5752. (#145105)
- Fix ext2/3 maximum size limits. (#143907)
- Fix shmget for ppc64, s390(64).
- dm raid1: deadlock fix.
- Implement h/w PPC64 CPU utilisation data gathering. (#144862)

* Thu Feb 24 2005 Dave Jones <davej@redhat.com>
- Remove non-working kexec functionality.
- bonding: avoid kernel panic when 802.3ad link brought down. (#146067)
- Update E1000 to 5.6.10.1-k2 (#146115)
- Update E100 to 3.3.6-k2 (#140082, #140116)
- s390: introduces sequence numbers for lcs packets. (#145118)
- Fixes to Intel Enhanced Speedstep support. (#138952)
- ia64 OS_INIT switch support.
- diskdump SATA support.
- NMI switch support for x86-64.

* Wed Feb 23 2005 Dave Jones <davej@redhat.com>
- SATA updates. (#132648, #145107)
- s2io driver update. (#138012)

* Tue Feb 22 2005 Dave Jones <davej@redhat.com>
- Intel ICH7 hardware support (PCI ID additions) (#144741)
- Fix HPET initialisation. (#147224, #134140)
- dm multipath: Add target message ioctl
- dm multipath: ioctl ref by device no
- dm multipath: Split suspend hook
- dm: fix mirror log refcount.
- fix i386 vsyscall-sysenter unwind info
- Add missing lock prefix to switch_to() on x86-64 (#146911)
- Fix PPC64 pSeries VPA registration. (#142634)
- Fix communication to PROM to close stdin on PPC64. (#145134)

* Sat Feb 19 2005 Dave Jones <davej@redhat.com>
- Handle a 64-bit MM being torn down from a 32-bit process. (#144356)
- Move idle loop setup to after main ppc64 arch setup init. (#142634)
- invalidate page race fix. (#140383)
- Fix up AGPGART PCI Posting bugs properly.
- Provide 64-bit translations for 32-bit TIOCMIWAIT/TIOCGICOUNT ioctls
- Fix race condition on s390 when going idle. (#142855, #144317)
- Include watchdog config on s390. (#139836)
- Suppress Error Message on IDE probe.
- Add cpu_relax() calls for various ia64 loops. (#141699)
- Fix oops when io_setup is called with unwritable addr. (#143050)

* Fri Feb 18 2005 Dave Jones <davej@redhat.com>
- AC97 quirk additions & dupicate cleanup.
- Fix Alt-Sysrq-B panics x86/x86_64 (#140792)

* Thu Feb 17 2005 Dave Jones <davej@redhat.com>
- NLM (NFSv3) problems when mounting with "sec=krb5" (#146703)
- Enable OProfile profile support for UP i686 kernel. (#139031)
- Fix stack alignment for signal handlers on ppc64. (#145064)
- Fix leak of percpu data structure on ext2/ext3 umount.
- Fix & clean up zombie/dead task handling & preemption. (#141284)
- Print some extra debugging info on oom_kill. (#142784)
- Fix pty race condition on SMP machine. (#129725)
- Fix up wrong argument order in dma_declare_coherent_memory()
- Fix sysfs_dir_close memory leak.
- Fix md bio refcount leak.
- Fix "RPC: garbage, exit EIO" when using NFSv3 with Kerberos 5 (#142464)
- Fix NFS Direct-IO stack usage. (#142857)

* Mon Feb  7 2005 Dave Jones <davej@redhat.com>
- Export get_sb_pseudo(). (#139436)
- Fix io port security hole on x86-64. (#146244)

* Wed Jan 26 2005 Dave Jones <davej@redhat.com>
- Fix shmctl SHM_LOCK perms. (#144471)
- Various fixes from 2.6.10-ac (#146095, #146101)
- OOM-killer tweak.

* Tue Jan 25 2005 Dave Jones <davej@redhat.com>
- Drop the deprecated SG_IO warning. (#141390)
- Close information leak in sysenter (#146083)
- Fix race in expand stack (CAN-2005-0001) (#144412)

* Mon Jan 17 2005 Dave Jones <davej@redhat.com>
- Fix flaws in IGMP code (CAN-2004-1137) (#142670)
- Fix several corner cases in the 4g4g patch. (#144131, #144658)
- Fix do_brk priveledge escalation. (CAN-2004-1235) (#144136)
- Fix insuffient locking in DRM code. (CAN-2004-1056) (#144391)
- Fix RLIMIT_MEMLOCK bypass and unpriveledged user DoS. (#144528)
- Fix random poolsize sysctl handler integer overflow. (#144532)
- Fix SCSI IOCTL integer overflow and information leak. (#144522)

* Wed Jan  5 2005 Dave Jones <davej@redhat.com>
- Fix AGP data corruption on non-4g4g kernels.

* Tue Jan  4 2005 Dave Jones <davej@redhat.com>
- Fix Tux crash if restarted with live connections that are in a particular
  state. (#140916)
- Fix regression introduced by the recent CMSG security fixes. (#143975)
- Various vm tuning to prevent possibility of OOM kill. (#141173)
  - Lower dirty limit for mappings which can't be cached in highmem
  - Don't oomkill when congested
  - Increment total_scanned var to throttle kswapd
- Prevent panic with CD errors.
- Enable SL82C104 IDE driver as built-in on PPC64 (#131033)

* Wed Dec 29 2004 Dave Jones <davej@redhat.com>
- Call module_upgrade in post stage of of kernel rpm installation.
- Fix bad diskdump interaction with recent sysfs update. (#142321)
- Fix refcounting order in sd/sr, fixing cable pulls on USB storage.

* Sun Dec 12 2004 Dave Jones <davej@redhat.com>
- Prevent kernel panic if an application issues an ioctl with an unrecognized subopcode.
- fix false ECHILD result from wait* with zombie group leader. (#142518)

* Sat Dec 11 2004 Dave Jones <davej@redhat.com>
- Work around broken PCI posting in AGPGART. (#138348)
- Make sure VC resizing fits in s16.

* Fri Dec 10 2004 Dave Jones <davej@redhat.com>
- Update yesterdays SELinux fix. (#142353)
- E1000 64k-alignment fix. (#140047)
- Disable tiglusb module. (#142102)
- ID updates for cciss driver.
- Fix overflows in USB Edgeport-IO driver. (#142258)
- Fix wrong TASK_SIZE for 32bit processes on x86-64. (#141737)
- Fix ext2/ext3 xattr/mbcache race. (#138951)
- Fix bug where __getblk_slow can loop forever when pages are partially mapped. (#140424)
- Add missing cache flushes in agpgart code.

* Thu Dec  9 2004 Dave Jones <davej@redhat.com>
- Prevent block device queues from being shared in viocd. (#139018)
- Libata updates. (#138405)
- aacraid: remove aac_handle_aif (#135527)
- fix uninitialized variable in waitid(2). (#142505)
- Fix CMSG validation checks wrt. signedness.
- Fix memory leak in ip_conntrack_ftp
- [IPV4]: Do not leak IP options. (#142251)
- ppc64: Align PACA buffer for hypervisor's use. (#141817)
- ppc64: Indicate that the veth link is always up. (#135402)
- ppc64: Quiesce OpenFirmware stdin device at boot. (#142009)
- SELinux: Fix avc_node_update oops. (#142353)
- Fix CCISS ioctl return code.
- Make ppc64's pci_alloc_consistent() conform to documentation. (#140047)

* Wed Dec  8 2004 Dave Jones <davej@redhat.com>
- Workaround E1000 post-maturely writing back to TX descriptors. (#133261)
- Fix the previous E1000 errata workaround.
- Several IDE fixes from 2.6.9-ac
- vm pageout throttling. (#133858)

* Tue Dec  7 2004 Dave Jones <davej@redhat.com>
- Fix Tux from oopsing. (#140918)
- Fix Tux/SELinux incompatability (#140916)
- Fix Tux/IPV6 problem. (#140916)
- ide: Fix possible oops on boot.
- Make spinlock debugging panic instead of printk.
- Update Emulex lpfc driver to 8.0.16
- Selected patches from 2.6.9-ac12
- ppc64: Fix inability to find space for TCE table (#138844)
- Fix compat fcntl F_GETLK{,64} (#141680)
- blkdev_get_blocks(): handle eof

* Mon Dec  6 2004 Dave Jones <davej@redhat.com>
- Bump redhat-rpm-config buildreq version.
- Do the Centrino/ACPI changes on x86-64 too.

* Fri Dec  3 2004 Dave Jones <davej@redhat.com>
- Introduce infrastructure for supporting kabi.
- Disable Centrino Speedstep driver.
- Change ACPI cpufreq driver from modular to built-in. (#138952)

* Thu Dec  2 2004 Dave Jones <davej@redhat.com>
- XFRM layer bug fixes
- ppc64: Convert to using ibm,read-slot-reset-state2 RTAS call
- ide: Make CSB6 driver support configurations.
- ide: Handle early EOF on CDs.
- Fix sx8 device naming in sysfs
- e100/e1000: return -EINVAL when setting rx-mini or rx-jumbo. (#140793)

* Wed Dec  1 2004 Dave Jones <davej@redhat.com>
- Workaround for the E1000 erratum 23 (#140047)
- Remove bogus futex warning. (#138179)
- x86_64: Fix lost edge triggered irqs on UP kernel.
- x86_64: Reenable DRI for MGA.
- Workaround E1000 post-maturely writing back to TX descriptors (#133261)
- 3c59x: add EEPROM_RESET for 3c900 Boomerang
- Fix buffer overrun in arch/x86_64/sys_ia32.c:sys32_ni_syscall()
- ext3: improves ext3's error logging when we encounter an on-disk corruption.
- ext3: improves ext3's ability to deal with corruption on-disk
- ext3: Handle double-delete of indirect blocks.
- Disable SCB2 flash driver for RHEL4. (#141142)

* Tue Nov 30 2004 Dave Jones <davej@redhat.com>
- x86_64: add an option to configure oops stack dump
- x86[64]: display phys_proc_id only when it is initialized
- x86_64: no TIOCSBRK/TIOCCBRK in ia32 emulation
- via-rhine: references __init code during resume
- Add barriers to generic timer code to prevent race. (#128242)
- ppc64: Add PURR and version data to /proc/ppc64/lparcfg
- Prevent xtime value becoming incorrect.
- scsi: return full SCSI status byte in SG_IO
- Fix show_trace() in irq context with CONFIG_4KSTACKS
- Adjust alignment of pagevec structure.
- md: make sure md always uses rdev_dec_pending properly.
- Make proc_pid_status not dereference dead task structs.
- sg: Fix oops of sg_cmd_done and sg_release race (#140648)
- fix bad segment coalescing in blk_recalc_rq_segments()
- fix missing security_*() check in net/compat.c
- ia64/x86_64/s390 overlapping vma fix
- Update Emulex lpfc to 8.0.15

* Mon Nov 29 2004 Dave Jones <davej@redhat.com>
- Add another card reader to whitelist. (#141022)
- Fix possible hang in do_wait() (#140042)
- Fix ps showing wrong ppid. (#132030)
- Print advice to use -hugemem if >=16GB of memory is detected.
- Enable ICOM serial driver. (#136150)
- Enable acpi hotplug driver for IA64.
- SCSI: fix USB forced remove oops.
- ia64: add missing sn2 timer mask in time_interpolator code. (#140580)
- ia64: Fix hang reading /proc/pal/cpu0/tr_info (#139571)
- ia64: bump number of UARTS. (#139100)
- Fix ACPI debug level (#141292)
- Make EDD runtime configurable, and reenable.
- ppc64: IBM VSCSI driver race fix. (#138725)
- ppc64: Ensure PPC64 interrupts don't end up hard-disabled. (#139020, #131590)
- ppc64: Yet more sigsuspend/singlestep fixing. (#140102, #137931)
- x86-64: Implement ACPI based reset mechanism. (#139104)
- Backport 2.6.10rc sysfs changes needed for IBM hotplug driver. (#140372)
- Update Emulex lpfc driver to v8.0.14
- Optimize away the unconditional write to debug registers on signal delivery path.
- Fix up scsi_test_unit_ready() to work correctly with CD-ROMs.
- md: fix two little bugs in raid10
- Remove incorrect ELF check from module loading. (#140954)
- Plug leaks in error paths of aic driver.
- Add refcounting to scsi command allocation.
- Taint oopses on machine checks, bad_page()'s calls and forced rmmod's.
- Share Intel cache descriptors between x86 & x86-64.
- rx checksum support for gige nForce ethernet
- vm: vm_dirty_ratio initialisation fix

* Mon Nov 22 2004 Dave Jones <davej@redhat.com>
- Update -ac patch to 2.6.9-ac11
- make tulip_stop_rxtx() wait for DMA to fully stop. (#138240)
- ACPI: Make LEqual less strict about operand types matching.
- scsi: avoid extra 'put' on devices in __scsi_iterate_device() (#138135)
- Fix bugs with SOCK_SEQPACKET AF_UNIX sockets
- Reenable token ring drivers. (#119345)
- SELinux: Map Unix seqpacket sockets to appropriate security class
- SELinux: destroy avtab node cache in policy load error path.
- AF_UNIX: Serialize dgram read using semaphore just like stream.
- lockd: NLM blocks locks don't sleep
- NFS lock recovery fixes
- Add more MODULE_VERSION tags (#136403)
- Update qlogic driver to 2.6.10rc2 level.
- cciss: fixes for clustering
- ieee802.11 update.
- ipw2100: update to ver 1.0.0
- ipw2200: update to ver 1.0.0
- Enable promisc mode on ipw2100
- 3c59x: reload EEPROM values at rmmod for needy cards
- ppc64: Prevent sigsuspend stomping on r4 and r5
- ppc64: Alternative single-step fix.
- fix for recursive netdump oops on x86_64
- ia64: Fix IRQ routing fix when booted with maxcpus=  (#138236)
- ia64: search the iommu for the correct size
- Deal with fraglists correctly on ipv4/ipv6 output
- Various statm accounting fixes (#139447)

* Sat Nov 20 2004 Dave Jones <davej@redhat.com>
- Reenable VESAfb. (#139982)
- Reenable CMM /proc interface for s390 (#137397)

* Fri Nov 19 2004 Dave Jones <davej@redhat.com>
- e100: fix improper enabling of interrupts. (#139706)
- autofs4: allow map update recognition 
- Various TCP fixes from 2.6.10rc
- Various netlink fixes from 2.6.10rc
- [IPV4]: Do not try to unhash null-netdev nexthops.
- ppc64: Make NUMA map CPU->node before bringing up the CPU (#128063)
- ppc64: sched domains / cpu hotplug cleanup. (#128063)
- ppc64: Add a CPU_DOWN_PREPARE hotplug CPU notifier (#128063)
- ppc64: Register a cpu hotplug notifier to reinitialize the
  scheduler domains hierarchy (#128063)
- ppc64: Introduce CPU_DOWN_FAILED notifier (#128063)
- ppc64: Make arch_destroy_sched_domains() conditional (#128063)
- ppc64: Use CPU_DOWN_FAILED notifier in the sched-domains hotplug code (#128063)
- Various updates to the SCSI midlayer from 2.6.10rc.
- vlan_dev: return 0 on vlan_dev_change_mtu success. (#139760)
- Update Emulex lpfc driver to v8.0.13
- Fix problem with b44 driver and 4g/4g patch. (#118165)
- Prevent oops when loading aic79xx on machine without hardware. (#125982)
- Use correct spinlock functions in token ring net code. (#135462)
- scsi: Add reset ioctl capability to ULDs
- scsi: update ips driver to 7.10.18
- Reenable ACPI hotplug driver. (#139976, #140130, #132691)

* Wed Nov 17 2004 Dave Jones <davej@redhat.com>
- Implement an RCU scheme for the SELinux AVC
- Improve on the OOM-killer taming patch.
- device-mapper: Remove duplicate kfree in dm_register_target error path.
- Make SHA1 guard against misaligned accesses
- ASPM workaround for PCIe. (#123360)
- Hot-plug driver updates due to MSI change (#134290)
- Workaround for 80332 IOP hot-plug problem (#139041)
- ExpressCard hot-plug support for ICH6M (#131800)
- Fix boot crash on VIA systems (noted on x86-64)
- PPC64: Store correct backtracking info in ppc64 signal frames
- PPC64: Prevent HVSI from oopsing on hangup (#137912)
- Fix poor performance b/c of noncacheable mapping in 4g/4g (#130842)
- Fix PCI-X hotplug issues (#132852, #134290)
- Re-export force_sig() (#139503)
- Various fixes for more security issues from latest -ac patch.

* Tue Nov 16 2004 Dave Jones <davej@redhat.com>
- Fix d_find_alias brokenness (#137791)
- tg3: Fix fiber hw autoneg bounces (#138738)
- diskdump: Fix issue with NMI watchdog. (#138041)
- diskdump: Export disk_dump_state. (#138132)
- diskdump: Tickle NMI watchdog in diskdump_mdelay() (#138036)
- diskdump: Fix mem= for x86-64 (#138139)
- diskdump: Fix missing system_state setting. (#138130)
- diskdump: Fix diskdump completion message (#138028)
- Re-add aic host raid support.
- Take a few more export removal patches from 2.6.10rc
- SATA: Make AHCI work
- SATA: Core updates.
- S390: Fix Incorrect registers in core dumps. (#138206)
- S390: Fix up lcs device state. (#131167)
- S390: Fix possible qeth IP registration failure.
- S390: Support broadcast on z800/z900 HiperSockets
- S390: Allow FCP port to recover after aborted nameserver request.
- Flush error in pci_mmcfg_write (#129338)
- hugetlb_get_unmapped_area fix (#135364, #129525)
- Fix ia64 cyclone timer on ia64 (#137842, #136684)
- Fix ipv6 MTU calculation. (#130397)
- ACPI: Don't display messages about ACPI breakpoints. (#135856)
- Fix x86_64 copy_user_generic (#135655)
- lockd: remove hardcoded maximum NLM cookie length
- Fix SCSI bounce limit

* Mon Nov 15 2004 Dave Jones <davej@redhat.com>
- Disable polling mode on hotplug controllers in favour of interrupt driven. (#138737)

* Sat Nov 13 2004 Dave Jones <davej@redhat.com>
- Drop some bogus patches.

* Thu Nov 11 2004 Dave Jones <davej@redhat.com>
- NFS: Fix dentry refcount accounting error
- Make sure that modules get signed with the right key.
- Remove SG_IO deprecation warning (#136179)
- s390: Fix fake_ll for qeth device. (#136175)
- s390: User process executing in wrong address-space mode
- s390: zfcp: Kernel stack frame for zfcp_cfdc_dev_ioctl() is too big
- s390: Use slab allocator for DASD I/O pages.
- PPC64: HVSI udbg support
- PPC64: Make HVSI console survive FSP reset
- PPC64: Make PCI hostbridge hotplugging work
- PPC64: Fix IBM VSCSI problems (#138124)

* Wed Nov 10 2004 Dave Jones <davej@redhat.com>
- Fix single-stepping on PPC64
- Integrate kernel-devel changes

* Tue Nov  9 2004 Dave Jones <davej@redhat.com>
- SELinux: netif fixes.
- SELinux: add DAC check to setxattr() hook.
- SELinux: sidtab locking fix.
- SELinux: mediate send_sigurg().
- SELinux: fix setscheduler hook deadlock.
- ide-floppy: Supresses error messages resulting from Medium not present

* Mon Nov  8 2004 Dave Jones <davej@redhat.com>
- Various IA64 updates from 2.6.10rc1
- nfsd: make sure getxattr inode op is non-NULL before calling it.

* Thu Nov  4 2004 Dave Jones <davej@redhat.com>
- Handle NULL dev->dev_addr in SIOCGIFHWADDR correctly. (#137648)
- Fix NFSD domainname size limit.
- nfsd4: nfsd oopsed when encountering a conflict with a local lock
- nfsd4: fix putrootfh return
- nfsd: Insecure port warning shows decimal IPv4 address
- Disable sw irqbalance/irqaffinity for e7520/e7320/e7525 (#136419)
- RAID1 failover hang fix (#136485)
- Add MODULE_VERSION to ixgb driver. (#136399, #137911)

* Tue Nov  2 2004 Dave Jones <davej@redhat.com>
- Fix exec-shield non-PIE/non-prelinked bug.
- ext3 reservations: fix goal hit accounting.
- Fix problems with non-power-of-two sector size discs. (#135094)
- Fix possible oops in netpoll (#132153)
- Add missing MODULE_VERSION tags to various modules. (#136399)
- Add USB card reader de jour. (#124048)

* Mon Nov  1 2004 Dave Jones <davej@redhat.com>
- Fix memory leak on x86-64 in mixed 32/64 mode. (#132947)
- Yet another USB card reader for the whitelist. (#137722)
- Remove a bunch of exports that went away in 2.6.10rc1.

* Fri Oct 29 2004 Dave Jones <davej@redhat.com>
- Stop E820 entries in zero page getting corrupted by EDID info. (#137510)
- Fix raid5 oops (#127862)
- Remove the possibility of some false OOM kills. (#131251)

* Tue Oct 26 2004 Dave Jones <davej@redhat.com>
- Add Intel wireless drivers for Centrino chipsets.

* Mon Oct 25 2004 Dave Jones <davej@redhat.com>
- Add more USB card readers to SCSI whitelist (#131546, #132923)

* Sat Oct 23 2004 Dave Jones <davej@redhat.com>
- Disable CONFIG_SCHED_SMT for iseries.

* Fri Oct 22 2004 Dave Jones <davej@redhat.com>
- Fix PPC NUMA (#130716).
- Fix autoraid for S390 (#123842/#130339)
- Selected bits from 2.6.9-ac3
  - Fix syncppp/async ppp problems with new hangup
  - Fix broken parport_pc unload
  - Stop i8xx_tco making some boxes reboot on load
  - Fix cpia/module tools deadlock
  - Security fix for smbfs leak/overrun

* Thu Oct 21 2004 Dave Jones <davej@redhat.com>
- Misc security fixes from 2.6.9-ac2

* Wed Oct 20 2004 Dave Jones <davej@redhat.com>
- Fix ia64 module loading (#136365)
- Enable CONFIG_PACK_STACK for s390.

* Tue Oct 19 2004 Dave Jones <davej@redhat.com>
- Fix NFS badness (#132726)
- Enable discontigmem for PPC64
- Disable a bunch of irrelevant options for PPC64
- Drop bogus USB workaround. (#131127)

* Mon Oct 18 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9
- Speedtouch USB DSL modem driver update.
- Cleanup some iseries config options.

* Fri Oct 15 2004 Dave Jones <davej@redhat.com>
- 2.6.9-rc4-bk3
- Fix up a bunch of unresolved symbols that crept in recently.
- Remove bogus O_NONBLOCK patch which broke lots of userspace.
- Fix booting on PPC64 by reserving initrd pages.

* Thu Oct 14 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9-rc4-bk2
- librtas needs to work around the /dev/mem restrictions.
- EXT3 reservations use-before-initialised bugfix.
- Merge Emulex LightPulse FC driver.
- support O_NONBLOCK for read,pread,readv of regular files.
- EDD blows up some x86-64's. Disable again.
- Resurrect the hugemem kernel for performance comparisons
  between 3G:1G and 4G:4G address space layouts.
  All non-hugemem kernels are now 3G userspace layout.

* Wed Oct 13 2004 Dave Jones <davej@redhat.com>
- Make EDD driver modular on x86-64 too.
- Various mkinitrd spec changes (Jeremy Katz)
- Enable a bunch more PPC64 config options. (Dave Howells)
- Enable ACPI cpufreq driver for x86-64 too.

* Tue Oct 12 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9-rc4-bk1
- Tux update.
- Update netdump/diskdump patches
- PowerPC 64 netboot changes.
- Various CONFIG_ option diddling.
- Fix up the find_isa_irq_pin() oops on reboot for x86-64 too. 

* Mon Oct 11 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9-rc4
- Enable CONFIG_MICROCODE for x86-64

* Fri Oct  8 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9-rc3-bk8

* Thu Oct  7 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9-rc3-bk7
- Fix up PPC/PPC64 compilation failures due to new binutils. (David Woodhouse)

* Wed Oct  6 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9-rc3-bk6
- Add xattr support for tmpfs.

* Mon Oct  4 2004 Stephen C. Tweedie <sct@redhat.com>
- Update ext3 online resize to 2.6.9-rc3-mm2 upstream
- Reenable ext3 online resize in .spec

* Tue Sep 28 2004 Jeremy Katz <katzj@redhat.com>
- add patch from Roland McGrath/James Morris to fix mprotect hook bug (#133505)

* Mon Sep 20 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc2-bk5

* Thu Sep 16 2004 Arjan van de Ven <arjanv@redhat.com>
- fix tux for x86-64 and ppc64

* Tue Sep 14 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc2
- add diskdump

* Fri Sep 10 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc1-bk17 ; make ppc32 build

* Tue Sep 07 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc1-bk13

* Mon Sep 06 2004 Arjan van de Ven <arjanv@redhat.com>
- disable online resize again
- hopefully fix Quake3 interaction with execshield
- add Alan's borken-bios-IRQ workaround patch

* Sat Sep 04 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc1-bk11

* Tue Aug 31 2004 Arjan van de Ven <arjanv@redhat.com>
- fix execshield buglet with legacy binaries
- 2.6.9-rc1-bk7

* Mon Aug 30 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc1-bk6

* Sat Aug 28 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc1-bk4, now with i915 DRM driver

* Fri Aug 27 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc1-bk2 

* Mon Aug 23 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8.1-bk2

* Sat Aug 21 2004 Arjan van de Ven <arjanv@redhat.com>
- attempt to fix early-udev bug

* Fri Aug 13 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8-rc4-bk3
- split execshield up some more

* Fri Aug 13 2004 Dave Jones <davej@redhat.com>
- Update SCSI whitelist again with some more card readers.

* Mon Aug 9 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8-rc3-bk3

* Wed Aug 4 2004 Arjan van de Ven <arjanv@redhat.com>
- Add the flex-mmap bits for s390/s390x (Pete Zaitcev)
- Add flex-mmap for x86-64 32 bit emulation
- 2.6.8-rc3

* Mon Aug 2 2004 Arjan van de Ven <arjanv@redhat.com>
- Add Rik's token trashing control patch

* Sun Aug 1 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8-rc2-bk11

* Fri Jul 30 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8-rc2-bk8

* Wed Jul 28 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8-rc2-bk6
- make a start at splitting up the execshield patchkit

* Fri Jul 16 2004 Arjan van de Ven <arjanv@redhat.com>
- ppc32 embedded updates

* Thu Jul 15 2004 Arjan van de Ven <arjanv@redhat.com>
- make USB modules again and add Alan's real fix for the SMM-meets-USB bug
- 2.6.8-rc1-bk4

* Wed Jul 14 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8-rc1-bk3

* Tue Jul 13 2004 Arjan van de Ven <arjanv@redhat.com>
- add "enforcemodulesig" boot option to make the kernel load signed modules only

* Mon Jul 12 2004 Arjan van de Ven <arjanv@redhat.com>
- updated voluntary preempt
- 2.6.8-rc1

* Wed Jul 7 2004 Arjan van de Ven <arjanv@redhat.com>
- fix boot breakage that was hitting lots of people (Dave Jones)

* Tue Jul 6 2004 Arjan van de Ven <arjanv@redhat.com>
- add voluntary preemption patch from Ingo
- 2.6.7-bk19

* Tue Jun 29 2004 Arjan van de Ven <arjanv@redhat.com>
- make a start at gpg signed modules support

* Sat Jun 27 2004 Arjan van de Ven <arjanv@redhat.com>
- experiment with making the hardlink call in post more efficient
- 2.6.7-bk9

* Thu Jun 24 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.7-bk7
- Add wli's patch to allocate memory bottom up not top down
- change some config options in the kernel-sourcecode package that are
  good for rpm kernel builds but not for custom user builds to more appropriate 
  default values.
- reenable kernel-sourcecode again for a few builds 

* Wed Jun 23 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.7-bk5
- fix tux unresolved symbols (#126532)

* Mon Jun 21 2004 Arjan van de Ven <arjanv@redhat.com>
- make kernel-doc and kernel-sourcecode builds independent of eachother
- disable kernel-sourcecode builds entirely, we'll be replacing it with documentation
  on how to use the src.rpm instead for building your own kernel.

* Sat Jun 19 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.7-bk2

* Sun Jun 13 2004 Arjan van de Ven <arjanv@redhat.com>
- add patch from DaveM to fix the ppp-keeps-iface-busy bug

* Sat Jun 12 2004 Arjan van de Ven <arjanv@redhat.com>
- add fix from Andi Kleen/Linus for the fpu-DoS

* Thu Jun 10 2004 Arjan van de Ven <arjanv@redhat.com>
- disable mlock-uses-rlimit patch, it has a security hole and needs more thought
- revert airo driver to the FC2 one since the new one breaks

* Tue Jun 8 2004 Dave Jones <davej@redhat.com>
- Update to 2.6.7rc3

* Fri Jun 4 2004 Arjan van de Ven <arjanv@redhat.com>
- fix the mlock-uses-rlimit patch

* Wed Jun 2 2004 David Woodhouse <dwmw2@redhat.com>
- Add ppc64 (Mac G5)

* Wed Jun 2 2004 Arjan van de Ven <arjanv@redhat.com>
- add a forward port of the mlock-uses-rlimit patch
- add NX support for x86 (Intel, Ingo)

* Tue Jun 1 2004 Arjan van de Ven <arjanv@redhat.com>
- refresh ext3 reservation patch

* Sun May 30 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.7-rc2
- set the ACPI OS name to "Microsoft Windows XP" for better compatibility

* Thu May 27 2004 Pete Zaitcev <zaitcev@redhat.com>
- Fix qeth and zfcp (s390 drivers): align qib by 256, embedded into qdio_irq.

* Thu May 27 2004 Dave Jones <davej@redhat.com>
- Fix the crashes on boot on Asus P4P800 boards. (#121819)

* Wed May 26 2004 Dave Jones <davej@redhat.com>
- Lots more updates to the SCSI whitelist for various
  USB card readers. (#112778, among others..)

* Wed May 26 2004 Arjan van de Ven <arjanv@redhat.com>
- back out ehci suspend/resume patch, it breaks
- add fix for 3c59x-meets-kudzu bug from Alan

* Tue May 25 2004 Arjan van de Ven <arjanv@redhat.com>
- try improving suspend/resume by restoring more PCI state
- 2.6.7-rc1-bk1

* Mon May 24 2004 Dave Jones <davej@redhat.com>
- Add yet another multi-card reader to the whitelist (#85851)

* Sun May 23 2004 Dave Jones <davej@redhat.com>
- Add another multi-card reader to the whitelist (#124048)

* Wed May 19 2004 Arjan van de Ven <arjanv@redhat.com>
- put firewire race fix in (datacorruptor)

* Tue May 18 2004 Dave Jones <davej@redhat.com>
- Fix typo in ibmtr driver preventing compile (#123391)

* Mon May 17 2004 Arjan van de Ven <arjanv@redhat.com>
- update to 2.6.6-bk3
- made kernel-source and kernel-doc noarch.rpm's since they are not
  architecture specific.

* Sat May 08 2004 Arjan van de Ven <arjanv@redhat.com>
- fix non-booting on Transmeta cpus (Peter Anvin)
- fix count leak in message queues

* Fri May 07 2004 Arjan van de Ven <arjanv@redhat.com>
- more ide cache flush work
- patch from scsi-bk to fix sd refcounting

* Thu May 06 2004 Arjan van de Ven <arjanv@redhat.com>
- some more ide cache flush fixes 

* Wed May 05 2004 Arjan van de Ven <arjanv@redhat.com>
- fix bug 122504
- convert b44 to ethtool ops (jgarzik)
- make IDE do a cache-flush on shutdown (me/Alan)

* Tue May 04 2004 Arjan van de Ven <arjanv@redhat.com>
- work around i810/i830 DRM issue

* Fri Apr 30 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.6-rc3-bk1
- make amd64 boot again
- fix vm86-vs-4g4g interaction (Ingo)

* Thu Apr 22 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.6-rc2
 
* Tue Apr 20 2004 Arjan van de Ven <arjanv@redhat.com>
- add the ext3 online resize patch

* Mon Apr 19 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.6-rc1-bk3
- add the objrmap vm from the -mm tree; it needs testing

* Thu Apr 15 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-bk2
- disable DISCONTIGMEM on ia64 for performance
- fix sleep_on use in reiserfs (Chris Mason)

* Tue Apr 13 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-mc4
- reenable sg driver for scsi tape changers and such
- the sk98lin driver oopses on module unload, preven that

* Mon Apr 12 2004 Arjan van de Ven <arjanv@redhat.com>
- fix "bad pmd" bug with patch from Ingo

* Fri Apr 09 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-mc3
- finish up the -mc2 merge
- latest 4g/4g patch from Ingo
- latest execshield patch from Ingo
- fix a few framebuffer bugs

* Thu Apr 08 2004 Arjan van de Ven <arjanv@redhat.com>
- first attempt at a 2.6.5-mc2 merge

* Thu Apr 08 2004 Dave Jones <davej@redhat.com>
- Add in missing SiS AGP fix.

* Tue Apr 06 2004 Dave Jones <davej@redhat.com>
- More agpgart fixes.

* Fri Apr 02 2004 Arjan van de Ven <arjanv@redhat.com>
- fix another 4g/4g-vs-resume bug

* Tue Mar 30 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-rc3
- fix PCI posting bug in i830 DRM

* Mon Mar 29 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-rc2-bk8

* Mon Mar 29 2004 Dave Jones <davej@redhat.com>
- Include latest agpgart fixes.

* Thu Mar 25 2004 Arjan van de Ven <arjanv@redhat.com>
- more DRM fixes
- add the fsync patches from akpm

* Tue Mar 23 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-rc2-bk3
- fix direct userspace memory access in i830 drm driver

* Mon Mar 22 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-rc2-bk2
- some stackbloat reductions from Dave and me

* Sat Mar 20 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-rc2

* Tue Mar 16 2004 Dave Jones <davej@redhat.com>
- 2.6.5-rc1

* Mon Mar 15 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.4-bk3
- fix oops in toshiba_acpi (Barry K. Nathan)

* Sat Mar 13 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.4-bk2 merge 

* Thu Mar 11 2004 Arjan van de Ven <arjanv@redhat.com>
- renable sonypi driver that was off accidentally
- 2.6.4-final 
- fix the oops on alsa module unloads

* Wed Mar 10 2004 Arjan van de Ven <arjanv@redhat.com>
- add ppc64/iseries, ppc32 (powermac/ibook) and ia64 architectures
- 2.6.4-rc3 

* Tue Mar 09 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.4-rc2-bk5
- fix nfs-vs-selinux issue
- fix typo in URL as per #117849

* Mon Mar 08 2004 Arjan van de Ven <arjanv@redhat.com>
- fix race in lp.c (#117710)
- 2.6.4-rc2-bk3
- attempt to fix S3 suspend-to-ram with 4g/4g split

* Sat Mar 06 2004 Arjan van de Ven <arjanv@redhat.com>
- fix reiserfs
- set HZ to 1000 again for some tests

* Wed Feb 25 2004 Arjan van de Ven <arjanv@redhat.com>
- merge back a bunch of fedora fixes
- disable audit

* Tue Feb 24 2004 Arjan van de Ven <arjanv@redhat.com>
- audit bugfixes
- update tux to a working version
- 2.6.3-bk5 merge

* Fri Feb 20 2004 Arjan van de Ven <arjanv@redhat.com>
- re-add and enable the Auditing patch
- switch several cpufreq modules to built in since detecting in userspace
  which to use is unpleasant
* Thu Jul 03 2003 Arjan van de Ven <arjanv@redhat.com>
- 2.6 start 
