%{!?kernel:%define kernel %(rpm -q kernel-devel --qf '%{RPMTAG_VERSION}-%{RPMTAG_RELEASE}' | tail -1)}
%define kernel 2.6.9-efw2xenU

%define kversion %(echo "%{kernel}" | sed -e 's|-.*||')
%define krelease %(echo "%{kernel}" | sed -e 's|.*-||')

%define rrelease 8.endian10

Summary: Openswan IPSEC implementation
Name: openswan
Version: 2.4.7
Release: %{rrelease}
Source: http://www.openswan.org/download/%{name}-%{version}.tar.gz
Source1: module.defs
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot
Summary: Openswan IPsec userland tools
Url: http://www.openswan.org/
License: GPL
Group: System Environment/Daemons
Provides: ipsec-userland
Requires: %{name}-driver
BuildRequires: gmp-devel, flex, bison

%description
Openswan is a free implementation of IPSEC & IKE for Linux.

IPsec is Internet Protocol Security and uses strong cryptography to 
provide both authentication and encryption services.  These services 
allow you to build secure tunnels through untrusted networks.  
Everything passing through the untrusted net is encrypted by the ipsec 
gateway machine and decrypted by the gateway at the other end of the 
tunnel.  The resulting tunnel is a virtual private network or VPN.

This package contains also the KLIPS kernel module


%package extras
Summary: Openswan IPSEC implementation
Group: System Environment/Daemons
Requires: %{name} = %{version}-%{release}


%description extras
Openswan is a free implementation of IPSEC & IKE for Linux.

IPsec is Internet Protocol Security and uses strong cryptography to 
provide both authentication and encryption services.  These services 
allow you to build secure tunnels through untrusted networks.  
Everything passing through the untrusted net is encrypted by the ipsec 
gateway machine and decrypted by the gateway at the other end of the 
tunnel.  The resulting tunnel is a virtual private network or VPN.

This package contains the daemons and userland tools for setting up
Openswan on a kernel with the 2.6 native IPsec code.

This package contains ripped down files


%package -n kernel-module-%{name}
Summary: Openswan IPSEC implementation kernel modules
Group: System Environment/Kernel
Release: %{rrelease}_%{kversion}_%{krelease}
Provides: %{name}-driver
Obsoletes: %{name}-modules

%description -n kernel-module-%{name}
Openswan is a free implementation of IPSEC & IKE for Linux.

This package contains the kernel modules for kernel
 %{kversion}-%{krelease} and architecture %{_target_cpu}.


%prep
%setup -q -n openswan-%{version}

cp -f %{SOURCE1} packaging/makefiles/

%build

rm -rf ${RPM_BUILD_ROOT}

FS=$(pwd)

%{__make} \
  USERCOMPILE="-g %{optflags}" \
  KLIPSCOMPILE="-g %{optflags}" \
  KERNELSRC=/lib/modules/%{kversion}-%{krelease}/build \
  INC_USRLOCAL=%{_prefix} \
  MANTREE=%{_mandir} \
  INC_RCDEFAULT=%{_initrddir} \
  module


%install
%{__make} \
  DESTDIR=%{buildroot} \
  INC_USRLOCAL=%{_prefix} \
  INC_RCDEFAULT=%{_initrddir} \
  MANTREE=%{buildroot}%{_mandir} \
  DOCDIR=%{buildroot}/usr/share/doc/openswan-%{version} \
  minstall


%{__mkdir_p} ${RPM_BUILD_ROOT}/lib/modules/%{kversion}-%{krelease}/kernel/net/ipsec
cp modobj26/ipsec.ko ${RPM_BUILD_ROOT}/lib/modules/%{kversion}-%{krelease}/kernel/net/ipsec

find ${RPM_BUILD_ROOT}/lib/modules/ -name '*.ko' -a -type f | xargs gzip -f9

install -d -m700 %{buildroot}%{_localstatedir}/run/pluto
install -d %{buildroot}%{_sbindir}
#install -m755 $RPM_SOURCE_DIR/ipsec.init %{buildroot}/%{_initrddir}/ipsec

find %{buildroot}/etc/ipsec.d -type f -exec chmod 644 {} \;

rm -f %{buildroot}/etc/ipsec.conf %{buildroot}/etc/ipsec.secrets
ln -sf %{_config_root}/vpn/ipsec.conf %{buildroot}/etc/ipsec.conf
ln -sf %{_config_root}/vpn/ipsec.secrets %{buildroot}/etc/ipsec.secrets

rm -rf %{buildroot}/etc/ipsec.d/{cacerts,certs,crls}
ln -sf %{_config_root}/ca    %{buildroot}/etc/ipsec.d/cacerts
ln -sf %{_config_root}/certs %{buildroot}/etc/ipsec.d/certs
ln -sf %{_config_root}/crls  %{buildroot}/etc/ipsec.d/crls


# Fix freeswan docs
mkdir manual
mv %{buildroot}/usr/share/doc/openswan-%{version}/* ./manual
chmod 644 manual/*
rm -rf %{buildroot}/usr/share/doc
rm -rf %{buildroot}%{_sysconfdir}/ipsec.d/examples
rm -rf %{buildroot}%{_sysconfdir}/rc[0-9].d/

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%attr(0644,root,root) %config(noreplace) %{_sysconfdir}/ipsec.conf
%attr(0644,root,root) %config(noreplace) %{_sysconfdir}/ipsec.secrets
%attr(0755,root,root) %dir %{_sysconfdir}/ipsec.d
%dir %{_sysconfdir}/ipsec.d/*
%{_initrddir}/ipsec

# those are links!
%{_sysconfdir}/ipsec.d/cacerts
%{_sysconfdir}/ipsec.d/certs
%{_sysconfdir}/ipsec.d/crls

%dir %{_sysconfdir}/ipsec.d/policies/
%config(noreplace) %{_sysconfdir}/ipsec.d/policies/*

%dir %{_libdir}
%{_libdir}/ipsec
%{_sbindir}/ipsec
%{_libexecdir}/ipsec
%{_localstatedir}/run/pluto


%files -n kernel-module-%{name}
%defattr(-,root,root)
%dir /lib/modules/%{kversion}-%{krelease}
/lib/modules/%{kversion}-%{krelease}/*


%files extras
%defattr(-,root,root)
%doc BUGS CHANGES COPYING CREDITS README 
%doc doc/README.* doc/CHANGES.* doc/CREDITS.* doc/2.6.known-issues
%doc doc/examples doc/std doc/quickstarts manual
%{_mandir}
/etc/rc.d/rc*


%pre
if [ ! -L %{_sysconfdir}/ipsec.d/cacerts ]; then
    rm -Rf %{_sysconfdir}/ipsec.d/cacerts
fi
if [ ! -L %{_sysconfdir}/ipsec.d/certs ]; then
    rm -Rf %{_sysconfdir}/ipsec.d/certs
fi
if [ ! -L %{_sysconfdir}/ipsec.d/crls ]; then
    rm -Rf %{_sysconfdir}/ipsec.d/crls
fi
exit 0


%post -n kernel-module-%{name}
/sbin/depmod -ae %{kversion}-%{krelease} -F /boot/System.map-%{kversion}-%{krelease} || :

%postun -n kernel-module-%{name}
[ -e /boot/System.map-%{kversion}-%{krelease} ] && /sbin/depmod -ae %{kversion}-%{krelease} -F /boot/System.map-%{kversion}-%{krelease} || :


%changelog
* Sun Dec 24 2006 Peter Warasin <peter@€ndian.it>
- upgrade to 2.4.7 since 2.4.4 does not accept psfgroup configuration option

* Thu Jan 12 2006 Peter Warasin <peter@endian.it>
- move initscript to init.d

* Wed Jan 04 2006 Peter Warasin <peter@endian.it>
- Rename kernel module subpackages

* Tue Dec 27 2005 Peter Warasin <peter@endian.it>
- fix cpio error on unpacking links
- upgraded to 2.4.4, fixes vulnerabilities of
  NISCC Advisory 3756/NISCC/ISAKMP 

* Thu Oct 06 2005 Peter Warasin <peter@endian.it>
- removed unneeded rc.d files

* Sun Jul 31 2005 Peter Warasin <peter@endian.it>
- added missing links to file list

* Sun Jul 10 2005 Peter Warasin <peter@endian.it>
- added modules directory to %files list
- re-enabled KLIPS_IPCOMP, since it contains needed symbols

* Fri Jul 08 2005 Peter Warasin <peter@endian.it>
- disabled KLIPS_IPCOMP
- added ipcoute patch which replaces calls of ifconfig/netstat with iproute

* Tue Jul 05 2005 Peter Warasin <peter@endian.it>
- added check if the old System.map does exist

* Fri Jul 01 2005 Peter Warasin <peter@endian.it> 2.3.1
- splitted away openswan-modules and openswan-modules-smp

* Thu Jun 30 2005 Peter Warasin <peter@endian.it> 2.3.1
- upgraded to 2.3.1
- adapted for endian firewall
- Initial version, based on FC-3 .spec

